/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Entry;

public abstract class PropertyData
implements Entry {
    public static PropertyData readPropertyData(byte type, LittleEndianInput input) throws IOException {
        assert (input.available() > 0);
        if (type < 10) {
            switch (type) {
                case 0: {
                    return new NullData(input);
                }
                case 1: {
                    return new ObjectData(input);
                }
                case 2: {
                    return new StringData(input);
                }
                case 3: {
                    return new IntData(input);
                }
                case 4: {
                    return new FloatData(input);
                }
                case 5: {
                    return new BoolData(input);
                }
            }
            throw new IOException(String.format("Invalid property type: %d", type));
        }
        ArrayData array = new ArrayData(input);
        int itemCount = input.readInt();
        assert (0 <= itemCount);
        switch (type) {
            case 11: {
                for (int i = 0; i < itemCount; ++i) {
                    ObjectData data = new ObjectData(input);
                    array.DATA.add(data);
                }
                return array;
            }
            case 12: {
                for (int i = 0; i < itemCount; ++i) {
                    StringData data = new StringData(input);
                    array.DATA.add(data);
                }
                return array;
            }
            case 13: {
                for (int i = 0; i < itemCount; ++i) {
                    IntData data = new IntData(input);
                    array.DATA.add(data);
                }
                return array;
            }
            case 14: {
                for (int i = 0; i < itemCount; ++i) {
                    FloatData data = new FloatData(input);
                    array.DATA.add(data);
                }
                return array;
            }
            case 15: {
                for (int i = 0; i < itemCount; ++i) {
                    BoolData data = new BoolData(input);
                    array.DATA.add(data);
                }
                return array;
            }
        }
        throw new IOException();
    }

    public static class BoolData
    extends PropertyData {
        private final boolean DATA;

        public BoolData(LittleEndianInput input) throws IOException {
            this.DATA = input.readBoolean();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeBoolean(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 1;
        }
    }

    public static class FloatData
    extends PropertyData {
        private final float DATA;

        public FloatData(LittleEndianInput input) throws IOException {
            this.DATA = input.readFloat();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeFloat(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 4;
        }
    }

    public static class IntData
    extends PropertyData {
        private final int DATA;

        public IntData(LittleEndianInput input) throws IOException {
            this.DATA = input.readInt();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 4;
        }
    }

    public static class StringData
    extends PropertyData {
        private final String DATA;

        public StringData(LittleEndianInput input) throws IOException {
            this.DATA = input.readUTF();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeUTF(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 2 + this.DATA.length();
        }
    }

    public static class ObjectData
    extends PropertyData {
        private final long DATA;

        public ObjectData(LittleEndianInput input) throws IOException {
            this.DATA = input.readLong();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeLong(this.DATA);
        }

        @Override
        public int calculateSize() {
            return 8;
        }
    }

    public static class ArrayData<T extends PropertyData>
    extends PropertyData {
        public final List<T> DATA = new LinkedList<T>();

        public ArrayData(LittleEndianInput input) throws IOException {
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.DATA.size());
            for (PropertyData t : this.DATA) {
                t.write(output);
            }
        }

        @Override
        public int calculateSize() {
            int sum = 4;
            return sum += this.DATA.stream().mapToInt(t -> t.calculateSize()).sum();
        }
    }

    public static class NullData
    extends PropertyData {
        public NullData(LittleEndianInput input) throws IOException {
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
        }

        @Override
        public int calculateSize() {
            return 0;
        }
    }
}

