/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import restringer.BoundedLittleEndianInput;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Entry;
import restringer.esp.Field;
import restringer.esp.FieldBasic;
import restringer.esp.FieldEDID;
import restringer.esp.FieldFull;
import restringer.esp.FieldName;
import restringer.esp.FieldVMAD;
import restringer.esp.FieldXXXX;
import restringer.esp.RecordBasic;
import restringer.esp.RecordCode;
import restringer.esp.RecordCompressed;
import restringer.esp.RecordGrup;
import restringer.esp.RecordTes4;

public abstract class Record
implements Entry {
    public static final List<Field> readFields(RecordCode parentCode, LittleEndianInput input, RecordTes4 tes4) throws IOException {
        LinkedList<Field> FIELDS = new LinkedList<Field>();
        while (input.available() > 0) {
            List<Field> fieldsRead = Record.readField(parentCode, input, tes4);
            FIELDS.addAll(fieldsRead);
        }
        return FIELDS;
    }

    public static final List<Field> readField(RecordCode parentCode, LittleEndianInput input, RecordTes4 tes4) throws IOException {
        return Record.readFieldAux(parentCode, input, 0, tes4);
    }

    private static final List<Field> readFieldAux(RecordCode parentCode, LittleEndianInput input, int bigSize, RecordTes4 tes4) throws IOException {
        assert (input.available() > 0);
        byte[] CODEBYTES = new byte[4];
        input.readFully(CODEBYTES);
        IString CODE = IString.get(new String(CODEBYTES));
        boolean BIG = bigSize > 0;
        int DATASIZE = input.readUnsignedShort();
        int ACTUALSIZE = BIG ? bigSize : DATASIZE;
        BoundedLittleEndianInput FIELDINPUT = new BoundedLittleEndianInput(input, ACTUALSIZE);
        ArrayList<Field> fields = new ArrayList<Field>();
        if (CODE.equals(IString.get("XXXX"))) {
            FieldXXXX xxxx = new FieldXXXX(CODE, FIELDINPUT);
            List<Field> fieldsRead = Record.readFieldAux(parentCode, input, xxxx.getData(), tes4);
            fields.add(xxxx);
            fields.addAll(fieldsRead);
        } else if (CODE.equals(IString.get("VMAD"))) {
            FieldVMAD field = new FieldVMAD(parentCode, CODE, FIELDINPUT, BIG);
            fields.add(field);
        } else if (CODE.equals(IString.get("EDID"))) {
            FieldEDID field = new FieldEDID(CODE, FIELDINPUT, ACTUALSIZE, BIG, tes4);
            fields.add(field);
        } else if (CODE.equals(IString.get("FULL"))) {
            FieldFull field = new FieldFull(CODE, FIELDINPUT, ACTUALSIZE, BIG, tes4);
            fields.add(field);
        } else if (CODE.equals(IString.get("NAME")) && (parentCode == RecordCode.ACHR || parentCode == RecordCode.REFR)) {
            FieldName field = new FieldName(CODE, FIELDINPUT, ACTUALSIZE, BIG, tes4);
            fields.add(field);
        } else {
            FieldBasic field = new FieldBasic(CODE, FIELDINPUT, ACTUALSIZE, BIG);
            fields.add(field);
        }
        return fields;
    }

    public abstract RecordCode getCode();

    public static Record readRecord(LittleEndianInput input, RecordTes4 tes4) throws IOException {
        if (input.available() < 24) {
            throw new IOException();
        }
        byte[] CODEBYTES = new byte[4];
        input.readFully(CODEBYTES);
        String CODESTRING = new String(CODEBYTES);
        RecordCode CODE = RecordCode.valueOf(CODESTRING);
        int DATASIZE = input.readInt();
        if (CODE == RecordCode.GRUP) {
            byte[] HEADER = new byte[16];
            input.readFully(HEADER);
            BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE - 24);
            return new RecordGrup(CODE, HEADER, RECORDINPUT, tes4);
        }
        Header HEADER = new Header(input, tes4);
        BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE);
        if (HEADER.isCompressed()) {
            return new RecordCompressed(CODE, HEADER, RECORDINPUT, tes4);
        }
        return new RecordBasic(CODE, HEADER, RECORDINPUT, tes4);
    }

    public static void skimRecord(LittleEndianInput input, RecordTes4 tes4) throws IOException {
        if (input.available() < 24) {
            throw new IOException();
        }
        byte[] CODEBYTES = new byte[4];
        input.readFully(CODEBYTES);
        String CODESTRING = new String(CODEBYTES);
        RecordCode CODE = RecordCode.valueOf(CODESTRING);
        int DATASIZE = input.readInt();
        if (CODE == RecordCode.GRUP) {
            byte[] HEADER = new byte[16];
            input.readFully(HEADER);
            BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE - 24);
            RecordGrup.skimGRUP(CODE, HEADER, RECORDINPUT, tes4);
        } else {
            Header HEADER = new Header(input, tes4);
            BoundedLittleEndianInput RECORDINPUT = new BoundedLittleEndianInput(input, DATASIZE);
            if (HEADER.isCompressed()) {
                RecordCompressed.skimRecord(CODE, HEADER, RECORDINPUT, tes4);
            } else {
                RecordBasic.skimRecord(CODE, HEADER, RECORDINPUT, tes4);
            }
        }
    }

    public static class Header
    implements Entry {
        public final int FLAGS;
        public final int ID;
        public final int REVISION;
        public final short VERSION;
        public final short UNKNOWN;

        public Header(LittleEndianInput input, RecordTes4 tes4) throws IOException {
            int newID;
            this.FLAGS = input.readInt();
            int id = input.readInt();
            this.ID = newID = null == tes4 ? id : tes4.remapFormID(id);
            this.REVISION = input.readInt();
            this.VERSION = input.readShort();
            this.UNKNOWN = input.readShort();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.FLAGS);
            output.writeInt(this.ID);
            output.writeInt(this.REVISION);
            output.writeShort(this.VERSION);
            output.writeShort(this.UNKNOWN);
        }

        @Override
        public int calculateSize() {
            return 16;
        }

        public boolean isCompressed() {
            return (this.FLAGS & 0x40000) != 0;
        }

        public boolean isLocalized() {
            return (this.FLAGS & 0x80) != 0;
        }
    }
}

