/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Field;
import restringer.esp.Record;
import restringer.esp.RecordCode;
import restringer.esp.RecordTes4;

public class RecordBasic
extends Record {
    private final RecordCode CODE;
    private final Record.Header HEADER;
    private final List<Field> FIELDS;

    public static void skimRecord(RecordCode recordCode, Record.Header header, LittleEndianInput input, RecordTes4 tes4) throws IOException {
        List<Field> fieldsRead = Record.readFields(recordCode, input, tes4);
        tes4.IDMAP.addRecord(header.ID, fieldsRead);
    }

    public RecordBasic(RecordCode recordCode, Record.Header header, LittleEndianInput input, RecordTes4 tes4) throws IOException {
        this.CODE = recordCode;
        this.HEADER = header;
        List<Field> fieldsRead = Record.readFields(recordCode, input, tes4);
        this.FIELDS = new ArrayList<Field>(fieldsRead);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.write(this.CODE.toString().getBytes());
        output.writeInt(this.calculateSize() - 24);
        this.HEADER.write(output);
        for (Field field : this.FIELDS) {
            field.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 24;
        return sum += this.FIELDS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    @Override
    public RecordCode getCode() {
        return this.CODE;
    }

    public Record.Header getHeader() {
        return this.HEADER;
    }

    public String toString() {
        return this.getCode().toString();
    }
}

