/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.esp.Field;
import restringer.esp.Record;
import restringer.esp.RecordCode;
import restringer.esp.RecordTes4;

public class RecordCompressed
extends Record {
    private final RecordCode CODE;
    private final Record.Header HEADER;
    private final List<Field> FIELDS;
    private static final Deflater DEFLATER = new Deflater(9);

    public static void skimRecord(RecordCode recordCode, Record.Header header, LittleEndianInput input, RecordTes4 tes4) throws IOException {
        assert (input.available() > 0);
        List<Field> fieldsRead = RecordCompressed.decompressFields(recordCode, header, input, tes4);
        tes4.IDMAP.addRecord(header.ID, fieldsRead);
    }

    public RecordCompressed(RecordCode recordCode, Record.Header header, LittleEndianInput input, RecordTes4 tes4) throws IOException {
        assert (input.available() > 0);
        this.CODE = recordCode;
        this.HEADER = header;
        List<Field> fieldsRead = RecordCompressed.decompressFields(recordCode, header, input, tes4);
        this.FIELDS = new ArrayList<Field>(fieldsRead);
    }

    private byte[] getUncompressedData() throws IOException {
        ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
        LittleEndianDataOutput OUTPUT = new LittleEndianDataOutput(BAOS);
        for (Field field : this.FIELDS) {
            field.write(OUTPUT);
        }
        return BAOS.toByteArray();
    }

    private byte[] getCompressedData(byte[] rawData) throws IOException {
        DEFLATER.reset();
        DEFLATER.setInput(rawData);
        DEFLATER.finish();
        byte[] BUFFER = new byte[1024];
        ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
        while (!DEFLATER.finished()) {
            int count = DEFLATER.deflate(BUFFER);
            BAOS.write(BUFFER, 0, count);
        }
        return BAOS.toByteArray();
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.write(this.CODE.toString().getBytes());
        byte[] UNCOMPRESSED_DATA = this.getUncompressedData();
        byte[] COMPRESSED_DATA = this.getCompressedData(UNCOMPRESSED_DATA);
        int UNCOMPRESSED_SIZE = UNCOMPRESSED_DATA.length;
        int COMPRESSED_SIZE = COMPRESSED_DATA.length;
        output.writeInt(4 + COMPRESSED_SIZE);
        this.HEADER.write(output);
        output.writeInt(UNCOMPRESSED_SIZE);
        output.write(COMPRESSED_DATA);
    }

    @Override
    public int calculateSize() {
        byte[] COMPRESSED_DATA;
        int sum = 28;
        try {
            byte[] UNCOMPRESSED_DATA = this.getUncompressedData();
            COMPRESSED_DATA = this.getCompressedData(UNCOMPRESSED_DATA);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return sum += COMPRESSED_DATA.length;
    }

    @Override
    public RecordCode getCode() {
        return this.CODE;
    }

    public String toString() {
        return this.getCode().toString();
    }

    private static List<Field> decompressFields(RecordCode code, Record.Header header, LittleEndianInput input, RecordTes4 tes4) throws IOException {
        int DECOMPRESSED_SIZE = input.readInt();
        int COMPRESSED_SIZE = input.available();
        byte[] COMPRESSED = new byte[COMPRESSED_SIZE];
        int bytesRead = input.read(COMPRESSED);
        assert (bytesRead == COMPRESSED_SIZE) : "Read " + COMPRESSED.length + " bytes, expected " + COMPRESSED_SIZE;
        Inflater INFLATER = new Inflater();
        INFLATER.setInput(COMPRESSED);
        try {
            int bytesInflated;
            ByteArrayOutputStream INFLATION_BUFFER = new ByteArrayOutputStream();
            byte[] BUF = new byte[1024];
            do {
                bytesInflated = INFLATER.inflate(BUF);
                INFLATION_BUFFER.write(BUF, 0, bytesInflated);
            } while (bytesInflated > 0);
            byte[] DECOMPRESSED = INFLATION_BUFFER.toByteArray();
            assert (DECOMPRESSED.length == DECOMPRESSED_SIZE) : "Decompressed " + DECOMPRESSED.length + " bytes, expected " + DECOMPRESSED_SIZE;
            LittleEndianInputStream INPUT2 = LittleEndianInputStream.wrap(DECOMPRESSED);
            List<Field> list = Record.readFields(code, INPUT2, tes4);
            return list;
        }
        catch (DataFormatException ex) {
            throw new IOException(ex);
        }
        finally {
            INFLATER.end();
        }
    }
}

