/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import restringer.BoundedLittleEndianInput;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.Field;
import restringer.esp.FieldBasic;
import restringer.esp.Record;
import restringer.esp.RecordCode;

public class RecordTes4
extends Record {
    public final int INDEX;
    public final String NAME;
    public final List<String> MASTERS;
    public final Map<String, Integer> ESPs;
    public final ESPIDMap IDMAP;
    private final RecordCode CODE = RecordCode.TES4;
    private final Record.Header HEADER;
    private final List<Field> FIELDS;

    public RecordTes4(LittleEndianInput input, int index, String name, List<String> espList) throws IOException {
        this.INDEX = index;
        this.NAME = name;
        this.IDMAP = new ESPIDMap("name");
        byte[] CODEBYTES = new byte[4];
        input.readFully(CODEBYTES);
        String CODESTRING = new String(CODEBYTES);
        assert (CODESTRING.equals("TES4"));
        int DATASIZE = input.readInt();
        this.HEADER = new Record.Header(input, null);
        BoundedLittleEndianInput FIELDINPUT = new BoundedLittleEndianInput(input, DATASIZE);
        LinkedList<String> masters = new LinkedList<String>();
        this.FIELDS = new LinkedList<Field>();
        while (((LittleEndianInput)FIELDINPUT).available() > 0) {
            List<Field> fields = Record.readField(RecordCode.TES4, FIELDINPUT, null);
            if (fields.get(0).getCode().equals(IString.get("MAST"))) {
                FieldBasic mast = (FieldBasic)fields.get(0);
                String master = mast.getDecoder().readZString();
                masters.add(master);
            }
            this.FIELDS.addAll(fields);
        }
        this.MASTERS = Collections.unmodifiableList(new ArrayList(masters));
        HashMap<String, Integer> esps = new HashMap<String, Integer>(espList.size());
        for (int i = 0; i < espList.size(); ++i) {
            esps.put(espList.get(i), i);
        }
        this.ESPs = Collections.unmodifiableMap(esps);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.write(this.CODE.toString().getBytes());
        output.writeInt(this.calculateSize() - 24);
        this.HEADER.write(output);
        for (Field field : this.FIELDS) {
            field.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 24;
        return sum += this.FIELDS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    @Override
    public RecordCode getCode() {
        return this.CODE;
    }

    public Record.Header getHeader() {
        return this.HEADER;
    }

    public String toString() {
        return this.getCode().toString();
    }

    public int remapFormID(int id) {
        int originalIndex = id >>> 24;
        assert (0 <= originalIndex && originalIndex < 256);
        String originalMod = originalIndex < this.MASTERS.size() ? this.MASTERS.get(originalIndex) : this.NAME;
        if (!this.ESPs.containsKey(originalMod)) {
            return 0xFF000000 | id;
        }
        int newIndex = this.ESPs.getOrDefault(originalMod, -1);
        int newID = id & 0xFFFFFF | newIndex << 24;
        return newID;
    }
}

