/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.Entry;
import restringer.esp.PropertyData;

public class Script
implements Entry {
    private final IString NAME;
    private final byte STATUS;
    final List<Property> PROPERTIES;

    public Script(LittleEndianInput input) throws IOException {
        this.NAME = IString.get(input.readUTF());
        this.STATUS = input.readByte();
        this.PROPERTIES = new LinkedList<Property>();
        try {
            int propertyCount = input.readUnsignedShort();
            for (int i = 0; i < propertyCount; ++i) {
                Property prop = new Property(input);
                this.PROPERTIES.add(prop);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error reading script " + this.NAME, ex);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output.writeUTF(this.NAME.toString());
        output.writeByte(this.STATUS);
        output.writeShort(this.PROPERTIES.size());
        for (Property prop : this.PROPERTIES) {
            prop.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 5 + this.NAME.length();
        return sum += this.PROPERTIES.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    public class Property
    implements Entry {
        private final IString NAME;
        private final byte TYPE;
        private final byte STATUS;
        private final PropertyData DATA;

        public Property(LittleEndianInput input) throws IOException {
            this.NAME = IString.get(input.readUTF());
            this.TYPE = input.readByte();
            this.STATUS = input.readByte();
            try {
                this.DATA = PropertyData.readPropertyData(this.TYPE, input);
            }
            catch (IOException ex) {
                throw new IOException("Error data for reading property " + this.NAME, ex);
            }
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeUTF(this.NAME.toString());
            output.writeByte(this.TYPE);
            output.writeByte(this.STATUS);
            this.DATA.write(output);
        }

        @Override
        public int calculateSize() {
            int sum = 4 + this.NAME.length() + this.DATA.calculateSize();
            return sum;
        }
    }
}

