/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Objects;
import java.util.regex.Pattern;
import restringer.esp.StringsFile;

public class StringTable {
    private final Int2ObjectMap<String> TABLE = Int2ObjectMaps.synchronize(new Int2ObjectOpenHashMap());

    public void populateFromFile(StringsFile file, int index) {
        Objects.requireNonNull(file);
        Int2ObjectOpenHashMap temp = new Int2ObjectOpenHashMap(file.getMap().size());
        file.getMap().forEach((id, str) -> {
            int newID = index << 24 | id & 0xFFFFFF;
            temp.put(newID, str);
        });
        this.TABLE.putAll(temp);
    }

    public Int2ObjectMap<String> getMap() {
        return Int2ObjectMaps.unmodifiable(this.TABLE);
    }

    public String get(int formID) {
        return (String)this.TABLE.get(formID);
    }

    private static enum Type {
        STRINGS(Pattern.compile(".+\\.STRINGS$", 2)),
        ILSTRINGS(Pattern.compile(".+\\.ILSTRINGS$", 2)),
        DLSTRINGS(Pattern.compile(".+\\.DLSTRINGS$", 2));

        public final Pattern REGEX;

        static Type match(String filename) {
            if (Type.STRINGS.REGEX.asPredicate().test(filename)) {
                return STRINGS;
            }
            if (Type.ILSTRINGS.REGEX.asPredicate().test(filename)) {
                return ILSTRINGS;
            }
            if (Type.DLSTRINGS.REGEX.asPredicate().test(filename)) {
                return DLSTRINGS;
            }
            return null;
        }

        private Type(Pattern regex) {
            this.REGEX = Objects.requireNonNull(regex);
        }
    }
}

