/*
 * Decompiled with CFR 0.152.
 */
package restringer.esp;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.regex.Pattern;
import restringer.LittleEndianInput;
import restringer.Pair;

public class StringsFile {
    private final Int2ObjectMap<String> TABLE;
    private final ArrayList<Pair<Integer, String>> LIST;
    private final String NAME;

    public StringsFile(String name, LittleEndianInput input, Type type) throws IOException {
        long DATASECTION;
        Objects.requireNonNull(input);
        Objects.requireNonNull(type);
        this.NAME = name;
        int COUNT = input.readInt();
        int DATASIZE = input.readInt();
        long[] OFFSETS = new long[COUNT];
        for (int i = 0; i < COUNT; ++i) {
            long CODE;
            int ID2;
            int FORMID = ID2 = input.readInt();
            int OFFSET = input.readInt();
            OFFSETS[i] = CODE = (long)OFFSET << 32 | (long)FORMID;
        }
        Arrays.sort(OFFSETS);
        this.TABLE = new Int2ObjectOpenHashMap<String>(COUNT);
        long filePointer = DATASECTION = (long)(8 + COUNT * 8);
        int prevOffset = -1;
        String str = null;
        for (int i = 0; i < OFFSETS.length; ++i) {
            long code = OFFSETS[i];
            int formID = (int)code;
            int currOffset = (int)(code >>> 32);
            if (currOffset == prevOffset) {
                this.TABLE.put(formID, str);
                continue;
            }
            assert (filePointer == DATASECTION + (long)currOffset) : String.format("Error reading string %d at position %d.", formID, filePointer);
            try {
                if (type == Type.STRINGS) {
                    str = input.readZString();
                    filePointer += (long)(str.length() + 1);
                } else {
                    str = input.readLZString();
                    filePointer += (long)(str.length() + 5);
                }
                this.TABLE.put(formID, str);
                prevOffset = currOffset;
                continue;
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error reading string %d at position %d.", formID, filePointer));
            }
        }
        this.LIST = new ArrayList(this.TABLE.size());
        this.TABLE.forEach((id, s) -> {
            Pair<Integer, String> p = new Pair<Integer, String>((Integer)id, (String)s);
            this.LIST.add(p);
        });
        Collections.sort(this.LIST, (p1, p2) -> ((Integer)p1.A).compareTo((Integer)p2.A));
    }

    public Int2ObjectMap<String> getMap() {
        return Int2ObjectMaps.unmodifiable(this.TABLE);
    }

    public String get(int formID) {
        return (String)this.TABLE.get(formID);
    }

    public String toString() {
        return this.NAME;
    }

    public static enum Type {
        STRINGS(Pattern.compile(".+\\.STRINGS$", 2)),
        ILSTRINGS(Pattern.compile(".+\\.ILSTRINGS$", 2)),
        DLSTRINGS(Pattern.compile(".+\\.DLSTRINGS$", 2));

        private final Pattern REGEX;

        public static Type match(String filename) {
            if (Type.STRINGS.REGEX.asPredicate().test(filename)) {
                return STRINGS;
            }
            if (Type.ILSTRINGS.REGEX.asPredicate().test(filename)) {
                return ILSTRINGS;
            }
            if (Type.DLSTRINGS.REGEX.asPredicate().test(filename)) {
                return DLSTRINGS;
            }
            return null;
        }

        private Type(Pattern regex) {
            this.REGEX = Objects.requireNonNull(regex);
        }
    }
}

