/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;

public final class ChangeFormFlags
implements Element {
    private final int FLAG;
    private final short UNKNOWN;

    public ChangeFormFlags(LittleEndianInput input) throws IOException {
        Objects.requireNonNull(input);
        this.FLAG = input.readInt();
        this.UNKNOWN = input.readShort();
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeInt(this.FLAG);
        output.writeShort(this.UNKNOWN);
    }

    @Override
    public int calculateSize() {
        return 6;
    }

    public int getFlag() {
        return this.FLAG;
    }

    public short getUnknown() {
        return this.UNKNOWN;
    }

    public String toString() {
        int idx;
        StringBuilder BUF = new StringBuilder();
        String S = Integer.toUnsignedString(this.FLAG, 2);
        for (idx = 0; idx < 32 - S.length(); ++idx) {
            if (idx > 0 && idx % 4 == 0) {
                BUF.append(' ');
            }
            BUF.append('0');
        }
        while (idx < 32) {
            if (idx > 0 && idx % 4 == 0) {
                BUF.append(' ');
            }
            BUF.append(S.charAt(idx - 32 + S.length()));
        }
        return BUF.toString();
    }
}

