/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.Profile;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ChangeFormData;
import restringer.ess.ChangeFormFlags;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Flags;
import restringer.ess.RefID;
import restringer.ess.VSVal;
import restringer.ess.WString;

public class ChangeFormNPC
extends ChangeFormData {
    private final byte[] BUFFER;
    private final ChangeFormFlags FLAGS;
    private final byte[] ACBS;
    private final byte[] AIDT;
    private final byte[] DNAM;
    private final VSVal NUMFACTIONRANKS;
    private final ArrayList<FactionRank> FACTIONRANKS;
    private final VSVal SPELLCOUNT;
    private final VSVal LEVELLEDSPELLCOUNT;
    private final VSVal SHOUTCOUNT;
    private final ArrayList<RefID> SPELLS;
    private final ArrayList<RefID> LEVELLEDSPELLS;
    private final ArrayList<RefID> SHOUTS;
    private final WString FULLNAME;
    private final RefID CCLASS;
    private final RefID RACE;
    private final RefID OLDRACE;
    private final RefID DEFOUTFIT;
    private final RefID SLEEPOUTFIT;
    private final byte GENDER;
    private final FaceData FACE;

    public ChangeFormNPC(byte[] buf, Flags.Int flags) throws IOException {
        int i;
        this.BUFFER = Objects.requireNonNull(buf);
        LittleEndianInputStream input = LittleEndianInputStream.wrap(buf);
        this.FLAGS = flags.getFlag(0) ? new ChangeFormFlags(input) : null;
        if (flags.getFlag(1)) {
            this.ACBS = new byte[24];
            ((LittleEndianInput)input).read(this.ACBS);
        } else {
            this.ACBS = null;
        }
        if (flags.getFlag(6)) {
            this.NUMFACTIONRANKS = new VSVal(input);
            this.FACTIONRANKS = new ArrayList();
            for (i = 0; i < this.NUMFACTIONRANKS.getValue(); ++i) {
                FactionRank rank = new FactionRank(input);
                this.FACTIONRANKS.add(rank);
            }
        } else {
            this.NUMFACTIONRANKS = null;
            this.FACTIONRANKS = null;
        }
        if (flags.getFlag(4)) {
            RefID ref;
            this.SPELLCOUNT = new VSVal(input);
            this.SPELLS = new ArrayList();
            for (i = 0; i < this.SPELLCOUNT.getValue(); ++i) {
                ref = new RefID(input);
                this.SPELLS.add(ref);
            }
            this.LEVELLEDSPELLCOUNT = new VSVal(input);
            this.LEVELLEDSPELLS = new ArrayList();
            for (i = 0; i < this.LEVELLEDSPELLCOUNT.getValue(); ++i) {
                ref = new RefID(input);
                this.SPELLS.add(ref);
            }
            this.SHOUTCOUNT = new VSVal(input);
            this.SHOUTS = new ArrayList();
            for (i = 0; i < this.SHOUTCOUNT.getValue(); ++i) {
                ref = new RefID(input);
                this.SHOUTS.add(ref);
            }
        } else {
            this.SPELLCOUNT = null;
            this.LEVELLEDSPELLCOUNT = null;
            this.SHOUTCOUNT = null;
            this.SPELLS = null;
            this.LEVELLEDSPELLS = null;
            this.SHOUTS = null;
        }
        if (flags.getFlag(3)) {
            this.AIDT = new byte[20];
            ((LittleEndianInput)input).read(this.AIDT);
        } else {
            this.AIDT = null;
        }
        this.FULLNAME = flags.getFlag(5) ? WString.read(input) : null;
        if (flags.getFlag(9)) {
            this.DNAM = new byte[52];
            ((LittleEndianInput)input).read(this.DNAM);
        } else {
            this.DNAM = null;
        }
        this.CCLASS = flags.getFlag(10) ? new RefID(input) : null;
        if (flags.getFlag(25)) {
            this.RACE = new RefID(input);
            this.OLDRACE = new RefID(input);
        } else {
            this.RACE = null;
            this.OLDRACE = null;
        }
        this.FACE = flags.getFlag(11) ? new FaceData(input) : null;
        this.GENDER = flags.getFlag(24) ? input.readByte() : (byte)0;
        this.DEFOUTFIT = flags.getFlag(12) ? new RefID(input) : null;
        this.SLEEPOUTFIT = flags.getFlag(13) ? new RefID(input) : null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.write(this.BUFFER);
    }

    @Override
    public int calculateSize() {
        return this.BUFFER.length;
    }

    public ChangeFormFlags getRefID() {
        return this.FLAGS;
    }

    public String toString() {
        if (null != this.FULLNAME) {
            return ": " + this.FULLNAME;
        }
        return "";
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Arrays.hashCode(this.BUFFER);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeFormNPC other = (ChangeFormNPC)obj;
        return Arrays.equals(this.BUFFER, other.BUFFER);
    }

    @Override
    public String getInfo(Profile.Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<hr/><p>NPC:</p>");
        if (null != this.FULLNAME) {
            BUILDER.append(String.format("<p>FullName: %s\n", this.FULLNAME));
        }
        if (null != this.FLAGS) {
            BUILDER.append(String.format("<p>ChangeFormFlags: %s\n", this.FLAGS));
        }
        if (null != this.ACBS) {
            BUILDER.append("<p>Base stats: ");
            for (byte b : this.ACBS) {
                BUILDER.append(String.format("%02x", b));
            }
            BUILDER.append("\n");
        }
        if (null != this.NUMFACTIONRANKS) {
            BUILDER.append(String.format("<p>%s faction ranks.</p><ul>", this.NUMFACTIONRANKS));
            this.FACTIONRANKS.forEach(v -> BUILDER.append(String.format("<li>%s", v)));
            BUILDER.append("</ul>");
        }
        if (null != this.SPELLCOUNT) {
            BUILDER.append(String.format("<p>%s spells.</p><ul>", this.SPELLCOUNT));
            this.SPELLS.forEach(v -> BUILDER.append(String.format("<li>%s", v)));
            BUILDER.append("</ul>");
            BUILDER.append(String.format("<p>%s levelled spells.</p><ul>", this.LEVELLEDSPELLCOUNT));
            this.LEVELLEDSPELLS.forEach(v -> BUILDER.append(String.format("<li>%s", v)));
            BUILDER.append("</ul>");
            BUILDER.append(String.format("<p>%s shouts.</p><ul>", this.SHOUTCOUNT));
            this.SHOUTS.forEach(v -> BUILDER.append(String.format("<li>%s", v)));
            BUILDER.append("</ul>");
        }
        if (null != this.AIDT) {
            BUILDER.append("<p>AI:</p><code>");
            for (byte b : this.AIDT) {
                BUILDER.append(String.format("%02x", b));
            }
            BUILDER.append("</code>");
        }
        if (null != this.DNAM) {
            BUILDER.append("<p>Skills:</p><code>");
            for (byte b : this.DNAM) {
                BUILDER.append(String.format("%02x", b));
            }
            BUILDER.append("</code>");
        }
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        return false;
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        if (null != this.FACTIONRANKS) {
            this.FACTIONRANKS.forEach(v -> ((FactionRank)v).FACTION.addName(names, strings));
        }
        if (null != this.SPELLS) {
            this.SPELLS.forEach(v -> v.addName(names, strings));
            this.LEVELLEDSPELLS.forEach(v -> v.addName(names, strings));
            this.SHOUTS.forEach(v -> v.addName(names, strings));
        }
        if (null != this.CCLASS) {
            this.CCLASS.addName(names, strings);
        }
        if (null != this.RACE) {
            this.RACE.addName(names, strings);
        }
        if (null != this.OLDRACE) {
            this.OLDRACE.addName(names, strings);
        }
        if (null != this.DEFOUTFIT) {
            this.DEFOUTFIT.addName(names, strings);
        }
        if (null != this.SLEEPOUTFIT) {
            this.SLEEPOUTFIT.addName(names, strings);
        }
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        if (null != this.FACTIONRANKS) {
            this.FACTIONRANKS.forEach(v -> ((FactionRank)v).FACTION.resolveRefs(ess, owner));
        }
        if (null != this.SPELLS) {
            this.SPELLS.forEach(v -> v.resolveRefs(ess, owner));
            this.LEVELLEDSPELLS.forEach(v -> v.resolveRefs(ess, owner));
            this.SHOUTS.forEach(v -> v.resolveRefs(ess, owner));
        }
        if (null != this.CCLASS) {
            this.CCLASS.resolveRefs(ess, owner);
        }
        if (null != this.RACE) {
            this.RACE.resolveRefs(ess, owner);
        }
        if (null != this.OLDRACE) {
            this.OLDRACE.resolveRefs(ess, owner);
        }
        if (null != this.DEFOUTFIT) {
            this.DEFOUTFIT.resolveRefs(ess, owner);
        }
        if (null != this.SLEEPOUTFIT) {
            this.SLEEPOUTFIT.resolveRefs(ess, owner);
        }
    }

    private static class FaceData
    implements Element {
        private final boolean FACEPRESENT;
        private final RefID HAIRCOLOR;
        private final int SKINTONE;
        private final RefID SKIN;
        private final VSVal HEADPARTCOUNT;
        private final ArrayList<RefID> HEADPARTS;
        private final boolean FACEDATAPRESENT;
        private final int MORPHSCOUNT;
        private final float[] MORPHS;
        private final int PRESETSCOUNT;
        private final int[] PRESETS;

        public FaceData(LittleEndianInput input) throws IOException {
            this.FACEPRESENT = input.readBoolean();
            if (!this.FACEPRESENT) {
                this.HAIRCOLOR = null;
                this.SKINTONE = 0;
                this.SKIN = null;
                this.HEADPARTCOUNT = null;
                this.HEADPARTS = null;
                this.FACEDATAPRESENT = false;
                this.MORPHSCOUNT = 0;
                this.MORPHS = null;
                this.PRESETSCOUNT = 0;
                this.PRESETS = null;
            } else {
                int i;
                this.HAIRCOLOR = new RefID(input);
                this.SKINTONE = input.readInt();
                this.SKIN = new RefID(input);
                this.HEADPARTCOUNT = new VSVal(input);
                this.HEADPARTS = new ArrayList();
                for (i = 0; i < this.HEADPARTCOUNT.getValue(); ++i) {
                    RefID headpart = new RefID(input);
                    this.HEADPARTS.add(headpart);
                }
                this.FACEDATAPRESENT = input.readBoolean();
                if (!this.FACEDATAPRESENT) {
                    this.MORPHSCOUNT = 0;
                    this.MORPHS = null;
                    this.PRESETSCOUNT = 0;
                    this.PRESETS = null;
                } else {
                    this.MORPHSCOUNT = input.readInt();
                    this.MORPHS = new float[this.MORPHSCOUNT];
                    for (i = 0; i < this.MORPHSCOUNT; ++i) {
                        this.MORPHS[i] = input.readFloat();
                    }
                    this.PRESETSCOUNT = input.readInt();
                    this.PRESETS = new int[this.PRESETSCOUNT];
                    for (i = 0; i < this.PRESETSCOUNT; ++i) {
                        this.PRESETS[i] = input.readInt();
                    }
                }
            }
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeBoolean(this.FACEPRESENT);
            if (this.FACEPRESENT) {
                this.HAIRCOLOR.write(output);
                output.writeInt(this.SKINTONE);
                this.SKIN.write(output);
                this.HEADPARTCOUNT.write(output);
                for (RefID headpart : this.HEADPARTS) {
                    headpart.write(output);
                }
                output.writeBoolean(this.FACEDATAPRESENT);
                if (this.FACEDATAPRESENT) {
                    int i;
                    output.writeInt(this.MORPHSCOUNT);
                    for (i = 0; i < this.MORPHSCOUNT; ++i) {
                        output.writeFloat(this.MORPHS[i]);
                    }
                    output.writeInt(this.PRESETSCOUNT);
                    for (i = 0; i < this.PRESETSCOUNT; ++i) {
                        output.writeInt(this.PRESETS[i]);
                    }
                }
            }
        }

        @Override
        public int calculateSize() {
            int sum = 1;
            if (this.FACEPRESENT) {
                sum += this.HAIRCOLOR.calculateSize();
                sum += 4;
                sum += this.SKIN.calculateSize();
                sum += this.HEADPARTCOUNT.calculateSize();
                sum += this.HEADPARTS.stream().mapToInt(v -> v.calculateSize()).sum();
                ++sum;
                if (this.FACEDATAPRESENT) {
                    sum += 8;
                    sum += 4 * this.MORPHSCOUNT;
                    sum += 4 * this.PRESETSCOUNT;
                }
            }
            return sum;
        }
    }

    private static class FactionRank
    implements Element {
        private final RefID FACTION;
        private final byte RANK;

        public FactionRank(LittleEndianInput input) throws IOException {
            this.FACTION = new RefID(input);
            this.RANK = input.readByte();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            this.FACTION.write(output);
            output.writeByte(this.RANK);
        }

        @Override
        public int calculateSize() {
            return 1 + this.FACTION.calculateSize();
        }

        public String toString() {
            return String.format("Rank %d with %s", this.RANK, this.FACTION);
        }
    }
}

