/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4SafeDecompressor;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.LittleEndianInputStream;
import restringer.Profile;
import restringer.Timer;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ChangeForm;
import restringer.ess.ChangeFormData;
import restringer.ess.ChangeFormFLST;
import restringer.ess.ESSContext;
import restringer.ess.Element;
import restringer.ess.Game;
import restringer.ess.GlobalData;
import restringer.ess.Header;
import restringer.ess.Plugin;
import restringer.ess.PluginInfo;
import restringer.ess.RefID;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.Papyrus;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StackFrame;
import restringer.gui.FilterTreeModel;
import restringer.gui.ProgressModel;

public final class ESS
implements Element {
    private final Header HEADER;
    private final byte FORMVERSION;
    private final String UNKNOWN_STRING;
    private final PluginInfo PLUGINS;
    private final FileLocationTable FLT;
    private final List<GlobalData> TABLE1;
    private final List<GlobalData> TABLE2;
    private final List<ChangeForm> CHANGEFORMS;
    private final Map<RefID, ChangeForm> CHANGEFORMS_MAP;
    private final List<GlobalData> TABLE3;
    private final int[] FORMIDARRAY;
    private final int[] VISITEDWORLDSPACEARRAY;
    private final byte[] UNKNOWN3;
    private final byte[] SKSE;
    final String FILENAME;
    private final Long DIGEST;
    private final Papyrus PAPYRUS;
    private final Timer TIMER;
    private ProgressModel rangeModel;
    private static final Logger LOG = Logger.getLogger(ESS.class.getCanonicalName());
    private static File prevSaveFile = null;
    public static final Predicate<Element> THREAD = v -> v instanceof ActiveScript;
    public static final Predicate<Element> OWNABLE = v -> v instanceof ActiveScript || v instanceof StackFrame || v instanceof ArrayInfo;
    public static final Predicate<Element> DELETABLE = v -> v instanceof Script || v instanceof ScriptInstance || v instanceof Reference || v instanceof ArrayInfo || v instanceof ActiveScript || v instanceof ChangeForm;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ESS readESS(File saveFile, ProgressModel model) throws IOException {
        Objects.requireNonNull(saveFile);
        model = model == null ? new ProgressModel() : model;
        model.setValueIsAdjusting(true);
        model.setMinimum(0);
        model.setMaximum(50682);
        model.setValue(0);
        model.setValueIsAdjusting(false);
        String skseName = saveFile.getName().replaceAll("ess$", "skse");
        File skseFile = new File(saveFile.getParent(), skseName);
        if (skseFile.exists()) {
            try (LittleEndianInputStream input = LittleEndianInputStream.openD(saveFile);){
                byte[] skse = Files.readAllBytes(skseFile.toPath());
                ESS eSS = new ESS(input, saveFile.getName(), skse, model);
                return eSS;
            }
        }
        LittleEndianInputStream input = LittleEndianInputStream.openD(saveFile);
        Throwable throwable = null;
        try {
            ESS eSS = new ESS(input, saveFile.getName(), null, model);
            return eSS;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            prevSaveFile = saveFile;
        }
    }

    public static void writeESS(ESS ess, File saveFile, ProgressModel model) throws IOException {
        Objects.requireNonNull(ess);
        Objects.requireNonNull(saveFile);
        Objects.requireNonNull(model);
        model.setValueIsAdjusting(true);
        model.setMinimum(0);
        model.setMaximum(50682);
        model.setValue(0);
        model.setValueIsAdjusting(false);
        boolean testMode = false;
        String skseName = saveFile.getName().replaceAll("ess$", "skse");
        File skseFile = new File(saveFile.getParent(), skseName);
        if (saveFile.exists()) {
            ESS.backupFile(saveFile);
        }
        if (skseFile.exists()) {
            ESS.backupFile(skseFile);
        }
        if (ess.SKSE != null) {
            try (LittleEndianDataOutput output = LittleEndianDataOutput.open(saveFile);){
                Files.write(skseFile.toPath(), ess.SKSE, new OpenOption[0]);
                ess.rangeModel = model;
                ess.write(output);
            }
        }
        try (LittleEndianDataOutput output = LittleEndianDataOutput.open(saveFile);){
            ess.rangeModel = model;
            ess.write(output);
        }
        if (testMode) {
            ESS.compareESS(prevSaveFile, saveFile);
            System.out.println("STILL IN TESTING MODE");
            assert (false) : "Write was successfull, but we are still in testing mode!!!";
        }
    }

    private ESS(LittleEndianInputStream input, String filename, byte[] skse, ProgressModel model) throws IOException {
        GlobalData DATA;
        LittleEndianInputStream INPUT;
        Objects.requireNonNull(input);
        Objects.requireNonNull(model);
        this.rangeModel = Objects.requireNonNull(model);
        int i = -1;
        this.TIMER = new Timer("Timer");
        this.TIMER.start();
        LOG.info("Reading savegame.");
        this.HEADER = new Header(input);
        Game game = this.HEADER.GAME;
        LOG.fine("Reading savegame: read header.");
        if (game.isSSE()) {
            int ORIGINAL_LEN = input.readInt();
            int COMPRESSED_LEN = input.readInt();
            byte[] ORIGINAL = new byte[ORIGINAL_LEN];
            byte[] COMPRESSED = new byte[COMPRESSED_LEN];
            input.read(COMPRESSED);
            LZ4Factory LZ4FACTORY = LZ4Factory.safeInstance();
            LZ4SafeDecompressor LZ4DECOMP = LZ4FACTORY.safeDecompressor();
            LZ4DECOMP.decompress(COMPRESSED, ORIGINAL);
            INPUT = LittleEndianInputStream.wrap(ORIGINAL);
        } else {
            INPUT = input;
        }
        this.FORMVERSION = INPUT.readByte();
        switch (game) {
            case SKYRIM: {
                assert (this.FORMVERSION == 74 || this.FORMVERSION == 73) : "Invalid formVersion: " + this.FORMVERSION;
                this.UNKNOWN_STRING = null;
                break;
            }
            case SKYRIMSE: {
                assert (this.FORMVERSION == 77) : "Invalid formVersion: " + this.FORMVERSION;
                this.UNKNOWN_STRING = null;
                break;
            }
            case FALLOUT4: {
                assert (this.FORMVERSION == 67) : "Invalid formVersion: " + this.FORMVERSION;
                this.UNKNOWN_STRING = INPUT.readWString();
                System.out.println(this.UNKNOWN_STRING);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized game.");
            }
        }
        ESSContext CTX = new ESSContext(this.HEADER, this.FORMVERSION);
        int pluginInfoSize = INPUT.readInt();
        this.PLUGINS = new PluginInfo(INPUT);
        assert (pluginInfoSize == this.PLUGINS.calculateSize());
        LOG.fine("Reading savegame: read plugin table.");
        this.FLT = new FileLocationTable(INPUT);
        this.TABLE1 = new ArrayList<GlobalData>(this.FLT.table1Count);
        this.TABLE2 = new ArrayList<GlobalData>(this.FLT.table2Count);
        this.TABLE3 = new ArrayList<GlobalData>(this.FLT.table3Count);
        this.CHANGEFORMS = new ArrayList<ChangeForm>(this.FLT.changeFormCount);
        this.CHANGEFORMS_MAP = new LinkedHashMap<RefID, ChangeForm>(this.FLT.changeFormCount);
        LOG.fine("Reading savegame: read file location table.");
        try {
            for (i = 0; i < this.FLT.table1Count; ++i) {
                DATA = new GlobalData(INPUT, CTX);
                assert (0 <= DATA.getType() && DATA.getType() <= 100) : "Invalid type for Table1: " + DATA.getType();
                this.TABLE1.add(DATA);
                LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA.getType());
                LOG.fine("Reading savegame: read global data table 1.");
            }
            LOG.fine("Reading savegame: read GlobalDataTable #1.");
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d GlobalData from table #1.", i, this.FLT.table1Count), ex);
        }
        try {
            for (i = 0; i < this.FLT.table2Count; ++i) {
                DATA = new GlobalData(INPUT, CTX);
                assert (100 <= DATA.getType() && DATA.getType() < 1000) : "Invalid type for Table2: " + DATA.getType();
                this.TABLE2.add(DATA);
                LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA.getType());
            }
            LOG.fine("Reading savegame: read GlobalDataTable #2.");
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d GlobalData from table #2.", i, this.FLT.table2Count), ex);
        }
        this.rangeModel.setValue(22);
        try {
            for (i = 0; i < this.FLT.changeFormCount; ++i) {
                ChangeForm FORM = new ChangeForm(INPUT, CTX);
                this.CHANGEFORMS.add(FORM);
                this.CHANGEFORMS_MAP.put(FORM.getRefID(), FORM);
            }
            LOG.fine("Reading savegame: read changeform table.");
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d ChangeForm definitions.", i, this.FLT.changeFormCount), ex);
        }
        this.rangeModel.setValue(820);
        try {
            for (i = 0; i < this.FLT.table3Count; ++i) {
                DATA = new GlobalData(INPUT, CTX);
                assert (1000 <= DATA.getType() && DATA.getType() <= 10000) : "Invalid type for Table3: " + DATA.getType();
                this.TABLE3.add(DATA);
                if (DATA.getType() == 1001) {
                    Papyrus p = DATA.getPapyrus();
                    System.out.print(p);
                }
                LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA.getType());
            }
            LOG.fine("Reading savegame: read GlobalDataTable #3.");
        }
        catch (Error | Exception ex) {
            throw new IOException(String.format("Error; read %d/%d GlobalData from table #3.", i, this.FLT.table3Count), ex);
        }
        this.rangeModel.setValue(4207);
        Papyrus p = this.TABLE3.get(1).getPapyrus();
        int formIDCount = INPUT.readInt();
        this.FORMIDARRAY = new int[formIDCount];
        for (i = 0; i < formIDCount; ++i) {
            this.FORMIDARRAY[i] = INPUT.readInt();
        }
        LOG.fine("Reading savegame: read formid array.");
        int worldspaceIDCount = INPUT.readInt();
        this.VISITEDWORLDSPACEARRAY = new int[worldspaceIDCount];
        for (i = 0; i < worldspaceIDCount; ++i) {
            this.VISITEDWORLDSPACEARRAY[i] = INPUT.readInt();
        }
        LOG.fine("Reading savegame: read visited worldspace array.");
        byte[] BUF = new byte[8192];
        ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
        while (INPUT.available() > 0) {
            int read = INPUT.read(BUF);
            BAOS.write(BUF, 0, read);
        }
        this.UNKNOWN3 = BAOS.toByteArray();
        LOG.fine("Reading savegame: read unknown block.");
        this.rangeModel.setValue(4326);
        assert (this.TABLE3.get(1).getType() == 1001);
        this.PAPYRUS = this.TABLE3.get(1).getPapyrus();
        LOG.fine("Papyrus block is ready.");
        this.resolveRefs();
        LOG.fine("Reading savegame: resolved Papyrus references.");
        this.rangeModel.setValue(15349);
        this.SKSE = (byte[])(null == skse ? null : skse);
        float size = (float)this.calculateSize() / 1048576.0f;
        this.FILENAME = filename;
        this.DIGEST = input.getDigest();
        this.TIMER.stop();
        LOG.info(String.format("Savegame read: %.1f mb in %s.", Float.valueOf(size), this.TIMER.getFormattedTime()));
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        Objects.requireNonNull(this.rangeModel);
        LOG.info("Writing savegame.");
        this.TIMER.restart();
        Game game = this.HEADER.GAME;
        this.HEADER.write(output);
        this.rangeModel.setValue(this.rangeModel.getValue() + 16 + this.HEADER.calculateSize());
        LOG.fine("Writing savegame: wrote header.");
        if (game == Game.SKYRIMSE) {
            ByteArrayOutputStream BAOS = new ByteArrayOutputStream(this.calculateSize() / 2);
            try (LittleEndianDataOutput output2 = LittleEndianDataOutput.wrap(BAOS);){
                this.writeBody(output2);
            }
            byte[] ORIGINAL = BAOS.toByteArray();
            int ORIGINAL_LEN = ORIGINAL.length;
            LZ4Factory LZ4FACTORY = LZ4Factory.fastestInstance();
            LZ4Compressor LZ4COMP = LZ4FACTORY.highCompressor(20);
            byte[] COMPRESSED = LZ4COMP.compress(ORIGINAL);
            int COMPRESSED_LEN = COMPRESSED.length;
            output.writeInt(ORIGINAL_LEN);
            output.writeInt(COMPRESSED_LEN);
            output.write(COMPRESSED);
        } else {
            this.writeBody(output);
        }
    }

    private void writeBody(LittleEndianDataOutput output) throws IOException {
        output.write(this.FORMVERSION);
        output.writeInt(this.PLUGINS.calculateSize());
        this.PLUGINS.write(output);
        this.rangeModel.setValue(this.rangeModel.getValue() + 5 + this.PLUGINS.calculateSize());
        LOG.fine("Writing savegame: wrote plugin table.");
        this.FLT.rebuild(this);
        this.FLT.write(output);
        this.rangeModel.setValue(this.rangeModel.getValue() + this.FLT.calculateSize());
        LOG.fine("Writing savegame: rebuilt and wrote file location table.");
        for (GlobalData data : this.TABLE1) {
            try {
                data.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + data.calculateSize());
                LOG.log(Level.FINE, "Writing savegame: \tGlobalData type {0}.", data.getType());
            }
            catch (IOException ex) {
                int idx = this.TABLE1.indexOf(data);
                throw new IOException("Error writing GlobalData " + idx + " from table 1.", ex);
            }
        }
        LOG.fine("Writing savegame: wrote GlobalDataTable #1.");
        for (GlobalData data : this.TABLE2) {
            try {
                data.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + data.calculateSize());
                LOG.log(Level.FINE, "Writing savegame: \tGlobalData type {0}.", data.getType());
            }
            catch (IOException ex) {
                int idx = this.TABLE2.indexOf(data);
                throw new IOException("Error writing GlobalData " + idx + " from table 2.", ex);
            }
        }
        LOG.fine("Writing savegame: wrote GlobalDataTable #2.");
        for (ChangeForm form : this.CHANGEFORMS) {
            try {
                form.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + form.calculateSize());
            }
            catch (IOException ex) {
                int idx = this.CHANGEFORMS.indexOf(form);
                throw new IOException("Error writing ChangeForm " + idx + " / " + this.CHANGEFORMS.size() + ".", ex);
            }
        }
        LOG.fine("Writing savegame: wrote changeform table.");
        for (GlobalData data : this.TABLE3) {
            try {
                data.write(output);
                this.rangeModel.setValue(this.rangeModel.getValue() + data.calculateSize());
                LOG.log(Level.FINE, "Writing savegame: \tGlobalData type {0}.", data.getType());
            }
            catch (IOException ex) {
                int idx = this.TABLE3.indexOf(data);
                throw new IOException("Error writing GlobalData " + idx + " from table 3.", ex);
            }
        }
        LOG.fine("Writing savegame: wrote GlobalDataTable #3.");
        output.writeInt(this.FORMIDARRAY.length);
        for (Object formID : (Object)this.FORMIDARRAY) {
            output.writeInt((int)formID);
        }
        this.rangeModel.setValue(this.rangeModel.getValue() + 4 + 4 * this.FORMIDARRAY.length);
        LOG.fine("Writing savegame: wrote formid array.");
        output.writeInt(this.VISITEDWORLDSPACEARRAY.length);
        for (Object formID : (Object)this.VISITEDWORLDSPACEARRAY) {
            output.writeInt((int)formID);
        }
        this.rangeModel.setValue(this.rangeModel.getValue() + 4 + 4 * this.VISITEDWORLDSPACEARRAY.length);
        LOG.fine("Writing savegame: wrote visited worldspace array.");
        output.write(this.UNKNOWN3);
        this.rangeModel.setValue(this.rangeModel.getValue() + this.UNKNOWN3.length);
        LOG.fine("Writing savegame: wrote unknown block.");
        float size = (float)this.calculateSize() / 1048576.0f;
        this.TIMER.stop();
        LOG.info(String.format("Savegame written: %.1f mb in %s.", Float.valueOf(size), this.TIMER.getFormattedTime()));
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        sum += this.HEADER.calculateSize();
        ++sum;
        sum += this.PLUGINS.calculateSize();
        sum += this.FLT.calculateSize();
        sum += this.TABLE1.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.TABLE2.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.CHANGEFORMS.stream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.TABLE3.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += 4 * this.FORMIDARRAY.length;
        sum += 4;
        sum += 4 * this.VISITEDWORLDSPACEARRAY.length;
        return sum += this.UNKNOWN3.length;
    }

    public void resolveRefs() {
        this.CHANGEFORMS.forEach(v -> v.resolveRefs(this, null));
        this.PAPYRUS.resolveRefs(this, null);
        this.PLUGINS.getPlugins().forEach(v -> v.resolveRefs(this, null));
    }

    public void addNames(ESPIDMap names, StringTable strings) {
        this.CHANGEFORMS.forEach(v -> v.addNames(names, strings));
        this.PAPYRUS.addNames(names, strings);
    }

    public Papyrus getPapyrus() {
        return this.PAPYRUS;
    }

    public Long getDigest() {
        return this.DIGEST;
    }

    public String getFilename() {
        return this.FILENAME;
    }

    public Map<RefID, ChangeForm> getChangeForms() {
        return this.CHANGEFORMS_MAP;
    }

    public int[] getFormIDs() {
        return this.FORMIDARRAY;
    }

    public PluginInfo getPluginInfo() {
        return this.PLUGINS;
    }

    public int resetHavok() {
        for (ChangeForm changeForm : this.CHANGEFORMS) {
        }
        return 0;
    }

    public int[] cleanseFormLists() {
        int entries = 0;
        int forms = 0;
        for (ChangeForm form : this.CHANGEFORMS) {
            ChangeFormFLST flst;
            int removed;
            ChangeFormData data = form.getData();
            if (!(data instanceof ChangeFormFLST) || (removed = (flst = (ChangeFormFLST)data).cleanse()) <= 0) continue;
            entries += removed;
            ++forms;
        }
        return new int[]{entries, forms};
    }

    public int removeNonexistentCreated() {
        boolean i = false;
        LinkedList nonexist = new LinkedList();
        this.PAPYRUS.getInstances().values().forEach(instance -> {
            RefID ref = instance.getRefID();
            if (ref.getType() == RefID.Type.CREATED) {
                assert (this.CHANGEFORMS_MAP.containsKey(ref) == (ref.getForm() != null));
                if (ref.getForm() == null) {
                    nonexist.add(instance);
                }
            }
        });
        nonexist.forEach(v -> this.removeElement((Element)v));
        return nonexist.size();
    }

    public int removePluginInstances(Plugin plugin) {
        Objects.requireNonNull(plugin);
        Set<ScriptInstance> INSTANCES = plugin.getInstances();
        INSTANCES.stream().forEach(v -> this.PAPYRUS.removeElement((PapyrusElement)v));
        return INSTANCES.size();
    }

    public int removePluginForms(Plugin plugin) {
        Objects.requireNonNull(plugin);
        Set<ChangeForm> FORMS = plugin.getForms();
        FORMS.stream().forEach(v -> this.removeElement((Element)v));
        return FORMS.size();
    }

    public boolean removeElement(Element element) {
        Objects.requireNonNull(element);
        if (element instanceof ChangeForm) {
            ChangeForm FORM = (ChangeForm)element;
            if (!this.CHANGEFORMS.contains(FORM)) {
                return false;
            }
            this.CHANGEFORMS.remove(FORM);
            this.CHANGEFORMS_MAP.remove(FORM.getRefID());
            return true;
        }
        if (element instanceof PapyrusElement) {
            return this.PAPYRUS.removeElement((PapyrusElement)element);
        }
        return false;
    }

    public FilterTreeModel createTreeModel() {
        this.TIMER.restart();
        FilterTreeModel MODEL = new FilterTreeModel();
        Papyrus papyrus = this.getPapyrus();
        TreeMap<Character, ArrayList> stringDictionary = new TreeMap<Character, ArrayList>();
        int stringProtoSize = papyrus.getStringTable().size() / 50;
        papyrus.getStringTable().forEach(string -> {
            if (string.length() > 0) {
                char firstChar = Character.toUpperCase(string.charAt(0));
                if (Character.isLetter(firstChar)) {
                    List entry = stringDictionary.computeIfAbsent(Character.valueOf(firstChar), ch -> new ArrayList(stringProtoSize));
                    entry.add(string);
                } else {
                    List entry = stringDictionary.computeIfAbsent(Character.valueOf('0'), ch -> new ArrayList(stringProtoSize));
                    entry.add(string);
                }
            } else {
                List entry = stringDictionary.computeIfAbsent(Character.valueOf('0'), ch -> new ArrayList(stringProtoSize));
                entry.add(string);
            }
        });
        ArrayList<FilterTreeModel.Node> stringNodes = new ArrayList<FilterTreeModel.Node>(stringDictionary.size());
        stringDictionary.forEach((ch, list) -> stringNodes.add(MODEL.elementContainer(Character.toString(ch.charValue()), (Collection<? extends Element>)list)));
        this.TIMER.stop();
        LOG.info(String.format("Classifying strings took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(16493);
        TreeMap<Character, ArrayList> instanceDictionary = new TreeMap<Character, ArrayList>();
        int instanceProtoSize = papyrus.getInstances().size() / 30;
        papyrus.getInstances().values().forEach(instance -> {
            char firstChar = Character.toUpperCase(instance.toString().charAt(0));
            if (Character.isLetter(firstChar)) {
                List entry = instanceDictionary.computeIfAbsent(Character.valueOf(firstChar), ch -> new ArrayList(instanceProtoSize));
                entry.add(instance);
            } else {
                List entry = instanceDictionary.computeIfAbsent(Character.valueOf('0'), ch -> new ArrayList(instanceProtoSize));
                entry.add(instance);
            }
        });
        ArrayList<FilterTreeModel.Node> instanceNodes = new ArrayList<FilterTreeModel.Node>(instanceDictionary.size());
        instanceDictionary.forEach((ch, list) -> instanceNodes.add(MODEL.elementContainer(Character.toString(ch.charValue()), (Collection<? extends Element>)list)));
        this.TIMER.stop();
        LOG.info(String.format("Classifying instances took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(45821);
        ArrayList<FilterTreeModel.Node> activeNodes = new ArrayList<FilterTreeModel.Node>(papyrus.getActiveScripts().size());
        papyrus.getActiveScripts().values().forEach(active -> activeNodes.add(MODEL.node((Element)active, active.getData().getStackFrames())));
        this.TIMER.stop();
        LOG.info(String.format("Making activeescript nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        List<FilterTreeModel.Node> funcNodes = papyrus.getFunctionMessages().stream().map(v -> MODEL.node((Element)v, v.getMessage())).collect(Collectors.toList());
        this.TIMER.stop();
        LOG.info(String.format("Making function message nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        List<FilterTreeModel.Node> stackNodes1 = papyrus.getSuspendedStacks1().stream().map(v -> MODEL.node((Element)v, v.getMessage())).collect(Collectors.toList());
        List<FilterTreeModel.Node> stackNodes2 = papyrus.getSuspendedStacks2().stream().map(v -> MODEL.node((Element)v, v.getMessage())).collect(Collectors.toList());
        this.TIMER.stop();
        LOG.info(String.format("Making suspended stack nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(45831);
        TreeMap<ChangeForm.Type, ArrayList> formDictionary = new TreeMap<ChangeForm.Type, ArrayList>();
        int formProtoSize = this.getChangeForms().size() / 40;
        this.getChangeForms().values().forEach(form -> {
            ChangeForm.Type CODE = form.getType();
            List entry = formDictionary.computeIfAbsent(CODE, c -> new ArrayList(instanceProtoSize));
            entry.add(form);
        });
        ArrayList<FilterTreeModel.Node> formNodes = new ArrayList<FilterTreeModel.Node>(formDictionary.size());
        formDictionary.forEach((type, list) -> formNodes.add(MODEL.elementContainer(type.toString(), (Collection<? extends Element>)list)));
        this.TIMER.stop();
        LOG.info(String.format("Classifying changeforms took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.TIMER.stop();
        LOG.info(String.format("Making queued unbind nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        FilterTreeModel.Node pluginsNode = MODEL.elementContainer("Plugins", this.getPluginInfo().getPlugins());
        FilterTreeModel.Node stringsNode = MODEL.nodeContainer("Strings", stringNodes);
        FilterTreeModel.Node scriptsNode = MODEL.elementContainer("Scripts", papyrus.getScripts().values());
        FilterTreeModel.Node instancesNode = MODEL.nodeContainer("Script Instances", instanceNodes);
        FilterTreeModel.Node referencesNode = MODEL.elementContainer("References", papyrus.getReferences().values());
        FilterTreeModel.Node arraysNode = MODEL.elementContainer("Arrays", papyrus.getArrays().values());
        FilterTreeModel.Node activeNode = MODEL.nodeContainer("Active Scripts", activeNodes);
        FilterTreeModel.Node funcNode = MODEL.nodeContainer("Function Messages", funcNodes);
        FilterTreeModel.Node stack1Node = MODEL.nodeContainer("Suspended Stacks 1", stackNodes1);
        FilterTreeModel.Node stack2Node = MODEL.nodeContainer("Suspended Stacks 2", stackNodes2);
        FilterTreeModel.Node formsNode = MODEL.nodeContainer("ChangeForms", formNodes);
        FilterTreeModel.Node unbindsNode = MODEL.elementContainer("QueuedUnbinds", papyrus.getUnbinds());
        this.TIMER.stop();
        LOG.info(String.format("Making toplevel folder nodes took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(46670);
        stringNodes.forEach(n -> n.sort());
        instanceNodes.forEach(n -> n.sort());
        stringsNode.sort();
        instancesNode.sort();
        scriptsNode.sort();
        formsNode.sort();
        this.TIMER.stop();
        LOG.info(String.format("Sorting took %s.", this.TIMER.getFormattedTime()));
        this.TIMER.restart();
        this.rangeModel.setValue(50681);
        ArrayList<FilterTreeModel.Node> topLevel = new ArrayList<FilterTreeModel.Node>(14);
        topLevel.add(pluginsNode);
        topLevel.add(stringsNode);
        topLevel.add(scriptsNode);
        topLevel.add(instancesNode);
        topLevel.add(referencesNode);
        topLevel.add(arraysNode);
        topLevel.add(activeNode);
        topLevel.add(funcNode);
        topLevel.add(stack1Node);
        topLevel.add(stack2Node);
        topLevel.add(formsNode);
        topLevel.add(unbindsNode);
        FilterTreeModel.Node root = MODEL.root(this, topLevel);
        MODEL.setRoot(root);
        this.TIMER.stop();
        LOG.info(String.format("Making the model %s.", this.TIMER.getFormattedTime()));
        this.rangeModel.setValue(50682);
        return MODEL;
    }

    public Element broadSpectrumMatch(int id) {
        RefID ref = new RefID(id);
        if (this.CHANGEFORMS_MAP.containsKey(ref)) {
            return this.CHANGEFORMS_MAP.get(ref);
        }
        return this.PAPYRUS.broadSpectrumMatch(EID.make4byte(id));
    }

    public String getInfo(Profile.Analysis analysis) {
        StringBuilder BUF = new StringBuilder();
        long time = this.HEADER.FILETIME;
        long millis = time / 10000L - 11644473600000L;
        Date DATE = new Date(millis);
        int seconds = (int)(time / 10000000L) % 60;
        int minutes = (int)(time / 600000000L) % 60;
        int hours = (int)(time / 36000000000L) % 24;
        int years = (int)((double)time / 3.15576E14);
        int days = (int)(time / 864000000000L);
        BUF.append(this.FILENAME);
        BUF.append("\n\nMD5: ").append(this.DIGEST);
        BUF.append(String.format("\nTimestamp: %s\n", DATE));
        BUF.append("\nSavenumber: ").append(this.HEADER.SAVENUMBER);
        BUF.append("\nVersion: ").append(this.HEADER.VERSION);
        BUF.append("\n\nPlayer name: ").append(this.HEADER.NAME);
        BUF.append("\nGender: ").append(this.HEADER.SEX);
        BUF.append("\nRaceID: ").append(this.HEADER.RACEID);
        BUF.append("\nLevel: ").append(this.HEADER.LEVEL);
        BUF.append("\nCurrent XP: ").append(this.HEADER.CURRENT_XP);
        BUF.append("\nNeeded XP: ").append(this.HEADER.NEEDED_XP);
        BUF.append("\nLocation: ").append(this.HEADER.LOCATION);
        BUF.append("\nGame date: ").append(this.HEADER.GAMEDATE);
        return BUF.toString();
    }

    public String toString() {
        return this.FILENAME;
    }

    private static void compareESS(File orig, File copy) throws IOException {
        try (LittleEndianInputStream IN1 = LittleEndianInputStream.openD(orig);
             LittleEndianInputStream IN2 = LittleEndianInputStream.openD(copy);){
            GlobalData DATA2;
            GlobalData DATA1;
            LittleEndianInputStream DEC2;
            LittleEndianInputStream DEC1;
            Header HEADER1 = new Header(IN1);
            Header HEADER2 = new Header(IN2);
            Game game = HEADER1.GAME;
            if (game.isSSE()) {
                DEC1 = LittleEndianInputStream.wrapD(new LZ4BlockInputStream(IN1));
                DEC2 = LittleEndianInputStream.wrapD(new LZ4BlockInputStream(IN2));
            } else {
                DEC1 = IN1;
                DEC2 = IN2;
            }
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            byte FORMVERSION1 = DEC1.readByte();
            byte FORMVERSION2 = DEC2.readByte();
            assert (FORMVERSION1 == FORMVERSION2);
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            switch (game) {
                case SKYRIM: {
                    assert (FORMVERSION1 == 74 || FORMVERSION1 == 73) : "Invalid formVersion: " + FORMVERSION1;
                    assert (FORMVERSION2 == 74 || FORMVERSION2 == 73) : "Invalid formVersion: " + FORMVERSION2;
                    break;
                }
                case SKYRIMSE: {
                    assert (FORMVERSION1 == 77) : "Invalid formVersion: " + FORMVERSION1;
                    assert (FORMVERSION2 == 77) : "Invalid formVersion: " + FORMVERSION2;
                    break;
                }
                case FALLOUT4: {
                    assert (FORMVERSION1 == 67) : "Invalid formVersion: " + FORMVERSION1;
                    assert (FORMVERSION2 == 67) : "Invalid formVersion: " + FORMVERSION2;
                    String UNKNOWN_STRING1 = DEC1.readWString();
                    String UNKNOWN_STRING2 = DEC2.readWString();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized game.");
                }
            }
            ESSContext CTX1 = new ESSContext(HEADER1, FORMVERSION1);
            ESSContext CTX2 = new ESSContext(HEADER2, FORMVERSION2);
            int pluginInfoSize1 = DEC1.readInt();
            int pluginInfoSize2 = DEC2.readInt();
            assert (pluginInfoSize1 == pluginInfoSize2);
            PluginInfo PLUGINS1 = new PluginInfo(DEC1);
            PluginInfo PLUGINS2 = new PluginInfo(DEC2);
            assert (Objects.equals(PLUGINS1, PLUGINS2));
            assert (pluginInfoSize1 == PLUGINS1.calculateSize());
            assert (pluginInfoSize2 == PLUGINS2.calculateSize());
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            FileLocationTable FLT1 = new FileLocationTable(DEC1);
            FileLocationTable FLT2 = new FileLocationTable(DEC2);
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            ArrayList<GlobalData> TABLE11 = new ArrayList<GlobalData>(FLT1.table1Count);
            ArrayList<GlobalData> TABLE21 = new ArrayList<GlobalData>(FLT1.table2Count);
            ArrayList<GlobalData> TABLE31 = new ArrayList<GlobalData>(FLT1.table3Count);
            ArrayList<GlobalData> TABLE12 = new ArrayList<GlobalData>(FLT2.table1Count);
            ArrayList<GlobalData> TABLE22 = new ArrayList<GlobalData>(FLT2.table2Count);
            ArrayList<GlobalData> TABLE32 = new ArrayList<GlobalData>(FLT2.table3Count);
            ArrayList<ChangeForm> CHANGEFORMS1 = new ArrayList<ChangeForm>(FLT1.changeFormCount);
            ArrayList<ChangeForm> CHANGEFORMS2 = new ArrayList<ChangeForm>(FLT2.changeFormCount);
            LinkedHashMap<RefID, ChangeForm> CHANGEFORMS_MAP1 = new LinkedHashMap<RefID, ChangeForm>(FLT1.changeFormCount);
            LinkedHashMap<RefID, ChangeForm> CHANGEFORMS_MAP2 = new LinkedHashMap<RefID, ChangeForm>(FLT2.changeFormCount);
            int i = 0;
            try {
                for (i = 0; i < FLT1.table1Count; ++i) {
                    DATA1 = new GlobalData(DEC1, CTX1);
                    DATA2 = new GlobalData(DEC2, CTX2);
                    TABLE11.add(DATA1);
                    TABLE12.add(DATA2);
                    assert (Objects.equals(DATA1, DATA2));
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                }
                assert (TABLE11.equals(TABLE12));
                LOG.fine("Reading savegame: read GlobalDataTable #1.");
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d GlobalData from table #1.", i, FLT1.table1Count), ex);
            }
            try {
                for (i = 0; i < FLT1.table2Count; ++i) {
                    DATA1 = new GlobalData(DEC1, CTX1);
                    DATA2 = new GlobalData(DEC2, CTX2);
                    TABLE21.add(DATA1);
                    TABLE22.add(DATA2);
                    assert (Objects.equals(DATA1, DATA2));
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                }
                assert (TABLE21.equals(TABLE22));
                LOG.fine("Reading savegame: read GlobalDataTable #2.");
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d GlobalData from table #2.", i, FLT1.table2Count), ex);
            }
            try {
                for (i = 0; i < FLT1.changeFormCount; ++i) {
                    ChangeForm FORM1 = new ChangeForm(DEC1, CTX1);
                    ChangeForm FORM2 = new ChangeForm(DEC2, CTX2);
                    CHANGEFORMS1.add(FORM1);
                    CHANGEFORMS2.add(FORM2);
                    assert (FORM1.identical(FORM2));
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                    CHANGEFORMS_MAP1.put(FORM1.getRefID(), FORM1);
                    CHANGEFORMS_MAP2.put(FORM2.getRefID(), FORM2);
                }
                assert (CHANGEFORMS1.equals(CHANGEFORMS2));
                LOG.fine("Reading savegame: read changeform table.");
            }
            catch (IOException | AssertionError ex) {
                throw new IOException(String.format("Error; read %d/%d ChangeForm definitions.", i, FLT1.changeFormCount), (Throwable)ex);
            }
            try {
                for (i = 0; i < FLT1.table3Count; ++i) {
                    DATA1 = new GlobalData(DEC1, CTX1);
                    DATA2 = new GlobalData(DEC2, CTX2);
                    TABLE31.add(DATA1);
                    TABLE32.add(DATA2);
                    assert (Objects.equals(DATA1, DATA2));
                    assert (DEC1.getDigest().equals(DEC2.getDigest()));
                    LOG.log(Level.FINE, "Reading savegame: \tGlobalData type {0}.", DATA1.getType());
                }
                assert (TABLE31.equals(TABLE32));
                LOG.fine("Reading savegame: read GlobalDataTable #3.");
            }
            catch (Error | Exception ex) {
                throw new IOException(String.format("Error; read %d/%d GlobalData from table #3.", i, FLT1.table3Count), ex);
            }
            Papyrus P1 = ((GlobalData)TABLE31.get(1)).getPapyrus();
            Papyrus P2 = ((GlobalData)TABLE32.get(1)).getPapyrus();
            int formIDCount1 = DEC1.readInt();
            int formIDCount2 = DEC2.readInt();
            int[] FORMIDARRAY1 = new int[formIDCount1];
            int[] FORMIDARRAY2 = new int[formIDCount2];
            for (i = 0; i < formIDCount1; ++i) {
                FORMIDARRAY1[i] = DEC1.readInt();
                FORMIDARRAY2[i] = DEC2.readInt();
            }
            assert (Arrays.equals(FORMIDARRAY1, FORMIDARRAY2));
            LOG.fine("Reading savegame: read formid array.");
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            int worldspaceIDCount1 = DEC1.readInt();
            int worldspaceIDCount2 = DEC2.readInt();
            int[] VISITEDWORLDSPACEARRAY1 = new int[worldspaceIDCount1];
            int[] VISITEDWORLDSPACEARRAY2 = new int[worldspaceIDCount2];
            for (i = 0; i < worldspaceIDCount1; ++i) {
                VISITEDWORLDSPACEARRAY1[i] = DEC1.readInt();
                VISITEDWORLDSPACEARRAY2[i] = DEC2.readInt();
            }
            assert (Arrays.equals(VISITEDWORLDSPACEARRAY1, VISITEDWORLDSPACEARRAY2));
            LOG.fine("Reading savegame: read visited worldspace array.");
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
            byte[] BUF = new byte[8192];
            ByteArrayOutputStream BAOS = new ByteArrayOutputStream();
            while (DEC1.available() > 0) {
                int read1 = DEC1.read(BUF);
                BAOS.write(BUF, 0, read1);
                int read2 = DEC2.read(BUF);
                BAOS.write(BUF, 0, read2);
            }
            byte[] UNKNOWN31 = BAOS.toByteArray();
            byte[] UNKNOWN32 = BAOS.toByteArray();
            assert (Arrays.equals(UNKNOWN31, UNKNOWN32));
            LOG.fine("Reading savegame: read unknown block.");
            assert (DEC1.getDigest().equals(DEC2.getDigest()));
        }
    }

    private static void backupFile(File file) throws IOException {
        String TIME = new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date());
        String NAME = file.getName();
        String NEWNAME = NAME + "." + TIME;
        File newFile = new File(file.getParent(), NEWNAME);
        if (!newFile.exists()) {
            newFile.createNewFile();
        }
        try (FileChannel SRC = new FileInputStream(file).getChannel();
             FileChannel DEST = new FileOutputStream(newFile).getChannel();){
            DEST.transferFrom(SRC, 0L, SRC.size());
        }
    }

    public static final class FileLocationTable
    implements Element {
        int formIDArrayCountOffset;
        int unknownTable3Offset;
        int table1Offset;
        int table2Offset;
        int changeFormsOffset;
        int table3Offset;
        int table1Count;
        int table2Count;
        int table3Count;
        int changeFormCount;
        int[] UNUSED;

        public FileLocationTable(LittleEndianInput input) throws IOException {
            assert (null != input);
            this.formIDArrayCountOffset = input.readInt();
            this.unknownTable3Offset = input.readInt();
            this.table1Offset = input.readInt();
            this.table2Offset = input.readInt();
            this.changeFormsOffset = input.readInt();
            this.table3Offset = input.readInt();
            this.table1Count = input.readInt();
            this.table2Count = input.readInt();
            this.table3Count = input.readInt() + 1;
            this.changeFormCount = input.readInt();
            this.UNUSED = new int[15];
            for (int i = 0; i < 15; ++i) {
                this.UNUSED[i] = input.readInt();
            }
        }

        public void rebuild(ESS ess) {
            int table1Size = ess.TABLE1.stream().mapToInt(v -> v.calculateSize()).sum();
            int table2Size = ess.TABLE2.stream().mapToInt(v -> v.calculateSize()).sum();
            int table3Size = ess.TABLE3.stream().mapToInt(v -> v.calculateSize()).sum();
            int changeFormsSize = ess.CHANGEFORMS.parallelStream().mapToInt(v -> v.calculateSize()).sum();
            this.table1Offset = 0;
            this.table1Offset += ess.HEADER.calculateSize();
            this.table1Offset += 5;
            this.table1Offset += ess.PLUGINS.calculateSize();
            this.table1Offset += this.calculateSize();
            this.table2Offset = this.table1Offset + table1Size;
            this.changeFormCount = ess.CHANGEFORMS.size();
            this.changeFormsOffset = this.table2Offset + table2Size;
            this.table3Offset = this.changeFormsOffset + changeFormsSize;
            this.formIDArrayCountOffset = this.table3Offset + table3Size;
            this.unknownTable3Offset = 0;
            this.unknownTable3Offset += this.formIDArrayCountOffset;
            this.unknownTable3Offset += 4 + 4 * ess.FORMIDARRAY.length;
            this.unknownTable3Offset += 4 + 4 * ess.VISITEDWORLDSPACEARRAY.length;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            assert (null != output);
            output.writeInt(this.formIDArrayCountOffset);
            output.writeInt(this.unknownTable3Offset);
            output.writeInt(this.table1Offset);
            output.writeInt(this.table2Offset);
            output.writeInt(this.changeFormsOffset);
            output.writeInt(this.table3Offset);
            output.writeInt(this.table1Count);
            output.writeInt(this.table2Count);
            output.writeInt(this.table3Count - 1);
            output.writeInt(this.changeFormCount);
            for (int i = 0; i < 15; ++i) {
                output.writeInt(this.UNUSED[i]);
            }
        }

        @Override
        public int calculateSize() {
            return 100;
        }

        public int hashCode() {
            int hash = 7;
            hash = 73 * hash + this.formIDArrayCountOffset;
            hash = 73 * hash + this.unknownTable3Offset;
            hash = 73 * hash + this.table1Offset;
            hash = 73 * hash + this.table2Offset;
            hash = 73 * hash + this.changeFormsOffset;
            hash = 73 * hash + this.table3Offset;
            hash = 73 * hash + this.table1Count;
            hash = 73 * hash + this.table2Count;
            hash = 73 * hash + this.table3Count;
            hash = 73 * hash + this.changeFormCount;
            hash = 73 * hash + Arrays.hashCode(this.UNUSED);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileLocationTable other = (FileLocationTable)obj;
            if (this.formIDArrayCountOffset != other.formIDArrayCountOffset) {
                return false;
            }
            if (this.unknownTable3Offset != other.unknownTable3Offset) {
                return false;
            }
            if (this.table1Offset != other.table1Offset) {
                return false;
            }
            if (this.table2Offset != other.table2Offset) {
                return false;
            }
            if (this.changeFormsOffset != other.changeFormsOffset) {
                return false;
            }
            if (this.table3Offset != other.table3Offset) {
                return false;
            }
            if (this.table1Count != other.table1Count) {
                return false;
            }
            if (this.table2Count != other.table2Count) {
                return false;
            }
            if (this.table3Count != other.table3Count) {
                return false;
            }
            if (this.changeFormCount != other.changeFormCount) {
                return false;
            }
            return Arrays.equals(this.UNUSED, other.UNUSED);
        }
    }
}

