/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;

public abstract class Flags
implements Element {
    private static final String[] ZEROS = Flags.makeZeros();

    public String toHTML() {
        int i;
        char[] ONES = new char[]{'\u2080', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};
        char[] TENS = new char[]{'\u0000', '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};
        int BITS = 8 * this.calculateSize();
        StringBuilder BUF = new StringBuilder();
        BUF.append("<code><table cellspacing=0 cellpadding=1 border=0.5 style=\"display:inline-table;\">");
        BUF.append("<tr align=center>");
        for (i = BITS - 1; i >= 0; --i) {
            BUF.append("<td>");
            BUF.append(ONES[i / 10]);
            BUF.append(ONES[i % 10]);
            BUF.append("</td>");
        }
        BUF.append("</tr><tr align=center>");
        for (i = BITS - 1; i >= 0; --i) {
            boolean flag = this.getFlag(i);
            BUF.append("<td><code>");
            BUF.append(flag ? (char)'1' : '0');
            BUF.append("</code></td>");
        }
        BUF.append("</tr></table></code>");
        return BUF.toString();
    }

    public static Byte readByteFlags(LittleEndianInput input) throws IOException {
        return new Byte(input);
    }

    public static Short readShortFlags(LittleEndianInput input) throws IOException {
        return new Short(input);
    }

    public static Int readIntFlags(LittleEndianInput input) throws IOException {
        return new Int(input);
    }

    public abstract boolean getFlag(int var1);

    private static String[] makeZeros() {
        String[] zeros = new String[32];
        zeros[0] = "";
        for (int i = 1; i < 32; ++i) {
            zeros[i] = zeros[i - 1] + "0";
        }
        return zeros;
    }

    public static class Int
    extends Flags {
        public final int FLAGS;

        public Int(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.FLAGS = input.readInt();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.FLAGS);
        }

        @Override
        public int calculateSize() {
            return 4;
        }

        @Override
        public boolean getFlag(int index) {
            assert (index >= 0 && index < 32);
            return (1 & this.FLAGS >>> index) != 0;
        }

        public String toString() {
            int BITS = 32;
            String binary = Integer.toBinaryString(this.FLAGS);
            int len = binary.length();
            return ZEROS[32 - len] + binary;
        }
    }

    public static class Short
    extends Flags {
        public final short FLAGS;

        public Short(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.FLAGS = input.readShort();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeShort(this.FLAGS);
        }

        @Override
        public int calculateSize() {
            return 2;
        }

        @Override
        public boolean getFlag(int index) {
            assert (index >= 0 && index < 16);
            return (1 & this.FLAGS >>> index) != 0;
        }

        public String toString() {
            int BITS = 16;
            String binary = Integer.toBinaryString(this.FLAGS);
            int len = binary.length();
            return ZEROS[16 - len] + binary;
        }
    }

    public static class Byte
    extends Flags {
        public final byte FLAGS;

        public Byte(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.FLAGS = input.readByte();
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.FLAGS);
        }

        @Override
        public int calculateSize() {
            return 1;
        }

        @Override
        public boolean getFlag(int index) {
            assert (index >= 0 && index < 8);
            return (1 & this.FLAGS >>> index) != 0;
        }

        public String toString() {
            int BITS = 8;
            String binary = Integer.toBinaryString(this.FLAGS);
            int len = binary.length();
            return ZEROS[8 - len] + binary;
        }
    }
}

