/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileNameExtensionFilter;

public enum Game {
    SKYRIM("Skyrim Savefile", "ess"),
    SKYRIMSE("Skyrim SE Savefile", "ess"),
    FALLOUT4("Fallout 4 Savefile", "fos");

    public final String EXT;
    public final Pattern REGEX;
    public final FileNameExtensionFilter SWING_FILTER;
    public static List<Game> VALUES;

    public static Game matchFilename(String filename) {
        for (Game game : VALUES) {
            if (!game.REGEX.asPredicate().test(filename)) continue;
            return game;
        }
        return null;
    }

    public boolean testFilename(File f) {
        return this.REGEX.asPredicate().test(f.getName());
    }

    public boolean isStr32() {
        return this.isSSE();
    }

    public boolean isFO4() {
        return this == FALLOUT4;
    }

    public boolean isSkyrim() {
        return this.isSSE() || this.isSLE();
    }

    public boolean isSSE() {
        return this == SKYRIMSE;
    }

    public boolean isSLE() {
        return this == SKYRIM;
    }

    private Game(String name, String extension) {
        String pattern = String.format(".+\\.(%s)", extension);
        this.REGEX = Pattern.compile(pattern, 2);
        this.EXT = extension;
        this.SWING_FILTER = new FileNameExtensionFilter(name, extension);
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(Game.values()));
    }
}

