/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.DefaultGlobalDataBlock;
import restringer.ess.ESSContext;
import restringer.ess.Element;
import restringer.ess.GlobalDataBlock;
import restringer.ess.papyrus.Papyrus;

public final class GlobalData
implements Element {
    private final int TYPE;
    private GlobalDataBlock block;
    private ExecutorService executor;
    private Future<Papyrus> task;

    public GlobalData(LittleEndianInput input, ESSContext ctx) throws IOException {
        assert (null != input);
        this.TYPE = input.readInt();
        int size = input.readInt();
        byte[] DATA = new byte[size];
        int read = input.read(DATA);
        if (read != size) {
            // empty if block
        }
        this.block = new DefaultGlobalDataBlock(DATA);
        if (this.TYPE == 1001) {
            this.executor = Executors.newSingleThreadExecutor();
            this.task = this.executor.submit(() -> {
                try {
                    return new Papyrus(DATA, ctx, false);
                }
                catch (IOException ex) {
                    if (ctx.GAME.isSLE()) {
                        return new Papyrus(DATA, ctx, true);
                    }
                    throw ex;
                }
            });
        } else {
            this.executor = null;
            this.task = null;
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeInt(this.TYPE);
        output.writeInt(this.block.calculateSize());
        this.block.write(output);
    }

    @Override
    public int calculateSize() {
        return 8 + this.block.calculateSize();
    }

    public int getType() {
        return this.TYPE;
    }

    public GlobalDataBlock getDataBlock() {
        return this.block;
    }

    public Papyrus getPapyrus() throws IOException {
        if (this.TYPE != 1001) {
            throw new IllegalStateException("Not a papyrus block.");
        }
        if (null != this.task) {
            try {
                this.block = this.task.get();
                this.executor.shutdown();
                this.executor = null;
                this.task = null;
            }
            catch (InterruptedException | ExecutionException ex) {
                throw new IOException("Couldn't process Papyrus block.", ex);
            }
        }
        return (Papyrus)this.block;
    }

    public String toString() {
        return super.toString() + ": type " + Integer.toString(this.TYPE);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.block);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalData other = (GlobalData)obj;
        return Objects.equals(this.block, other.block);
    }
}

