/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;
import restringer.ess.Game;
import restringer.ess.WString;

public final class Header
implements Element {
    public final String MAGIC;
    public final int VERSION;
    public final int SAVENUMBER;
    public final WString NAME;
    public final int LEVEL;
    public final WString LOCATION;
    public final WString GAMEDATE;
    public final WString RACEID;
    public final short SEX;
    public final float CURRENT_XP;
    public final float NEEDED_XP;
    public final long FILETIME;
    public final int SCREENSHOT_WIDTH;
    public final int SCREENSHOT_HEIGHT;
    public final int BYPP;
    public final short UNKNOWN_SHORT;
    public final Game GAME;
    private final byte[] SCREENSHOT;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Header(LittleEndianInput input) throws IOException {
        Objects.requireNonNull(input);
        byte[] magicBuffer = new byte[20];
        input.read(magicBuffer, 0, 3);
        switch (new String(magicBuffer, 0, 3).toUpperCase()) {
            case "TES": {
                input.read(magicBuffer, 3, 10);
                this.MAGIC = new String(magicBuffer, 0, 13);
                break;
            }
            case "FO4": {
                input.read(magicBuffer, 3, 9);
                this.MAGIC = new String(magicBuffer, 0, 12);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized header.");
            }
        }
        int HEADERSIZE = input.readInt();
        assert (HEADERSIZE < 256);
        this.VERSION = input.readInt();
        if (this.MAGIC.equalsIgnoreCase("TESV_SAVEGAME")) {
            if (8 <= this.VERSION && this.VERSION <= 9) {
                this.GAME = Game.SKYRIM;
            } else {
                if (this.VERSION != 12) throw new IllegalArgumentException("Unknown version of Skyrim: " + this.VERSION);
                this.GAME = Game.SKYRIMSE;
            }
        } else {
            if (!this.MAGIC.equalsIgnoreCase("FO4_SAVEGAME")) throw new IllegalArgumentException("Unknown game: " + this.MAGIC);
            if (11 > this.VERSION) throw new IllegalArgumentException("Unknown version of Fallout4: " + this.VERSION);
            this.GAME = Game.FALLOUT4;
        }
        this.SAVENUMBER = input.readInt();
        this.NAME = WString.read(input);
        this.LEVEL = input.readInt();
        this.LOCATION = WString.read(input);
        this.GAMEDATE = WString.read(input);
        this.RACEID = WString.read(input);
        this.SEX = input.readShort();
        this.CURRENT_XP = input.readFloat();
        this.NEEDED_XP = input.readFloat();
        this.FILETIME = input.readLong();
        this.SCREENSHOT_WIDTH = input.readInt();
        this.SCREENSHOT_HEIGHT = input.readInt();
        this.UNKNOWN_SHORT = this.GAME == Game.SKYRIMSE ? input.readShort() : (short)0;
        assert (HEADERSIZE == this.partialSize()) : String.format("Header size should be %d, found %d.", HEADERSIZE, this.partialSize());
        switch (this.GAME) {
            case SKYRIM: {
                this.BYPP = 3;
                break;
            }
            case FALLOUT4: 
            case SKYRIMSE: {
                this.BYPP = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid game: " + (Object)((Object)this.GAME));
            }
        }
        this.SCREENSHOT = new byte[this.BYPP * this.SCREENSHOT_WIDTH * this.SCREENSHOT_HEIGHT];
        input.readFully(this.SCREENSHOT);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.write(this.MAGIC.getBytes());
        output.writeInt(this.partialSize());
        output.writeInt(this.VERSION);
        output.writeInt(this.SAVENUMBER);
        output.writeESSElement(this.NAME);
        output.writeInt(this.LEVEL);
        output.writeESSElement(this.LOCATION);
        output.writeESSElement(this.GAMEDATE);
        output.writeESSElement(this.RACEID);
        output.writeShort(this.SEX);
        output.writeFloat(this.CURRENT_XP);
        output.writeFloat(this.NEEDED_XP);
        output.writeLong(this.FILETIME);
        output.writeInt(this.SCREENSHOT_WIDTH);
        output.writeInt(this.SCREENSHOT_HEIGHT);
        if (this.GAME == Game.SKYRIMSE) {
            output.writeShort(this.UNKNOWN_SHORT);
        }
        output.write(this.SCREENSHOT);
    }

    @Override
    public int calculateSize() {
        int sum = 4;
        sum += this.partialSize();
        sum += this.MAGIC.length();
        return sum += this.SCREENSHOT.length;
    }

    private int partialSize() {
        int sum = 0;
        sum += 4;
        sum += 4;
        sum += this.NAME.calculateSize();
        sum += 4;
        sum += this.LOCATION.calculateSize();
        sum += this.GAMEDATE.calculateSize();
        sum += this.RACEID.calculateSize();
        sum += 2;
        sum += 4;
        sum += 4;
        sum += 8;
        sum += 8;
        return sum += this.GAME == Game.SKYRIMSE ? 2 : 0;
    }

    public BufferedImage getImage() {
        assert (0 < this.SCREENSHOT_WIDTH);
        assert (0 < this.SCREENSHOT_HEIGHT);
        BufferedImage IMAGE = new BufferedImage(this.SCREENSHOT_WIDTH, this.SCREENSHOT_HEIGHT, 1);
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.SCREENSHOT.length; i += this.BYPP) {
            int rgb = 0;
            for (int k = 0; k < this.BYPP; ++k) {
                rgb += this.SCREENSHOT[i + k] << k * 8;
            }
            IMAGE.setRGB(x, y, rgb);
            if (++x >= this.SCREENSHOT_WIDTH) {
                x = 0;
                ++y;
            }
            assert (0 <= x && x < this.SCREENSHOT_WIDTH);
            assert (0 <= y && y <= this.SCREENSHOT_HEIGHT);
        }
        return IMAGE;
    }
}

