/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;
import restringer.ess.Plugin;

public final class PluginInfo
implements Element {
    private final List<Plugin> PLUGINS;

    public PluginInfo(LittleEndianInput input) throws IOException {
        Objects.requireNonNull(input);
        int size = input.readUnsignedByte();
        assert (size >= 0 && size < 256);
        this.PLUGINS = new ArrayList<Plugin>(size);
        for (int i = 0; i < size; ++i) {
            Plugin p = new Plugin(input, i);
            this.PLUGINS.add(p);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeByte(this.PLUGINS.size());
        for (Plugin p : this.PLUGINS) {
            p.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 1;
        return sum += this.PLUGINS.stream().mapToInt(plugin -> plugin.calculateSize()).sum();
    }

    public List<Plugin> getPlugins() {
        return Collections.unmodifiableList(this.PLUGINS);
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + this.PLUGINS.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginInfo other = (PluginInfo)obj;
        return Objects.equals(this.PLUGINS, other.PLUGINS);
    }
}

