/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.awt.image.BufferedImage;
import java.io.IOException;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;
import restringer.ess.Header;

public final class Screenshot
implements Element {
    private final int WIDTH;
    private final int HEIGHT;
    private final int BYPP;
    private final byte[] DATA;
    private transient BufferedImage image;

    public Screenshot(LittleEndianInput input, Header header) throws IOException {
        assert (null != header);
        assert (null != input);
        this.WIDTH = header.SCREENSHOT_WIDTH;
        this.HEIGHT = header.SCREENSHOT_HEIGHT;
        switch (header.GAME) {
            case SKYRIM: {
                this.BYPP = 3;
                break;
            }
            case FALLOUT4: 
            case SKYRIMSE: {
                this.BYPP = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid game: " + (Object)((Object)header.GAME));
            }
        }
        this.DATA = new byte[this.BYPP * this.WIDTH * this.HEIGHT];
        input.readFully(this.DATA);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.write(this.DATA);
    }

    @Override
    public int calculateSize() {
        return this.DATA.length;
    }

    public BufferedImage getImage() {
        assert (0 < this.WIDTH);
        assert (0 < this.HEIGHT);
        if (null == this.image) {
            this.image = new BufferedImage(this.WIDTH, this.HEIGHT, 1);
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.DATA.length; i += this.BYPP) {
                int rgb = 0;
                for (int k = 0; k < this.BYPP; ++k) {
                    rgb += this.DATA[i + k] << k * 8;
                }
                this.image.setRGB(x, y, rgb);
                if (++x >= this.WIDTH) {
                    x = 0;
                    ++y;
                }
                assert (0 <= x && x < this.WIDTH);
                assert (0 <= y && y <= this.HEIGHT);
            }
        }
        return this.image;
    }
}

