/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;

public final class VSVal
implements Element {
    private final byte[] DATA;
    private final int VALUE;

    public VSVal(LittleEndianInput input) throws IOException {
        int b1 = input.readUnsignedByte();
        int size = b1 & 3;
        switch (size) {
            case 0: {
                this.DATA = new byte[]{(byte)b1};
                this.VALUE = b1 >> 2;
                return;
            }
            case 1: {
                int b2 = input.readUnsignedByte();
                this.DATA = new byte[]{(byte)b1, (byte)b2};
                this.VALUE = (b1 | b2 << 8) >> 2;
                return;
            }
            case 2: {
                int b2 = input.readUnsignedByte();
                int b3 = input.readUnsignedByte();
                this.DATA = new byte[]{(byte)b1, (byte)b2, (byte)b3};
                this.VALUE = (b1 | b2 << 8 | b3 << 16) >> 2;
                return;
            }
        }
        throw new IOException();
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.write(this.DATA);
    }

    @Override
    public int calculateSize() {
        return this.DATA.length;
    }

    public String toString() {
        return String.format("%d", this.VALUE);
    }

    public int getValue() {
        return this.VALUE;
    }
}

