/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.mozilla.universalchardet.UniversalDetector;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;

public class WString
extends IString
implements Element {
    private final byte[] BYTES;
    private static final Logger LOG = Logger.getLogger(WString.class.getName());
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Set<Charset> CHARSET_LOG = new HashSet<Charset>();

    public static WString read(LittleEndianInput input) throws IOException {
        Charset CHARSET;
        Objects.requireNonNull(input);
        int LEN = input.readUnsignedShort();
        byte[] BYTES = new byte[LEN];
        int bytesRead = input.read(BYTES);
        assert (bytesRead == LEN) : String.format("String contained %d bytes, expected %d", bytesRead, LEN);
        UniversalDetector DETECTOR = new UniversalDetector(null);
        DETECTOR.handleData(BYTES, 0, BYTES.length);
        DETECTOR.dataEnd();
        String ENCODING = DETECTOR.getDetectedCharset();
        DETECTOR.reset();
        Charset charset = CHARSET = null == ENCODING ? UTF8 : Charset.forName(ENCODING);
        assert (null != CHARSET);
        if (CHARSET_LOG.add(CHARSET)) {
            LOG.info("Detected a new character encoding: " + CHARSET);
        }
        String STR = new String(BYTES, CHARSET);
        return new WString(STR, BYTES);
    }

    protected WString(WString other) {
        super(Objects.requireNonNull(other));
        this.BYTES = other.BYTES;
    }

    protected WString(CharSequence cs) {
        super(Objects.requireNonNull(cs));
        this.BYTES = cs.toString().getBytes(UTF8);
    }

    private WString(CharSequence cs, byte[] bytes) {
        super(Objects.requireNonNull(cs));
        this.BYTES = Objects.requireNonNull(bytes);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        if (this.BYTES.length > 65535) {
            output.writeShort(65535);
            output.write(this.BYTES, 0, 65535);
        } else {
            output.writeShort(this.BYTES.length);
            output.write(this.BYTES);
        }
    }

    @Override
    public int calculateSize() {
        if (this.BYTES.length > 65535) {
            return 65537;
        }
        return 2 + this.BYTES.length;
    }

    public static Set<Charset> getCharsetLog() {
        return Collections.unmodifiableSet(CHARSET_LOG);
    }
}

