/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import java.util.SortedSet;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.Plugin;
import restringer.ess.RefID;
import restringer.ess.papyrus.ActiveScriptData;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;

public final class ActiveScript
implements PapyrusElement,
AnalyzableElement,
Linkable,
HasID {
    private final EID ID;
    private final byte TYPE;
    private ActiveScriptData data;
    private AnalyzableElement owner;

    public ActiveScript(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        this.ID = EID.read4byte(input);
        this.TYPE = input.readByte();
        this.owner = null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeESSElement(this.ID);
        output.writeByte(this.TYPE);
    }

    @Override
    public int calculateSize() {
        return 1 + this.ID.calculateSize();
    }

    public void zero() {
        this.data.getStackFrames().forEach(f -> f.zero());
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public byte getType() {
        return this.TYPE;
    }

    public AnalyzableElement getInstance() {
        return this.owner;
    }

    public ActiveScriptData getData() {
        return this.data;
    }

    public void setData(ActiveScriptData newData) {
        this.data = newData;
    }

    public boolean isTerminated() {
        return this.data.getStackFrames().stream().allMatch(f -> f.isZeroed());
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"thread://%s\">%s</a>", this.ID, this.toString());
    }

    public String toString() {
        StringBuilder BUILDER = new StringBuilder();
        if (null == this.data) {
            return this.ID + "-" + String.format("%02x", this.TYPE);
        }
        if (this.isTerminated()) {
            BUILDER.append("TERMINATED ");
        }
        if (this.isUndefined()) {
            StackFrame topFrame = this.data.getStackFrames().get(0);
            TString scriptName = topFrame.getScriptName();
            BUILDER.append("#").append(scriptName).append("# ");
        } else if (this.data.getStackFrames().size() > 0) {
            StackFrame topFrame = this.data.getStackFrames().get(0);
            TString scriptName = topFrame.getScriptName();
            BUILDER.append(scriptName).append(" ");
        }
        BUILDER.append("(").append(this.ID).append(") ");
        BUILDER.append(this.data.getStackFrames().size()).append(" frames");
        return BUILDER.toString();
    }

    @Override
    public String getInfo(Profile.Analysis analysis, ESS save) {
        StackFrame topFrame;
        SortedSet<String> mods;
        StringBuilder BUILDER = new StringBuilder();
        if (this.isTerminated()) {
            BUILDER.append("<html><h3>ACTIVESCRIPT (TERMINATED)</h3>");
        } else {
            BUILDER.append("<html><h3>ACTIVESCRIPT</h3>");
        }
        if (this.isTerminated()) {
            BUILDER.append("<p><em>WARNING: SCRIPT TERMINATED!</em><br/>This thread has been terminated and all of its instructions erased.</p>");
        } else if (this.isUndefined()) {
            BUILDER.append("<p><em>WARNING: SCRIPT MISSING!</em><br/>Remove Undefined Instances\" will terminate this thread.</p>");
        }
        if (null != analysis && !this.data.getStackFrames().isEmpty() && null != (mods = analysis.SCRIPT_ORIGINS.get((topFrame = this.data.getStackFrames().get(0)).getScriptName()))) {
            String mod = mods.last();
            BUILDER.append(String.format("<p>Probably running code from mod %s.</p>", mod));
        }
        if (null == this.owner) {
            BUILDER.append("<p>This thread doesn't seem to be attached to an instance.</p>");
        } else if (this.owner instanceof ScriptInstance) {
            ScriptInstance instance = (ScriptInstance)this.owner;
            RefID REF = instance.getRefID();
            Plugin PLUGIN = REF.getPlugin();
            if (PLUGIN != null) {
                BUILDER.append(String.format("<p>This thread is attached to an instance from %s.</p>", PLUGIN.toHTML()));
            } else if (instance.getRefID().getType() == RefID.Type.CREATED) {
                BUILDER.append("<p>This thread is attach to instance that was created in-game.</p>");
            }
        }
        if (null == this.owner) {
            BUILDER.append("<p>No owner was identified.</p>");
        } else if (this.owner instanceof Linkable) {
            Linkable l = (Linkable)((Object)this.owner);
            String type = this.owner.getClass().getSimpleName();
            BUILDER.append(String.format("<p>%s: %s</p>", type, l.toHTML()));
        } else {
            String type = this.owner.getClass().getSimpleName();
            BUILDER.append(String.format("<p>%s: %s</p>", type, this.owner));
        }
        BUILDER.append("<p>");
        BUILDER.append(String.format("ID: %s<br/>", this.getID()));
        BUILDER.append(String.format("Type: %02x<br/>", this.TYPE, this.TYPE));
        BUILDER.append(String.format("Version: %d.%d<br/>", this.data.getMajorVersion(), this.data.getMinorVersion()));
        BUILDER.append(String.format("Unknown (var): %s<br/>", this.data.getUnknownVar().toHTML()));
        BUILDER.append(String.format("Flag: %08x<br/>", this.data.getFlag()));
        BUILDER.append(String.format("Unknown1 (byte): %02x<br/>", this.data.getUnknownByte()));
        BUILDER.append(String.format("Unknown2 (int): %08x<br/>", this.data.getUnknown2()));
        BUILDER.append(String.format("Unknown3 (byte): %02x<br/>", this.data.getUnknown3()));
        if (null != this.data.getUnknown4()) {
            BUILDER.append(String.format("Unknown4 (struct): %s<br/>", this.data.getUnknown4().toHTML()));
        } else {
            BUILDER.append(String.format("Unknown4 (struct): %s<br/>", this.data.getUnknown4()));
        }
        BUILDER.append(String.format("Unknown5 (byte): %02x<br/>", this.data.getUnknown5()));
        Element UNKNOWN2 = save.broadSpectrumMatch(this.getData().getUnknown2());
        if (null != UNKNOWN2) {
            BUILDER.append("<p>Potential match for unknown2 found using general search:<br/>");
            if (UNKNOWN2 instanceof Linkable) {
                BUILDER.append(((Linkable)((Object)UNKNOWN2)).toHTML());
            } else {
                BUILDER.append(UNKNOWN2.toString());
            }
            BUILDER.append("</p>");
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        return this.data.getStackFrames().stream().anyMatch(v -> v.matches(analysis, mod));
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        assert (null != this.data);
        this.data.addNames(names, strings);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        assert (null != this.data);
        this.data.resolveRefs(ess, this);
        if (this.data.getStackFrames().size() > 0) {
            Variable.RefID ref = (Variable.RefID)this.data.getStackFrames().get(0).getOwner();
            this.owner = ref.getReferent();
        }
    }

    public boolean hasScript(Script script) {
        if (null == this.data) {
            return false;
        }
        return this.data.getStackFrames().stream().anyMatch(frame -> frame.getScript() == script);
    }

    public boolean isUndefined() {
        if (null == this.data) {
            return false;
        }
        return this.data.getStackFrames().stream().anyMatch(frame -> frame.isUndefined());
    }
}

