/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.ArrayMap;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Variable;

public final class ArrayData
implements PapyrusElement,
HasID {
    private final EID ID;
    private final List<Variable> DATA;

    public ArrayData(LittleEndianInput input, ArrayMap arrays, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(arrays);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isSSE() || ctx.GAME.isFO4() ? EID.read8byte(input) : EID.read4byte(input);
        assert (arrays.containsKey(this.ID));
        int length = ((ArrayInfo)arrays.get(this.ID)).getLength();
        this.DATA = new ArrayList<Variable>(length);
        int i = 0;
        try {
            for (i = 0; i < length; ++i) {
                Variable var = Variable.read(input, ctx);
                this.DATA.add(var);
            }
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d members.", i, length), ex);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeESSElement(this.ID);
        for (Variable var : this.DATA) {
            var.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        sum += this.ID.calculateSize();
        return sum += this.DATA.stream().mapToInt(var -> var.calculateSize()).sum();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public List<Variable> getMembers() {
        return this.DATA;
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        this.DATA.forEach(v -> v.addNames(names, strings));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.DATA.forEach(var -> var.resolveRefs(ess, owner));
    }

    public String toString() {
        return this.ID.toString() + this.DATA;
    }
}

