/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.SortedSet;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.ArrayData;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Type;

public final class ArrayInfo
implements PapyrusElement,
AnalyzableElement,
Linkable,
HasID {
    private final EID ID;
    private final Type TYPE;
    private final TString REFTYPE;
    private final int LENGTH;
    private final Collection<PapyrusElement> HOLDERS = new ArrayList<PapyrusElement>(1);
    private ArrayData data;
    private static final Type[] VALID_TYPES = new Type[]{Type.NULL, Type.REF, Type.STRING, Type.INTEGER, Type.FLOAT, Type.BOOLEAN};

    public ArrayInfo(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isSSE() || ctx.GAME.isFO4() ? EID.read8byte(input) : EID.read4byte(input);
        Type t = Type.read(input);
        if (!Arrays.asList(VALID_TYPES).contains(t)) {
            throw new IOException("Invalid ArrayInfo type: " + t);
        }
        this.TYPE = t;
        this.REFTYPE = this.TYPE == Type.REF ? ctx.STRINGS.read(input) : null;
        this.LENGTH = input.readInt();
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeESSElement(this.ID);
        this.TYPE.write(output);
        if (null != this.REFTYPE) {
            this.REFTYPE.write(output);
        }
        output.writeInt(this.LENGTH);
    }

    @Override
    public int calculateSize() {
        int sum = 5;
        sum += this.ID.calculateSize();
        if (null != this.REFTYPE) {
            sum += this.REFTYPE.calculateSize();
        }
        return sum;
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public Type getType() {
        assert (Arrays.asList(VALID_TYPES).contains(this.TYPE));
        return this.TYPE;
    }

    public TString getRefType() {
        return this.REFTYPE;
    }

    public int getLength() {
        return this.LENGTH;
    }

    public ArrayData getData() {
        return this.data;
    }

    public void setData(ArrayData newData) {
        this.data = newData;
    }

    public String toValueString() {
        if (this.TYPE == Type.REF) {
            return this.REFTYPE + "[" + this.LENGTH + "]";
        }
        if (this.TYPE == Type.NULL && 0 < this.LENGTH) {
            Type t = this.getData().getMembers().get(0).getType();
            return t + "[" + this.LENGTH + "]";
        }
        return this.TYPE + "[" + this.LENGTH + "]";
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"array://%s\">%s</a>", this.ID, this);
    }

    public String toString() {
        return this.toValueString() + " " + this.ID + " " + "(" + this.HOLDERS.size() + " owners)";
    }

    @Override
    public String getInfo(Profile.Analysis analysis, ESS save) {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("<html><h3>ARRAY</h3>");
        if (this.HOLDERS.isEmpty()) {
            BUILDER.append("<p><em>WARNING: THIS ARRAY HAS NO OWNER.</em></p>");
        } else {
            BUILDER.append("<p>Owners:</p><ul>");
            this.HOLDERS.stream().forEach(owner -> {
                if (owner instanceof Linkable) {
                    BUILDER.append(String.format("<li>%s %s", owner.getClass().getSimpleName(), ((Linkable)((Object)owner)).toHTML()));
                } else {
                    BUILDER.append(String.format("<li>%s %s", owner.getClass().getSimpleName(), owner));
                }
            });
            BUILDER.append("</ul>");
        }
        if (null != analysis) {
            this.HOLDERS.forEach(owner -> {
                ScriptInstance instance;
                SortedSet<String> mods;
                if (owner instanceof ScriptInstance && null != (mods = analysis.SCRIPT_ORIGINS.get((instance = (ScriptInstance)owner).getScriptName()))) {
                    String mod = mods.last();
                    TString type = instance.getScriptName();
                    BUILDER.append(String.format("<p>Probably created by script <a href=\"script://%s\">%s</a> which came from mod \"%s\".</p>", type, type, mod));
                }
            });
        }
        BUILDER.append("<p>");
        BUILDER.append(String.format("ID: %s</p>", this.getID()));
        BUILDER.append(String.format("Content type: %s</p>", this.TYPE));
        if (this.TYPE == Type.REF) {
            Script SCRIPT = (Script)save.getPapyrus().getScripts().get(this.REFTYPE);
            if (null != SCRIPT) {
                BUILDER.append(String.format("Reference type: %s<br/>", SCRIPT.toHTML()));
            } else {
                BUILDER.append(String.format("Reference type: %s<br/>", this.REFTYPE));
            }
        }
        BUILDER.append(String.format("Length: %d<br/>", this.getLength()));
        BUILDER.append("</p>");
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        return false;
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        assert (null != this.data);
        this.data.addNames(names, strings);
    }

    public PapyrusElement getHolder() {
        if (this.HOLDERS.size() == 1) {
            return this.HOLDERS.iterator().next();
        }
        return null;
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        assert (null != this.data);
        this.data.resolveRefs(ess, this);
        if (null != this.REFTYPE) {
            this.REFTYPE.addRefHolder(this);
        }
    }

    public void addRefHolder(PapyrusElement newHolder) {
        Objects.requireNonNull(newHolder);
        this.HOLDERS.add(newHolder);
    }
}

