/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.PapyrusElement;

public abstract class EID
implements PapyrusElement,
Comparable<EID> {
    private static final String[] ZEROES = EID.makeZeroes();

    public static EID read4byte(LittleEndianInput input) throws IOException {
        return new EID32(input);
    }

    public static EID read8byte(LittleEndianInput input) throws IOException {
        return new EID64(input);
    }

    public static EID make4byte(int val) {
        return new EID32(val);
    }

    public static EID make8Byte(long val) {
        return new EID64(val);
    }

    public abstract long longValue();

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    public boolean isUndefined() {
        return this.isZero();
    }

    public boolean isZero() {
        return this.longValue() == 0L;
    }

    @Override
    public int compareTo(EID other) {
        Objects.requireNonNull(other);
        return Long.compareUnsigned(this.longValue(), other.longValue());
    }

    public int hashCode() {
        return Long.hashCode(this.longValue());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EID)) {
            return false;
        }
        EID other = (EID)obj;
        return this.longValue() == other.longValue();
    }

    public static String pad8(int id) {
        String hex = Integer.toHexString(id);
        int length = hex.length();
        assert (length <= ZEROES.length);
        return ZEROES[8 - length] + hex;
    }

    public static String pad16(long id) {
        String hex = Long.toHexString(id);
        int length = hex.length();
        assert (length <= ZEROES.length);
        return ZEROES[16 - length] + hex;
    }

    private static String[] makeZeroes() {
        String[] zeroes = new String[16];
        zeroes[0] = "";
        for (int i = 1; i < zeroes.length; ++i) {
            zeroes[i] = zeroes[i - 1] + "0";
        }
        return zeroes;
    }

    private static class EID64
    extends EID {
        public final long VALUE;

        public EID64(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.VALUE = input.readLong();
        }

        public EID64(long val) {
            this.VALUE = val;
        }

        @Override
        public long longValue() {
            return this.VALUE;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            Objects.requireNonNull(output);
            output.writeLong(this.VALUE);
        }

        @Override
        public int calculateSize() {
            return 8;
        }

        public String toString() {
            return EID64.pad16(this.VALUE);
        }
    }

    private static class EID32
    extends EID {
        public final int VALUE;

        public EID32(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            this.VALUE = input.readInt();
        }

        public EID32(int val) {
            this.VALUE = val;
        }

        @Override
        public long longValue() {
            return this.VALUE;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            Objects.requireNonNull(output);
            output.writeInt(this.VALUE);
        }

        @Override
        public int calculateSize() {
            return 4;
        }

        public String toString() {
            return EID32.pad8(this.VALUE);
        }
    }
}

