/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import java.util.SortedSet;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.FunctionMessageData;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.TString;

public final class FunctionMessage
implements PapyrusElement,
AnalyzableElement,
Linkable {
    private final byte UNKNOWN;
    private final EID ID;
    private final byte FLAG;
    private final FunctionMessageData MESSAGE;

    public FunctionMessage(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(scripts);
        Objects.requireNonNull(ctx);
        this.UNKNOWN = input.readByte();
        this.ID = this.UNKNOWN <= 2 ? EID.read4byte(input) : null;
        this.FLAG = input.readByte();
        this.MESSAGE = this.FLAG > 0 ? new FunctionMessageData(input, this, scripts, ctx) : null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeByte(this.UNKNOWN);
        if (this.UNKNOWN <= 2) {
            output.writeESSElement(this.ID);
        }
        output.writeByte(this.FLAG);
        if (null != this.MESSAGE) {
            this.MESSAGE.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 2;
        sum += this.UNKNOWN <= 2 ? 4 : 0;
        return sum += null == this.MESSAGE ? 0 : this.MESSAGE.calculateSize();
    }

    public EID getID() {
        return this.ID;
    }

    public FunctionMessageData getMessage() {
        return this.MESSAGE;
    }

    public Script getScript() {
        if (null == this.MESSAGE) {
            return null;
        }
        return this.MESSAGE.getScript();
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"message://%s\">%s</a>", this.ID, this.toString());
    }

    public String toString() {
        if (this.FLAG > 0) {
            TString scriptName;
            TString tString = scriptName = null != this.MESSAGE ? this.MESSAGE.getScriptName() : null;
            if (this.isUndefined()) {
                if (this.UNKNOWN <= 2) {
                    return "MSG #" + scriptName + "# (" + this.ID + ")";
                }
                return "MSG #" + scriptName;
            }
            if (this.UNKNOWN <= 2) {
                return "MSG " + scriptName + " (" + this.ID + ")";
            }
            return "MSG " + scriptName;
        }
        if (this.UNKNOWN <= 2) {
            return "MSG " + this.FLAG + "," + EID.pad8(this.UNKNOWN) + " (" + this.ID + ")";
        }
        return "MSG " + this.FLAG + "," + EID.pad8(this.UNKNOWN);
    }

    @Override
    public String getInfo(Profile.Analysis analysis, ESS save) {
        SortedSet<String> mods;
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append(String.format("<html><h3>FUNCTIONMESSAGE</h3>", new Object[0]));
        if (null != analysis && null != this.MESSAGE && null != (mods = analysis.SCRIPT_ORIGINS.get(this.MESSAGE.getScriptName()))) {
            String mod = mods.last();
            BUILDER.append(String.format("<p>Probably running code from mod %s.</p>", mod));
        }
        BUILDER.append("<p>");
        if (null != this.MESSAGE) {
            BUILDER.append(String.format("Function: %s<br/>", this.MESSAGE.getFName()));
        }
        BUILDER.append(String.format("ID: %s<br/>", this.ID));
        BUILDER.append(String.format("Flag: %s<br/>", this.FLAG));
        BUILDER.append(String.format("Unknown: %d<br/>", this.UNKNOWN));
        BUILDER.append("</p>");
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        return null != this.MESSAGE && this.MESSAGE.matches(analysis, mod);
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        if (null != this.MESSAGE) {
            this.MESSAGE.addNames(names, strings);
        }
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        if (null != this.MESSAGE) {
            this.MESSAGE.resolveRefs(ess, this);
        }
    }

    public boolean isUndefined() {
        if (null != this.MESSAGE) {
            return this.MESSAGE.isUndefined();
        }
        return false;
    }
}

