/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.SortedSet;
import restringer.IString;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;

public class FunctionMessageData
implements PapyrusElement,
AnalyzableElement {
    private final byte UNKNOWN;
    private final TString SCRIPTNAME;
    private final Script SCRIPT;
    private final TString EVENT;
    private final Variable UNKNOWNVAR;
    private final List<Variable> MEMBERS;

    public FunctionMessageData(LittleEndianInput input, PapyrusElement parent, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(scripts);
        Objects.requireNonNull(ctx);
        this.UNKNOWN = input.readByte();
        this.SCRIPTNAME = ctx.STRINGS.read(input);
        this.SCRIPT = scripts.getOrDefault(this.SCRIPTNAME, null);
        this.EVENT = ctx.STRINGS.read(input);
        this.UNKNOWNVAR = Variable.read(input, ctx);
        int varCount = input.readInt();
        this.MEMBERS = new ArrayList<Variable>(varCount);
        for (int i = 0; i < varCount; ++i) {
            Variable var = Variable.read(input, ctx);
            this.MEMBERS.add(var);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeByte(this.UNKNOWN);
        this.SCRIPTNAME.write(output);
        this.EVENT.write(output);
        this.UNKNOWNVAR.write(output);
        output.writeInt(this.MEMBERS.size());
        for (Variable var : this.MEMBERS) {
            var.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 1;
        sum += this.SCRIPTNAME.calculateSize();
        sum += this.EVENT.calculateSize();
        sum += this.UNKNOWNVAR.calculateSize();
        sum += 4;
        return sum += this.MEMBERS.stream().mapToInt(var -> var.calculateSize()).sum();
    }

    public TString getScriptName() {
        return this.SCRIPTNAME;
    }

    public Script getScript() {
        return this.SCRIPT;
    }

    public TString getEvent() {
        return this.EVENT;
    }

    public List<Variable> getMembers() {
        return Collections.unmodifiableList(this.MEMBERS);
    }

    public IString getFName() {
        IString fname = IString.format("%s.%s", this.SCRIPTNAME, this.EVENT);
        return fname;
    }

    public String toString() {
        if (this.isUndefined()) {
            return "#" + this.SCRIPTNAME + "#." + this.EVENT;
        }
        return this.SCRIPTNAME + "." + this.EVENT;
    }

    @Override
    public String getInfo(Profile.Analysis analysis, ESS save) {
        SortedSet<String> providers;
        StringBuilder BUILDER = new StringBuilder();
        if (null != this.SCRIPT) {
            BUILDER.append(String.format("<html><h3>FUNCTIONMESSAGEDATA of %s</h3>", this.SCRIPT.toHTML()));
        } else {
            BUILDER.append(String.format("<html><h3>FUNCTIONMESSAGEDATA of %s</h3>", this.SCRIPTNAME));
        }
        if (null != analysis && null != (providers = analysis.SCRIPT_ORIGINS.get(this.SCRIPTNAME))) {
            String probablyProvider = providers.last();
            BUILDER.append(String.format("<p>This message probably came from \"%s\".</p>", probablyProvider));
            if (providers.size() > 1) {
                BUILDER.append("<p>Full list of providers:</p><ul>");
                providers.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                BUILDER.append("</ul>");
            }
        }
        BUILDER.append("<p>");
        if (null != this.SCRIPT) {
            BUILDER.append(String.format("Script: %s<br/>", this.SCRIPT.toHTML()));
        } else {
            BUILDER.append(String.format("Script: %s<br/>", this.SCRIPTNAME));
        }
        BUILDER.append(String.format("Event: %s<br/>", this.EVENT));
        BUILDER.append(String.format("Unknown: %02x<br/>", this.UNKNOWN));
        if (null != this.UNKNOWNVAR) {
            BUILDER.append(String.format("Unknown variable: %s<br/>", this.UNKNOWNVAR.toHTML()));
        } else {
            BUILDER.append(String.format("Unknown variable: %s<br/>", this.UNKNOWNVAR));
        }
        BUILDER.append(String.format("%d additional variables.<br/>", this.MEMBERS.size()));
        BUILDER.append("</p>");
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        SortedSet<String> OWNERS = analysis.SCRIPT_ORIGINS.get(this.SCRIPTNAME);
        if (null == OWNERS) {
            return false;
        }
        return OWNERS.contains(mod);
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        this.UNKNOWNVAR.addNames(names, strings);
        this.MEMBERS.forEach(var -> var.addNames(names, strings));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.UNKNOWNVAR.resolveRefs(ess, this);
        this.MEMBERS.forEach(var -> var.resolveRefs(ess, this));
        this.SCRIPTNAME.addRefHolder(owner);
        this.EVENT.addRefHolder(owner);
    }

    public boolean isUndefined() {
        if (null == this.SCRIPT) {
            return !Script.IMPLICITSCRIPTS.contains(this.SCRIPTNAME);
        }
        return this.SCRIPT.isUndefined();
    }
}

