/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import java.util.SortedSet;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.TString;

public abstract class GameElement
implements AnalyzableElement,
Linkable,
PapyrusElement,
HasID {
    private final EID ID;
    private final TString SCRIPTNAME;
    private final Script SCRIPT;

    public GameElement(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(scripts);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isSSE() || ctx.GAME.isFO4() ? EID.read8byte(input) : EID.read4byte(input);
        this.SCRIPTNAME = ctx.STRINGS.read(input);
        this.SCRIPT = scripts.getOrDefault(this.SCRIPTNAME, null);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeESSElement(this.ID);
        output.writeESSElement(this.SCRIPTNAME);
    }

    @Override
    public int calculateSize() {
        int sum = 0;
        sum += this.ID.calculateSize();
        return sum += this.SCRIPTNAME.calculateSize();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public TString getScriptName() {
        return this.SCRIPTNAME;
    }

    public Script getScript() {
        return this.SCRIPT;
    }

    public boolean isUndefined() {
        if (null == this.SCRIPT) {
            return !Script.IMPLICITSCRIPTS.contains(this.SCRIPTNAME);
        }
        return this.SCRIPT.isUndefined();
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.SCRIPTNAME.addRefHolder(this);
        if (null != this.SCRIPT) {
            this.SCRIPT.incrementInstanceCount();
        }
    }

    @Override
    public boolean matches(Profile.Analysis analysis, String mod) {
        Objects.requireNonNull(analysis);
        Objects.requireNonNull(mod);
        SortedSet<String> OWNERS = analysis.SCRIPT_ORIGINS.get(this.SCRIPTNAME);
        if (null == OWNERS) {
            return false;
        }
        return OWNERS.contains(mod);
    }
}

