/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.TString;

public class MemberData
implements PapyrusElement {
    private final TString NAME;
    private final TString TYPE;
    private Script script;

    public MemberData(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        this.NAME = ctx.STRINGS.read(input);
        this.TYPE = ctx.STRINGS.read(input);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        this.NAME.write(output);
        this.TYPE.write(output);
    }

    @Override
    public int calculateSize() {
        return this.NAME.calculateSize() + this.TYPE.calculateSize();
    }

    public TString getName() {
        return this.NAME;
    }

    public TString getType() {
        return this.TYPE;
    }

    public Script getScript() {
        return this.script;
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.script = ess.getPapyrus().getScripts().getOrDefault(this.TYPE, null);
        this.NAME.addRefHolder(owner);
        this.TYPE.addRefHolder(owner);
    }

    public String toString() {
        return this.TYPE + " " + this.NAME;
    }
}

