/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.ess.Element;
import restringer.ess.RefID;
import restringer.ess.papyrus.StringTable;

public abstract class MiscArray
implements Element {
    protected final ArrayList<Element> CONTENTS = new ArrayList();

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        for (Element e : this.CONTENTS) {
            e.write(output);
        }
    }

    @Override
    public int calculateSize() {
        return this.CONTENTS.stream().mapToInt(v -> v.calculateSize()).sum();
    }

    private static class PByte
    implements Element {
        final byte VAL;

        public PByte(LittleEndianInput input) throws IOException {
            this.VAL = input.readByte();
        }

        public PByte(byte b) {
            this.VAL = b;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.VAL);
        }

        @Override
        public int calculateSize() {
            return 1;
        }
    }

    private static class PShort
    implements Element {
        final short VAL;

        public PShort(LittleEndianInput input) throws IOException {
            this.VAL = input.readShort();
        }

        public PShort(short v) {
            this.VAL = v;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeShort(this.VAL);
        }

        @Override
        public int calculateSize() {
            return 2;
        }
    }

    private static class PInt
    implements Element {
        final int VAL;

        public PInt(LittleEndianInput input) throws IOException {
            this.VAL = input.readInt();
        }

        public PInt(int v) {
            this.VAL = v;
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeInt(this.VAL);
        }

        @Override
        public int calculateSize() {
            return 4;
        }
    }

    public static class Array_4c
    extends MiscArray {
        public Array_4c(LittleEndianInput input, StringTable strings) throws IOException {
            byte flag = input.readByte();
            this.CONTENTS.add(new PByte(flag));
            this.CONTENTS.add(new PInt(input));
            this.CONTENTS.add(new RefID(input));
            if (0 <= flag && flag <= 6) {
                this.CONTENTS.add(new PInt(input));
                this.CONTENTS.add(new PInt(input));
                this.CONTENTS.add(new PInt(input));
            }
            if (flag == 0) {
                this.CONTENTS.add(new PInt(input));
                this.CONTENTS.add(new PInt(input));
                this.CONTENTS.add(new PInt(input));
                this.CONTENTS.add(new PInt(input));
            }
            if (0 <= flag && flag <= 3) {
                this.CONTENTS.add(new PByte(input));
            }
        }
    }

    public static class Array_4b
    extends MiscArray {
        public Array_4b(LittleEndianInput input, StringTable strings) throws IOException {
            this.CONTENTS.add(new PByte(input));
            this.CONTENTS.add(new PShort(input));
            this.CONTENTS.add(new PShort(input));
            this.CONTENTS.add(new RefID(input));
            this.CONTENTS.add(new RefID(input));
            this.CONTENTS.add(new RefID(input));
            this.CONTENTS.add(new RefID(input));
        }
    }

    public static class Array_4
    extends MiscArray {
        public Array_4(LittleEndianInput input, StringTable strings) throws IOException {
            this.CONTENTS.add(strings.read(input));
            this.CONTENTS.add(new PShort(input));
            this.CONTENTS.add(new PByte(input));
            this.CONTENTS.add(strings.read(input));
            this.CONTENTS.add(new PInt(input));
            this.CONTENTS.add(new PShort(input));
            this.CONTENTS.add(new RefID(input));
        }
    }

    public static class Array_3
    extends MiscArray {
        public Array_3(LittleEndianInput input, StringTable strings) throws IOException {
            this.CONTENTS.add(new PByte(input));
            this.CONTENTS.add(strings.read(input));
            this.CONTENTS.add(new PShort(input));
            this.CONTENTS.add(strings.read(input));
            this.CONTENTS.add(new PInt(input));
            this.CONTENTS.add(new PShort(input));
            this.CONTENTS.add(new RefID(input));
        }
    }

    public static class Array_1_2
    extends MiscArray {
        public Array_1_2(LittleEndianInput input, StringTable strings) throws IOException {
            this.CONTENTS.add(new PInt(input));
            this.CONTENTS.add(new PInt(input));
        }
    }
}

