/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.Parameter;
import restringer.pex.Opcode;

public final class OpcodeData
implements PapyrusElement {
    public static final OpcodeData NOP = new OpcodeData();
    private final Opcode OPCODE;
    private final ArrayList<Parameter> PARAMETERS;
    private static final Opcode[] OPCODES = Opcode.values();

    public OpcodeData(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        byte code = input.readByte();
        this.OPCODE = OPCODES[code];
        if (this.OPCODE.ARGS > 0) {
            this.PARAMETERS = new ArrayList(this.OPCODE.ARGS);
            for (int i = 0; i < this.OPCODE.ARGS; ++i) {
                Parameter var = new Parameter(input, ctx.STRINGS);
                this.PARAMETERS.add(var);
            }
        } else if (this.OPCODE.ARGS < 0) {
            this.PARAMETERS = new ArrayList(-this.OPCODE.ARGS);
            for (int i = 0; i < 1 - this.OPCODE.ARGS; ++i) {
                Parameter var = new Parameter(input, ctx.STRINGS);
                this.PARAMETERS.add(var);
            }
            int numVargs = this.PARAMETERS.get(-this.OPCODE.ARGS).getIntValue();
            this.PARAMETERS.ensureCapacity(this.PARAMETERS.size() + numVargs);
            for (int i = 0; i < numVargs; ++i) {
                Parameter var = new Parameter(input, ctx.STRINGS);
                this.PARAMETERS.add(var);
            }
        } else {
            this.PARAMETERS = new ArrayList(0);
        }
    }

    private OpcodeData() {
        this.OPCODE = Opcode.NOP;
        this.PARAMETERS = new ArrayList(0);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        output.writeByte(this.OPCODE.ordinal());
        for (Parameter var : this.PARAMETERS) {
            var.write(output);
        }
    }

    @Override
    public int calculateSize() {
        int sum = 1;
        return sum += this.PARAMETERS.stream().mapToInt(var -> var.calculateSize()).sum();
    }

    public Opcode getOpcode() {
        return this.OPCODE;
    }

    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.PARAMETERS);
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        this.PARAMETERS.forEach(v -> v.addNames(names, strings));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.PARAMETERS.forEach(v -> v.resolveRefs(ess, owner));
    }

    public String toString() {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append((Object)this.OPCODE);
        this.PARAMETERS.forEach(p -> BUILDER.append(' ').append(p.toValueString()));
        return BUILDER.toString();
    }

    public int hashCode() {
        int hash = 3;
        hash = 29 * hash + Objects.hashCode((Object)this.OPCODE);
        hash = 29 * hash + Objects.hashCode(this.PARAMETERS);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpcodeData other = (OpcodeData)obj;
        if (this.OPCODE != other.OPCODE) {
            return false;
        }
        return Objects.equals(this.PARAMETERS, other.PARAMETERS);
    }
}

