/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInputStream;
import restringer.esp.ESPIDMap;
import restringer.ess.ESS;
import restringer.ess.ESSContext;
import restringer.ess.Element;
import restringer.ess.GlobalDataBlock;
import restringer.ess.Linkable;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ActiveScriptData;
import restringer.ess.papyrus.ActiveScriptMap;
import restringer.ess.papyrus.ArrayData;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.ArrayMap;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.FunctionMessage;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.InstanceMap;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.QueuedUnbind;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.ReferenceData;
import restringer.ess.papyrus.ReferenceMap;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptData;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.ScriptMap;
import restringer.ess.papyrus.StringTable;
import restringer.ess.papyrus.Struct;
import restringer.ess.papyrus.StructDef;
import restringer.ess.papyrus.StructDefMap;
import restringer.ess.papyrus.StructMap;
import restringer.ess.papyrus.SuspendedStack;

public final class Papyrus
implements PapyrusElement,
GlobalDataBlock {
    private final short HEADER;
    private final int PAPYRUS_RUNTIME;
    private final short SAVE_FILE_VERSION;
    private final int UNK1;
    private final int UNK2;
    private final StringTable STRINGS;
    private final ScriptMap SCRIPTS;
    private final StructDefMap STRUCTDEFS;
    private final InstanceMap INSTANCES;
    private final ReferenceMap REFERENCES;
    private final StructMap STRUCTS;
    private final ArrayMap ARRAYS;
    private final ActiveScriptMap ACTIVESCRIPTS;
    private final List<FunctionMessage> FUNCTIONMESSAGES;
    private final List<SuspendedStack> SUSPENDEDSTACKS1;
    private final List<SuspendedStack> SUSPENDEDSTACKS2;
    private final List<EID> UNKS;
    private final List<QueuedUnbind> UNBINDS;
    private final byte[] OTHERDATA;

    public Papyrus(byte[] buffer, ESSContext essCTX, boolean applySTBCorrection) throws IOException {
        Objects.requireNonNull(buffer);
        try (LittleEndianInputStream input = LittleEndianInputStream.debug(buffer);){
            EID id;
            HasID data;
            int scriptCount;
            int sum = 0;
            int i = 0;
            this.HEADER = input.readShort();
            sum += 2;
            this.STRINGS = new StringTable(input, essCTX.GAME, applySTBCorrection);
            sum += this.STRINGS.calculateSize();
            PapyrusContext CTX = new PapyrusContext(essCTX, this.STRINGS);
            if (CTX.GAME.isFO4()) {
                scriptCount = input.readInt();
                this.SCRIPTS = new ScriptMap(scriptCount);
                int structDefCount = input.readInt();
                this.STRUCTDEFS = new StructDefMap(structDefCount);
                try {
                    for (i = 0; i < scriptCount; ++i) {
                        Script script = new Script(input, CTX);
                        this.SCRIPTS.put(script.getName(), script);
                    }
                    sum += 4 + this.SCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum();
                }
                catch (IOException ex) {
                    throw new IOException(String.format("Error; read %d/%d scripts.", i, scriptCount), ex);
                }
                try {
                    for (i = 0; i < structDefCount; ++i) {
                        StructDef struct = new StructDef(input, CTX);
                        this.STRUCTDEFS.put(struct.getName(), struct);
                    }
                    sum += 4 + this.STRUCTDEFS.values().stream().mapToInt(v -> v.calculateSize()).sum();
                }
                catch (IOException ex) {
                    throw new IOException(String.format("Error; read %d/%d struct definitions.", i, structDefCount), ex);
                }
            }
            scriptCount = input.readInt();
            this.SCRIPTS = new ScriptMap(scriptCount);
            this.STRUCTDEFS = null;
            try {
                for (i = 0; i < scriptCount; ++i) {
                    Script script = new Script(input, CTX);
                    this.SCRIPTS.put(script.getName(), script);
                }
                sum += 4 + this.SCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException | AssertionError ex) {
                throw new IOException(String.format("Error; read %d/%d script definitions.", i, scriptCount), (Throwable)ex);
            }
            int instanceCount = input.readInt();
            this.INSTANCES = new InstanceMap(instanceCount);
            try {
                for (i = 0; i < instanceCount; ++i) {
                    ScriptInstance instance = new ScriptInstance(input, this.SCRIPTS, CTX);
                    this.INSTANCES.put(instance.getID(), instance);
                }
                sum += 4 + this.INSTANCES.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d instance definitions.", i, instanceCount), ex);
            }
            int referenceCount = input.readInt();
            this.REFERENCES = new ReferenceMap(referenceCount);
            try {
                for (i = 0; i < referenceCount; ++i) {
                    Reference reference = new Reference(input, this.SCRIPTS, CTX);
                    this.REFERENCES.put(reference.getID(), reference);
                }
                sum += 4 + this.REFERENCES.values().stream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d reference definitions.", i, referenceCount), ex);
            }
            if (CTX.GAME.isFO4()) {
                int structCount = input.readInt();
                this.STRUCTS = new StructMap(structCount);
                try {
                    for (i = 0; i < structCount; ++i) {
                        Struct struct = new Struct(input, this.SCRIPTS, CTX);
                        this.STRUCTS.put(struct.getID(), struct);
                    }
                    sum += 4 + this.STRUCTS.values().stream().mapToInt(v -> v.calculateSize()).sum();
                }
                catch (IOException ex) {
                    throw new IOException(String.format("Error; read %d/%d struct instances.", i, structCount), ex);
                }
            } else {
                this.STRUCTS = null;
            }
            int arrayCount = input.readInt();
            this.ARRAYS = new ArrayMap(arrayCount);
            try {
                for (i = 0; i < arrayCount; ++i) {
                    ArrayInfo info = new ArrayInfo(input, CTX);
                    this.ARRAYS.put(info.getID(), info);
                }
                sum += 4 + this.ARRAYS.values().stream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d array definitions.", i, arrayCount), ex);
            }
            this.PAPYRUS_RUNTIME = input.readInt();
            sum += 4;
            int activeScriptCount = input.readInt();
            this.ACTIVESCRIPTS = new ActiveScriptMap(activeScriptCount);
            try {
                for (i = 0; i < activeScriptCount; ++i) {
                    ActiveScript active = new ActiveScript(input, CTX);
                    this.ACTIVESCRIPTS.put(active.getID(), active);
                }
                sum += 4 + this.ACTIVESCRIPTS.values().stream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d activescript definitions.", i, activeScriptCount), ex);
            }
            try {
                for (i = 0; i < instanceCount; ++i) {
                    data = new ScriptData(input, CTX);
                    ScriptInstance instance = (ScriptInstance)this.INSTANCES.get(((ScriptData)data).getID());
                    instance.setData((ScriptData)data);
                }
                sum += this.INSTANCES.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
            }
            catch (Error | Exception ex) {
                throw new IOException(String.format("Error; read %d/%d instance data blocks.", i, instanceCount), ex);
            }
            try {
                for (i = 0; i < referenceCount; ++i) {
                    data = new ReferenceData(input, CTX);
                    Reference ref = (Reference)this.REFERENCES.get(((ReferenceData)data).getID());
                    ref.setData((ReferenceData)data);
                }
                sum += this.REFERENCES.values().stream().mapToInt(v -> v.getData().calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d reference data blocks.", i, referenceCount), ex);
            }
            try {
                for (i = 0; i < arrayCount; ++i) {
                    data = new ArrayData(input, this.ARRAYS, CTX);
                    ArrayInfo array = (ArrayInfo)this.ARRAYS.get(((ArrayData)data).getID());
                    array.setData((ArrayData)data);
                }
                sum += this.ARRAYS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d array data blocks.", i, arrayCount), ex);
            }
            try {
                for (i = 0; i < activeScriptCount; ++i) {
                    data = new ActiveScriptData(input, this.SCRIPTS, CTX);
                    ActiveScript script = (ActiveScript)this.ACTIVESCRIPTS.get(((ActiveScriptData)data).getID());
                    script.setData((ActiveScriptData)data);
                }
                sum += this.ACTIVESCRIPTS.values().stream().mapToInt(v -> v.getData().calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d activescript data blocks.", i, activeScriptCount), ex);
            }
            int functionMessageCount = input.readInt();
            this.FUNCTIONMESSAGES = new ArrayList<FunctionMessage>(functionMessageCount);
            try {
                for (i = 0; i < functionMessageCount; ++i) {
                    FunctionMessage message = new FunctionMessage(input, this.SCRIPTS, CTX);
                    this.FUNCTIONMESSAGES.add(message);
                }
                sum += 4 + this.FUNCTIONMESSAGES.stream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d functionmessages.", i, functionMessageCount), ex);
            }
            int stack1Count = input.readInt();
            this.SUSPENDEDSTACKS1 = new ArrayList<SuspendedStack>(stack1Count);
            try {
                for (i = 0; i < stack1Count; ++i) {
                    SuspendedStack stack = new SuspendedStack(input, this.SCRIPTS, CTX);
                    this.SUSPENDEDSTACKS1.add(stack);
                }
                sum += 4 + this.SUSPENDEDSTACKS1.stream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d suspended stacks (1).", i, stack1Count), ex);
            }
            int stack2Count = input.readInt();
            this.SUSPENDEDSTACKS2 = new ArrayList<SuspendedStack>(stack2Count);
            try {
                for (i = 0; i < stack2Count; ++i) {
                    SuspendedStack stack = new SuspendedStack(input, this.SCRIPTS, CTX);
                    this.SUSPENDEDSTACKS2.add(stack);
                }
                sum += 4 + this.SUSPENDEDSTACKS2.stream().mapToInt(v -> v.calculateSize()).sum();
            }
            catch (IOException ex) {
                throw new IOException(String.format("Error; read %d/%d suspended stacks (2).", i, stack2Count), ex);
            }
            this.UNK1 = input.readInt();
            this.UNK2 = this.UNK1 == 0 ? 0 : input.readInt();
            sum += this.UNK1 == 0 ? 4 : 8;
            int unknownCount = input.readInt();
            this.UNKS = new ArrayList<EID>(unknownCount);
            if (CTX.GAME.isSSE() || CTX.GAME.isFO4()) {
                for (i = 0; i < unknownCount; ++i) {
                    id = EID.read8byte(input);
                    this.UNKS.add(id);
                }
            } else {
                for (i = 0; i < unknownCount; ++i) {
                    id = EID.read4byte(input);
                    this.UNKS.add(id);
                }
            }
            sum += 4 + this.UNKS.parallelStream().mapToInt(v -> v.calculateSize()).sum();
            int queuedUnbindCount = input.readInt();
            this.UNBINDS = new ArrayList<QueuedUnbind>(queuedUnbindCount);
            for (i = 0; i < queuedUnbindCount; ++i) {
                QueuedUnbind unbind = new QueuedUnbind(input, this.INSTANCES, CTX);
                this.UNBINDS.add(unbind);
            }
            sum += 4 + this.UNBINDS.stream().mapToInt(v -> v.calculateSize()).sum();
            this.SAVE_FILE_VERSION = input.readShort();
            sum += 2;
            int remaining = input.available();
            this.OTHERDATA = new byte[remaining];
            int read = input.read(this.OTHERDATA);
            sum += this.OTHERDATA.length;
            assert (read == remaining);
            assert (sum == this.calculateSize());
            assert (sum == buffer.length);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        output = new LittleEndianDataOutput(output);
        assert (null != output);
        output.writeShort(this.HEADER);
        this.STRINGS.write(output);
        if (null != this.STRUCTS) {
            output.writeInt(this.SCRIPTS.size());
            output.writeInt(this.STRUCTS.size());
            for (Linkable script : this.SCRIPTS.values()) {
                ((Script)script).write(output);
            }
            for (Linkable struct : this.STRUCTDEFS.values()) {
                ((StructDef)struct).write(output);
            }
        } else {
            output.writeInt(this.SCRIPTS.size());
            for (Linkable script : this.SCRIPTS.values()) {
                ((Script)script).write(output);
            }
        }
        output.writeInt(this.INSTANCES.size());
        for (ScriptInstance instance : this.INSTANCES.values()) {
            instance.write(output);
        }
        output.writeInt(this.REFERENCES.size());
        for (Reference ref : this.REFERENCES.values()) {
            ref.write(output);
        }
        if (null != this.STRUCTS) {
            output.writeInt(this.STRUCTS.size());
            for (Linkable struct : this.STRUCTS.values()) {
                ((Struct)struct).write(output);
            }
        }
        output.writeInt(this.ARRAYS.size());
        for (ArrayInfo info : this.ARRAYS.values()) {
            info.write(output);
        }
        output.writeInt(this.PAPYRUS_RUNTIME);
        output.writeInt(this.ACTIVESCRIPTS.size());
        for (Linkable script : this.ACTIVESCRIPTS.values()) {
            ((ActiveScript)script).write(output);
        }
        for (ScriptInstance instance : this.INSTANCES.values()) {
            ScriptData data = instance.getData();
            data.write(output);
        }
        for (Reference ref : this.REFERENCES.values()) {
            ref.getData().write(output);
        }
        for (ArrayInfo info : this.ARRAYS.values()) {
            info.getData().write(output);
        }
        for (Linkable script : this.ACTIVESCRIPTS.values()) {
            ((ActiveScript)script).getData().write(output);
        }
        output.writeInt(this.FUNCTIONMESSAGES.size());
        for (FunctionMessage message : this.FUNCTIONMESSAGES) {
            message.write(output);
        }
        System.out.println(output.getPosition());
        output.writeInt(this.SUSPENDEDSTACKS1.size());
        for (SuspendedStack stack : this.SUSPENDEDSTACKS1) {
            stack.write(output);
        }
        output.writeInt(this.SUSPENDEDSTACKS2.size());
        for (SuspendedStack stack : this.SUSPENDEDSTACKS2) {
            stack.write(output);
        }
        output.writeInt(this.UNK1);
        if (this.UNK1 != 0) {
            output.writeInt(this.UNK2);
        }
        output.writeInt(this.UNKS.size());
        for (EID id : this.UNKS) {
            output.writeESSElement(id);
        }
        output.writeInt(this.UNBINDS.size());
        for (QueuedUnbind unbind : this.UNBINDS) {
            unbind.write(output);
        }
        output.writeShort(this.SAVE_FILE_VERSION);
        output.write(this.OTHERDATA);
    }

    @Override
    public int calculateSize() {
        int sum = 2;
        sum += this.STRINGS.calculateSize();
        sum += 4;
        sum += this.SCRIPTS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        if (null != this.STRUCTS) {
            sum += 4;
            sum += this.STRUCTS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        }
        sum += 4;
        sum += this.INSTANCES.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.REFERENCES.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.ARRAYS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += 4;
        sum += this.ACTIVESCRIPTS.values().parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.INSTANCES.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += this.REFERENCES.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += this.ARRAYS.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += this.ACTIVESCRIPTS.values().parallelStream().mapToInt(v -> v.getData().calculateSize()).sum();
        sum += 4;
        sum += this.FUNCTIONMESSAGES.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.SUSPENDEDSTACKS1.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.SUSPENDEDSTACKS2.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += this.UNK1 == 0 ? 4 : 8;
        sum += 4 + this.UNKS.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 4;
        sum += this.UNBINDS.parallelStream().mapToInt(v -> v.calculateSize()).sum();
        sum += 2;
        return sum += this.OTHERDATA.length;
    }

    public StringTable getStringTable() {
        return this.STRINGS;
    }

    public ScriptMap getScripts() {
        return this.SCRIPTS;
    }

    public List<FunctionMessage> getFunctionMessages() {
        return this.FUNCTIONMESSAGES;
    }

    public InstanceMap getInstances() {
        return this.INSTANCES;
    }

    public ReferenceMap getReferences() {
        return this.REFERENCES;
    }

    public ArrayMap getArrays() {
        return this.ARRAYS;
    }

    public ActiveScriptMap getActiveScripts() {
        return this.ACTIVESCRIPTS;
    }

    public List<SuspendedStack> getSuspendedStacks1() {
        return this.SUSPENDEDSTACKS1;
    }

    public List<SuspendedStack> getSuspendedStacks2() {
        return this.SUSPENDEDSTACKS2;
    }

    public List<QueuedUnbind> getUnbinds() {
        return this.UNBINDS;
    }

    public int cleanUnattachedInstances() {
        List UNATTACHED = this.INSTANCES.values().stream().filter(v -> v.isUnattached()).collect(Collectors.toList());
        this.INSTANCES.values().removeAll(UNATTACHED);
        return UNATTACHED.size();
    }

    public int cleanUndefined() {
        int count = 0;
        count = (int)((long)count + this.SCRIPTS.values().stream().filter(v -> v.isUndefined()).count());
        count = (int)((long)count + this.INSTANCES.values().parallelStream().filter(v -> v.isUndefined()).count());
        count = (int)((long)count + this.ACTIVESCRIPTS.values().stream().filter(v -> v.isUndefined()).count());
        count = (int)((long)count + this.REFERENCES.values().stream().filter(v -> v.isUndefined()).count());
        this.SCRIPTS.values().removeIf(v -> v.isUndefined());
        this.INSTANCES.values().removeIf(v -> v.isUndefined());
        this.REFERENCES.values().removeIf(v -> v.isUndefined());
        this.ACTIVESCRIPTS.values().stream().filter(v -> v.isUndefined()).forEach(v -> v.zero());
        return count;
    }

    private boolean removeScript(Script script, boolean removeAll) {
        Objects.requireNonNull(script);
        if (!this.SCRIPTS.containsKey(script.getName())) {
            return false;
        }
        this.SCRIPTS.remove(script.getName());
        if (removeAll) {
            this.INSTANCES.values().removeIf(v -> v.getScript() == script);
            this.REFERENCES.values().removeIf(v -> v.getScript() == script);
            this.ACTIVESCRIPTS.values().stream().filter(v -> v.hasScript(script)).forEach(v -> v.zero());
        }
        return true;
    }

    public boolean removeElement(PapyrusElement element) {
        Objects.requireNonNull(element);
        if (element instanceof Script) {
            return this.removeScript((Script)element, true);
        }
        if (element instanceof ScriptInstance) {
            ScriptInstance instance = (ScriptInstance)element;
            return null != this.INSTANCES.remove(instance.getID());
        }
        if (element instanceof Reference) {
            Reference ref = (Reference)element;
            return null != this.REFERENCES.remove(ref.getID());
        }
        if (element instanceof ArrayInfo) {
            ArrayInfo array = (ArrayInfo)element;
            return null != this.ARRAYS.remove(array.getID());
        }
        if (element instanceof ActiveScript) {
            ActiveScript active = (ActiveScript)element;
            return null != this.ACTIVESCRIPTS.remove(active.getID());
        }
        return false;
    }

    public String toString() {
        return "Papyrus-" + super.toString();
    }

    @Override
    public void addNames(ESPIDMap names, restringer.esp.StringTable strings) {
        this.INSTANCES.values().forEach(v -> v.addNames(names, strings));
        this.REFERENCES.values().forEach(v -> v.addNames(names, strings));
        this.ACTIVESCRIPTS.values().forEach(v -> v.addNames(names, strings));
        this.ARRAYS.values().forEach(v -> v.addNames(names, strings));
        this.SUSPENDEDSTACKS1.forEach(v -> v.addNames(names, strings));
        this.SUSPENDEDSTACKS2.forEach(v -> v.addNames(names, strings));
        this.FUNCTIONMESSAGES.forEach(v -> v.addNames(names, strings));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.ARRAYS.values().forEach(array -> array.resolveRefs(ess, null));
        this.SCRIPTS.values().forEach(script -> script.resolveRefs(ess, null));
        this.INSTANCES.values().forEach(instance -> instance.resolveRefs(ess, null));
        this.REFERENCES.values().forEach(ref -> ref.resolveRefs(ess, null));
        this.ACTIVESCRIPTS.values().forEach(script -> script.resolveRefs(ess, null));
        this.SUSPENDEDSTACKS1.forEach(stack -> stack.resolveRefs(ess, null));
        this.SUSPENDEDSTACKS2.forEach(stack -> stack.resolveRefs(ess, null));
        this.FUNCTIONMESSAGES.forEach(msg -> msg.resolveRefs(ess, null));
    }

    public PapyrusElement broadSpectrumMatch(EID id) {
        if (this.INSTANCES.containsKey(id)) {
            return (PapyrusElement)this.INSTANCES.get(id);
        }
        if (this.REFERENCES.containsKey(id)) {
            return (PapyrusElement)this.REFERENCES.get(id);
        }
        if (this.ARRAYS.containsKey(id)) {
            return (PapyrusElement)this.ARRAYS.get(id);
        }
        if (this.ACTIVESCRIPTS.containsKey(id)) {
            return (PapyrusElement)this.ACTIVESCRIPTS.get(id);
        }
        Optional<FunctionMessage> msg = this.FUNCTIONMESSAGES.stream().filter(v -> v.getID().equals(id)).findAny();
        if (msg.isPresent()) {
            return msg.get();
        }
        Optional<SuspendedStack> susp1 = this.SUSPENDEDSTACKS1.stream().filter(v -> v.getID().equals(id)).findAny();
        if (susp1.isPresent()) {
            return susp1.get();
        }
        Optional<SuspendedStack> susp2 = this.SUSPENDEDSTACKS1.stream().filter(v -> v.getID().equals(id)).findAny();
        if (susp2.isPresent()) {
            return susp2.get();
        }
        Optional<QueuedUnbind> qu = this.UNBINDS.stream().filter(v -> v.getID().equals(id)).findAny();
        if (qu.isPresent()) {
            return qu.get();
        }
        return null;
    }
}

