/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.StringTable;
import restringer.ess.papyrus.TString;

public final class Parameter
implements PapyrusElement {
    private final Type TYPE;
    private final int DATA;
    private final float FLT_VALUE;
    private final TString STR_VALUE;
    private final String TERM;
    static final Predicate<String> TEMP_PATTERN = Pattern.compile("^::.+$", 2).asPredicate();
    static final Predicate<String> NONE_PATTERN = Pattern.compile("^::NoneVar$", 2).asPredicate();
    static final Predicate<String> AUTOVAR_PATTERN = Pattern.compile("^::(.+)_var$", 2).asPredicate();

    public static Parameter createTerm(String value) {
        return new Parameter(value);
    }

    public Parameter(LittleEndianInput input, StringTable strings) throws IOException {
        assert (null != input);
        assert (null != strings);
        this.TYPE = Type.read(input);
        this.TERM = null;
        switch (this.TYPE) {
            case NULL: {
                this.DATA = 0;
                this.STR_VALUE = null;
                this.FLT_VALUE = 0.0f;
                break;
            }
            case IDENTIFIER: 
            case STRING: {
                this.DATA = 0;
                this.STR_VALUE = strings.read(input);
                this.FLT_VALUE = 0.0f;
                break;
            }
            case INTEGER: {
                this.DATA = input.readInt();
                this.STR_VALUE = null;
                this.FLT_VALUE = 0.0f;
                break;
            }
            case FLOAT: {
                this.DATA = input.readInt();
                this.STR_VALUE = null;
                this.FLT_VALUE = Float.intBitsToFloat(this.DATA);
                break;
            }
            case BOOLEAN: {
                this.DATA = input.readByte();
                this.STR_VALUE = null;
                this.FLT_VALUE = 0.0f;
                break;
            }
            case TERM: {
                throw new IllegalStateException("Terms cannot be read.");
            }
            default: {
                throw new IOException("Illegal Parameter type: " + this.TYPE);
            }
        }
    }

    private Parameter(String value) {
        this.TYPE = Type.TERM;
        this.DATA = 0;
        this.STR_VALUE = null;
        this.FLT_VALUE = 0.0f;
        this.TERM = value;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        this.TYPE.write(output);
        switch (this.TYPE) {
            case NULL: {
                break;
            }
            case IDENTIFIER: 
            case STRING: {
                this.STR_VALUE.write(output);
                break;
            }
            case INTEGER: 
            case FLOAT: {
                output.writeInt(this.DATA);
                break;
            }
            case BOOLEAN: {
                output.writeByte(this.DATA);
                break;
            }
            case TERM: {
                throw new IllegalStateException("Terms cannot be written.");
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    @Override
    public int calculateSize() {
        int sum = this.TYPE.calculateSize();
        switch (this.TYPE) {
            case NULL: {
                break;
            }
            case IDENTIFIER: 
            case STRING: {
                sum += this.STR_VALUE.calculateSize();
                break;
            }
            case INTEGER: 
            case FLOAT: {
                sum += 4;
                break;
            }
            case BOOLEAN: {
                ++sum;
                break;
            }
            case TERM: {
                throw new IllegalStateException("Terms cannot be written.");
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return sum;
    }

    public Type getType() {
        return this.TYPE;
    }

    public int getRefIDValue() {
        assert (this.TYPE == Type.IDENTIFIER);
        return this.DATA;
    }

    public TString getStringValue() {
        assert (this.TYPE == Type.STRING);
        return this.STR_VALUE;
    }

    public int getIntValue() {
        assert (this.TYPE == Type.INTEGER);
        return this.DATA;
    }

    public float getFloatValue() {
        assert (this.TYPE == Type.FLOAT);
        return this.FLT_VALUE;
    }

    public boolean getBooleanValue() {
        assert (this.TYPE == Type.BOOLEAN);
        return this.DATA != 0;
    }

    public boolean isTemp() {
        return this.TYPE == Type.IDENTIFIER && TEMP_PATTERN.test(this.STR_VALUE.toString()) && !AUTOVAR_PATTERN.test(this.STR_VALUE.toString()) && !NONE_PATTERN.test(this.STR_VALUE.toString());
    }

    public boolean isAutovar() {
        return this.TYPE == Type.IDENTIFIER && AUTOVAR_PATTERN.test(this.STR_VALUE.toString());
    }

    public boolean isNonevar() {
        return this.TYPE == Type.IDENTIFIER && NONE_PATTERN.test(this.STR_VALUE.toString());
    }

    @Override
    public void addNames(ESPIDMap names, restringer.esp.StringTable strings) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        if (this.TYPE == Type.STRING) {
            this.STR_VALUE.addRefHolder(owner);
        }
    }

    public String toValueString() {
        switch (this.TYPE) {
            case IDENTIFIER: {
                return this.STR_VALUE.toString();
            }
            case STRING: {
                return this.STR_VALUE.toString().replace("\n", "\\n");
            }
            case INTEGER: {
                return Integer.toString(this.DATA);
            }
            case FLOAT: {
                return Float.toString(this.FLT_VALUE);
            }
            case BOOLEAN: {
                return Boolean.toString(this.DATA != 0);
            }
            case TERM: {
                return this.TERM;
            }
        }
        return "INVALID";
    }

    public String paren() {
        if (this.TYPE == Type.TERM) {
            return "(" + this.toValueString() + ")";
        }
        return this.toValueString();
    }

    public String toString() {
        return this.TYPE + ":" + this.toValueString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.TYPE);
        hash = 41 * hash + this.DATA;
        hash = 41 * hash + Objects.hashCode(this.STR_VALUE);
        hash = 41 * hash + Objects.hashCode(this.TERM);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        return this.TYPE == other.TYPE && this.DATA == other.DATA && Objects.equals(this.TERM, other.TERM);
    }

    public static enum Type implements PapyrusElement
    {
        NULL,
        IDENTIFIER,
        STRING,
        INTEGER,
        FLOAT,
        BOOLEAN,
        TERM;


        public static Type read(LittleEndianInput input) throws IOException {
            Objects.requireNonNull(input);
            int val = input.readUnsignedByte();
            return Type.values()[val];
        }

        @Override
        public void write(LittleEndianDataOutput output) throws IOException {
            output.writeByte(this.ordinal());
        }

        @Override
        public int calculateSize() {
            return 1;
        }

        @Override
        public void addNames(ESPIDMap names, restringer.esp.StringTable strings) {
        }

        @Override
        public void resolveRefs(ESS ess, Element owner) {
        }
    }
}

