/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.EID;
import restringer.ess.papyrus.HasID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;

public final class ScriptData
implements PapyrusElement,
HasID {
    private final EID ID;
    private final byte FLAG;
    private final TString TYPE;
    private final int UNKNOWN1;
    private final int UNKNOWN2;
    private final ArrayList<Variable> MEMBERS = new ArrayList();

    public ScriptData(LittleEndianInput input, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        this.ID = ctx.GAME.isSSE() || ctx.GAME.isFO4() ? EID.read8byte(input) : EID.read4byte(input);
        this.FLAG = input.readByte();
        this.TYPE = ctx.STRINGS.read(input);
        this.UNKNOWN1 = input.readInt();
        this.UNKNOWN2 = (this.FLAG & 4) != 0 ? input.readInt() : 0;
        int memberCount = input.readInt();
        this.MEMBERS.ensureCapacity(memberCount);
        int i = 0;
        try {
            for (i = 0; i < memberCount; ++i) {
                Variable var = Variable.read(input, ctx);
                this.MEMBERS.add(var);
            }
        }
        catch (IOException ex) {
            throw new IOException(String.format("Error; read %d/%d members.", i, memberCount), ex);
        }
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeESSElement(this.ID);
        output.writeByte(this.FLAG);
        output.writeESSElement(this.TYPE);
        output.writeInt(this.UNKNOWN1);
        if ((this.FLAG & 4) != 0) {
            output.writeInt(this.UNKNOWN2);
        }
        output.writeInt(this.MEMBERS.size());
        int i = 0;
        for (Variable var : this.MEMBERS) {
            output.writeESSElement(var);
            ++i;
        }
    }

    @Override
    public int calculateSize() {
        int sum = 9;
        sum += this.ID.calculateSize();
        sum += (this.FLAG & 4) != 0 ? 4 : 0;
        sum += this.TYPE.calculateSize();
        return sum += this.MEMBERS.stream().mapToInt(var -> var.calculateSize()).sum();
    }

    @Override
    public EID getID() {
        return this.ID;
    }

    public TString getType() {
        return this.TYPE;
    }

    public List<Variable> getMembers() {
        return this.MEMBERS;
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        this.MEMBERS.forEach(v -> v.addNames(names, strings));
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        this.MEMBERS.forEach(var -> var.resolveRefs(ess, owner));
        this.TYPE.addRefHolder(owner);
    }

    public String toString() {
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("SCRIPTDATA\n");
        BUILDER.append(String.format("ID = %s\n", this.ID));
        BUILDER.append(String.format("flag= %d\n", this.FLAG));
        BUILDER.append(String.format("type = %s\n", this.TYPE));
        BUILDER.append(String.format("unknown1 = %d\n", this.UNKNOWN1));
        BUILDER.append(String.format("unknown2 = %d\n\n", this.UNKNOWN2));
        this.MEMBERS.forEach(var -> BUILDER.append(String.format("%s\n", var)));
        return BUILDER.toString();
    }
}

