/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.SortedSet;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Plugin;
import restringer.ess.RefID;
import restringer.ess.papyrus.GameElement;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.ScriptData;
import restringer.ess.papyrus.ScriptMap;

public final class ScriptInstance
extends GameElement {
    private final short UNKNOWN2BITS;
    private final short UNKNOWN;
    private final RefID REFID;
    private final byte UNKNOWN_BYTE;
    private ScriptData data;

    public ScriptInstance(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        super(input, scripts, ctx);
        this.UNKNOWN2BITS = input.readShort();
        this.UNKNOWN = input.readShort();
        this.REFID = new RefID(input);
        this.UNKNOWN_BYTE = input.readByte();
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        super.write(output);
        output.writeShort(this.UNKNOWN2BITS);
        output.writeShort(this.UNKNOWN);
        output.writeESSElement(this.REFID);
        output.writeByte(this.UNKNOWN_BYTE);
    }

    @Override
    public int calculateSize() {
        int sum = 5;
        sum += super.calculateSize();
        return sum += this.REFID.calculateSize();
    }

    public RefID getRefID() {
        return this.REFID;
    }

    public ScriptData getData() {
        return this.data;
    }

    public void setData(ScriptData newData) {
        this.data = newData;
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"instance://%s\">%s</a>", this.getID(), this.toString());
    }

    public String toString() {
        if (this.isUndefined() && this.UNKNOWN != -1) {
            return "#" + this.getScriptName() + "#: refid=" + this.REFID + " (" + this.getID() + ")";
        }
        if (this.UNKNOWN != -1) {
            return this.getScriptName() + ": refid=" + this.REFID + " (" + this.getID() + ")";
        }
        if (this.isUndefined()) {
            return "#" + this.getScriptName() + "#: **refid=" + this.REFID + " (" + this.getID() + ")";
        }
        return this.getScriptName() + ": **refid=" + this.REFID + " (" + this.getID() + ")";
    }

    @Override
    public String getInfo(Profile.Analysis analysis, ESS save) {
        boolean mysteryFlag;
        SortedSet<String> PROVIDERS;
        StringBuilder BUILDER = new StringBuilder();
        if (null != this.getScript()) {
            BUILDER.append(String.format("<html><h3>INSTANCE of %s</h3>", this.getScript().toHTML()));
        } else {
            BUILDER.append(String.format("<html><h3>INSTANCE of %s</h3>", this.getScriptName()));
        }
        Plugin PLUGIN = this.REFID.getPlugin();
        if (PLUGIN != null) {
            BUILDER.append(String.format("<p>This instance is attached to an object from %s.</p>", PLUGIN.toHTML()));
        } else if (this.REFID.getType() == RefID.Type.CREATED) {
            BUILDER.append("<p>This instance was created in-game.</p>");
        }
        if (this.isUndefined()) {
            BUILDER.append("<p><em>WARNING: SCRIPT MISSING!</em><br/>Remove Undefined Instances\" will delete this.</p>");
        }
        if (this.isUnattached()) {
            BUILDER.append("<p><em>WARNING: OBJECT MISSING!</em><br/>Selecting \"Remove Unattached Instances\" will delete this.</p>");
        }
        if (this.REFID.getType() == RefID.Type.CREATED && this.REFID.getForm() == null) {
            BUILDER.append("<p><em>WARNING: REFID POINTS TO NONEXISTENT CREATED FORM!</em><br/>Remove non-existent form instances\" will delete this.</p>");
        }
        if (null != analysis && null != (PROVIDERS = analysis.SCRIPT_ORIGINS.get(this.getScriptName()))) {
            String probableProvider = PROVIDERS.last();
            BUILDER.append(String.format("<p>The script probably came from mod \"%s\".</p>", probableProvider));
            if (PROVIDERS.size() > 1) {
                BUILDER.append("<p>Full list of providers:</p><ul>");
                PROVIDERS.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                BUILDER.append("</ul>");
            }
        }
        BUILDER.append(String.format("<p>ID: %s</p>", this.getID()));
        BUILDER.append(String.format("<p>Type: %s</p>", this.data.getType()));
        boolean bl = mysteryFlag = this.UNKNOWN == -1;
        if (save.getChangeForms().containsKey(this.REFID)) {
            BUILDER.append(String.format("<p>RefID%s: %s</p>", mysteryFlag ? "@" : "", this.REFID.toHTML()));
        } else {
            BUILDER.append(String.format("<p>RefID%s: %s</p>", mysteryFlag ? "@" : "", this.REFID.toString()));
        }
        BUILDER.append(String.format("<p>Unknown2bits: %01X</p>", this.UNKNOWN2BITS));
        BUILDER.append(String.format("<p>UnknownShort: %04X</p>", this.UNKNOWN));
        BUILDER.append(String.format("<p>UnknownByte: %02x</p>", this.UNKNOWN_BYTE));
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        assert (null != this.data);
        this.data.addNames(names, strings);
        this.REFID.addName(names, strings);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        super.resolveRefs(ess, owner);
        this.data.resolveRefs(ess, this);
        this.REFID.resolveRefs(ess, this);
    }

    public boolean isUnattached() {
        return this.REFID.equals(RefID.NONE);
    }
}

