/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.SortedSet;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.Profile;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.papyrus.GameElement;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.ReferenceData;
import restringer.ess.papyrus.ScriptMap;

public class Struct
extends GameElement {
    private ReferenceData data;
    private String cachedToString = null;

    public Struct(LittleEndianInput input, ScriptMap scripts, PapyrusContext ctx) throws IOException {
        super(input, scripts, ctx);
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        super.write(output);
    }

    @Override
    public int calculateSize() {
        return super.calculateSize();
    }

    public ReferenceData getData() {
        return this.data;
    }

    public void setData(ReferenceData newData) {
        this.data = newData;
    }

    @Override
    public String toHTML() {
        return String.format("<a href=\"struct://%08x\">%s</a>", this.getID(), this.toString());
    }

    public String toString() {
        if (null != this.cachedToString) {
            return this.cachedToString;
        }
        this.cachedToString = this.isUndefined() ? "#" + this.getScript().getName() + "# (" + this.getID() + ")" : this.getScript().getName() + " (" + this.getID() + ")";
        return this.cachedToString;
    }

    @Override
    public String getInfo(Profile.Analysis analysis, ESS save) {
        Element UNKNOWN2;
        SortedSet<String> providers;
        StringBuilder BUILDER = new StringBuilder();
        if (null != this.getScript()) {
            BUILDER.append(String.format("<html><h3>STRUCT-INSTANCE of %s</h3>", this.getScript().toHTML()));
        } else {
            BUILDER.append(String.format("<html><h3>STRUCT-INSTANCE of %s</h3>", this.getScriptName()));
        }
        if (null != analysis && null != (providers = analysis.SCRIPT_ORIGINS.get(this.getScriptName()))) {
            String probablyProvider = providers.last();
            BUILDER.append(String.format("<p>This struct probably came from \"%s\".</p>", probablyProvider));
            if (providers.size() > 1) {
                BUILDER.append("<p>Full list of providers:</p><ul>");
                providers.forEach(mod -> BUILDER.append(String.format("<li>%s", mod)));
                BUILDER.append("</ul>");
            }
        }
        BUILDER.append(String.format("<p>ID: %s</p>", this.getID()));
        BUILDER.append(String.format("<p>Type2: %s</p>", this.data.getType()));
        BUILDER.append(String.format("<p>Unknown1: %08x</p>", this.data.getUnknown1()));
        BUILDER.append(String.format("<p>Unknown2: %08x</p>", this.data.getUnknown2()));
        Element UNKNOWN1 = save.broadSpectrumMatch(this.getData().getUnknown1());
        if (null != UNKNOWN1) {
            BUILDER.append("<p>Potential match for unknown1 found using general search:<br/>");
            if (UNKNOWN1 instanceof Linkable) {
                BUILDER.append(((Linkable)((Object)UNKNOWN1)).toHTML());
            } else {
                BUILDER.append(UNKNOWN1.toString());
            }
            BUILDER.append("</p>");
        }
        if (null != (UNKNOWN2 = save.broadSpectrumMatch(this.getData().getUnknown2()))) {
            BUILDER.append("<p>Potential match for unknown2 found using general search:<br/>");
            if (UNKNOWN2 instanceof Linkable) {
                BUILDER.append(((Linkable)((Object)UNKNOWN2)).toHTML());
            } else {
                BUILDER.append(UNKNOWN2.toString());
            }
            BUILDER.append("</p>");
        }
        BUILDER.append("</html>");
        return BUILDER.toString();
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        assert (null != this.data);
        this.data.addNames(names, strings);
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        super.resolveRefs(ess, owner);
        this.data.resolveRefs(ess, this);
    }
}

