/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.papyrus.PapyrusElement;

public enum Type implements PapyrusElement
{
    NULL(0),
    REF(1),
    STRING(2),
    INTEGER(3),
    FLOAT(4),
    BOOLEAN(5),
    REF_ARRAY(11),
    STRING_ARRAY(12),
    INTEGER_ARRAY(13),
    FLOAT_ARRAY(14),
    BOOLEAN_ARRAY(15);

    public final int CODE;
    private static final Type[] VALUES;

    static Type read(LittleEndianInput input) throws IOException {
        Objects.requireNonNull(input);
        int val = input.readUnsignedByte();
        Type t = Type.match(val);
        if (null != t) {
            return t;
        }
        throw new IOException("Invalid type value: " + val);
    }

    static Type match(int val) throws IOException {
        for (Type t : VALUES) {
            if (t.CODE != val) continue;
            return t;
        }
        return null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        Objects.requireNonNull(output);
        output.writeByte(this.CODE);
    }

    @Override
    public int calculateSize() {
        return 1;
    }

    public boolean isArray() {
        return this.CODE >= 10;
    }

    private Type(int code) {
        this.CODE = code;
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
    }

    static {
        VALUES = Type.values();
    }
}

