/*
 * Decompiled with CFR 0.152.
 */
package restringer.ess.papyrus;

import java.io.IOException;
import java.util.Objects;
import restringer.LittleEndianDataOutput;
import restringer.LittleEndianInput;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Linkable;
import restringer.ess.RefID;
import restringer.ess.papyrus.PapyrusContext;
import restringer.ess.papyrus.PapyrusElement;
import restringer.ess.papyrus.TString;
import restringer.ess.papyrus.Variable;

public final class Unknown4
implements PapyrusElement,
Linkable {
    private final String STRING;
    private final Variable VARIABLE;
    private final RefID REFID;
    private final byte BYTE;
    private final int INT;
    private final TString TSTRING;
    private final short UNKNOWN_SHORT;

    public Unknown4(LittleEndianInput input, byte unknown3, PapyrusContext ctx) throws IOException {
        Objects.requireNonNull(input);
        Objects.requireNonNull(ctx);
        assert (1 <= unknown3 && unknown3 <= 3);
        if (unknown3 == 2) {
            this.VARIABLE = Variable.read(input, ctx);
            this.STRING = null;
            this.REFID = null;
            this.TSTRING = null;
            this.UNKNOWN_SHORT = 0;
            this.BYTE = 0;
            this.INT = 0;
            return;
        }
        switch (this.STRING = input.readLString()) {
            case "QuestStage": {
                this.REFID = new RefID(input);
                this.TSTRING = null;
                this.UNKNOWN_SHORT = input.readShort();
                this.BYTE = input.readByte();
                this.INT = 0;
                break;
            }
            case "ScenePhaseResults": {
                this.REFID = new RefID(input);
                this.TSTRING = null;
                this.UNKNOWN_SHORT = 0;
                this.BYTE = 0;
                this.INT = input.readInt();
                break;
            }
            case "SceneActionResults": {
                this.REFID = new RefID(input);
                this.TSTRING = null;
                this.UNKNOWN_SHORT = 0;
                this.BYTE = 0;
                this.INT = input.readInt();
                break;
            }
            case "SceneResults": {
                this.REFID = new RefID(input);
                this.TSTRING = null;
                this.UNKNOWN_SHORT = 0;
                this.BYTE = 0;
                this.INT = 0;
                break;
            }
            default: {
                this.REFID = null;
                this.TSTRING = null;
                this.UNKNOWN_SHORT = 0;
                this.BYTE = 0;
                this.INT = 0;
            }
        }
        this.VARIABLE = unknown3 == 3 ? Variable.read(input, ctx) : null;
    }

    @Override
    public void write(LittleEndianDataOutput output) throws IOException {
        assert (null != output);
        assert (null != this.STRING || null != this.VARIABLE);
        if (null == this.STRING) {
            this.VARIABLE.write(output);
            return;
        }
        output.writeLString(this.STRING);
        switch (this.STRING) {
            case "QuestStage": {
                this.REFID.write(output);
                output.writeShort(this.UNKNOWN_SHORT);
                output.writeByte(this.BYTE);
                break;
            }
            case "ScenePhaseResults": {
                this.REFID.write(output);
                output.writeInt(this.INT);
                break;
            }
            case "SceneActionResults": {
                this.REFID.write(output);
                output.writeInt(this.INT);
                break;
            }
            case "SceneResults": {
                this.REFID.write(output);
                break;
            }
        }
        if (null != this.VARIABLE) {
            this.VARIABLE.write(output);
        }
    }

    @Override
    public int calculateSize() {
        assert (null != this.STRING || null != this.VARIABLE);
        if (null == this.STRING) {
            return this.VARIABLE.calculateSize();
        }
        int sum = 4 + this.STRING.length();
        switch (this.STRING) {
            case "QuestStage": {
                sum += this.REFID.calculateSize();
                sum += 2;
                ++sum;
                break;
            }
            case "ScenePhaseResults": {
                sum += this.REFID.calculateSize();
                sum += 4;
                break;
            }
            case "SceneActionResults": {
                sum += this.REFID.calculateSize();
                sum += 4;
                break;
            }
            case "SceneResults": {
                sum += this.REFID.calculateSize();
                break;
            }
        }
        if (null != this.VARIABLE) {
            sum += this.VARIABLE.calculateSize();
        }
        return sum;
    }

    @Override
    public void addNames(ESPIDMap names, StringTable strings) {
        if (null != this.VARIABLE) {
            this.VARIABLE.addNames(names, strings);
        }
        if (null != this.REFID) {
            this.REFID.addName(names, strings);
        }
    }

    @Override
    public void resolveRefs(ESS ess, Element owner) {
        if (null != this.VARIABLE) {
            this.VARIABLE.resolveRefs(ess, owner);
        }
        if (null != this.REFID) {
            this.REFID.resolveRefs(ess, owner);
        }
        if (null != this.TSTRING) {
            this.TSTRING.addRefHolder(owner);
        }
    }

    @Override
    public String toHTML() {
        assert (null != this.STRING || null != this.VARIABLE);
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("UNK4");
        if (null == this.STRING) {
            BUILDER.append(": ").append(this.VARIABLE);
        }
        BUILDER.append("(").append(this.STRING).append("): ");
        switch (this.STRING) {
            case "QuestStage": {
                BUILDER.append(this.REFID.toHTML()).append(" ");
                BUILDER.append(this.TSTRING).append(" ");
                break;
            }
            case "ScenePhaseResults": {
                BUILDER.append(this.REFID.toHTML());
                break;
            }
            case "SceneActionResults": {
                BUILDER.append(this.REFID.toHTML());
                break;
            }
            case "SceneResults": {
                BUILDER.append(this.REFID.toHTML());
                break;
            }
        }
        if (null != this.VARIABLE) {
            BUILDER.append("(").append(this.VARIABLE.toHTML()).append(")");
        }
        return BUILDER.toString();
    }

    public String toString() {
        assert (null != this.STRING || null != this.VARIABLE);
        StringBuilder BUILDER = new StringBuilder();
        BUILDER.append("UNK4");
        if (null == this.STRING) {
            BUILDER.append(": ").append(this.VARIABLE);
        }
        BUILDER.append("(").append(this.STRING).append("): ");
        switch (this.STRING) {
            case "QuestStage": {
                BUILDER.append(this.REFID).append(" ");
                BUILDER.append(this.TSTRING).append(" ");
                break;
            }
            case "ScenePhaseResults": {
                BUILDER.append(this.REFID);
                break;
            }
            case "SceneActionResults": {
                BUILDER.append(this.REFID);
                break;
            }
            case "SceneResults": {
                BUILDER.append(this.REFID);
                break;
            }
        }
        if (null != this.VARIABLE) {
            BUILDER.append("(").append(this.VARIABLE).append(")");
        }
        return BUILDER.toString();
    }
}

