/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import restringer.Mod;
import restringer.Profile;
import restringer.ess.AnalyzableElement;
import restringer.ess.ChangeForm;
import restringer.ess.ChangeFormFLST;
import restringer.ess.Element;
import restringer.ess.Plugin;
import restringer.ess.PluginInfo;
import restringer.ess.RefID;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.FunctionMessage;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.SuspendedStack;
import restringer.gui.FilterTreeModel;

public class FilterMaker {
    private static final Logger LOG = Logger.getLogger(FilterMaker.class.getCanonicalName());

    public static Predicate<FilterTreeModel.Node> createModFilter(Mod mod, PluginInfo plugins, Profile.Analysis analysis) {
        Objects.requireNonNull(mod);
        Objects.requireNonNull(analysis);
        LOG.info(String.format("Filtering: mod = \"%s\"", mod));
        String MODNAME = mod.getName();
        HashSet PLUGINS = new HashSet();
        mod.getESPNames().stream().forEach(espName -> plugins.getPlugins().stream().filter(p -> p.NAME.equalsIgnoreCase((String)espName)).findAny().ifPresent(p -> PLUGINS.add(p)));
        Predicate<FilterTreeModel.Node> filter = node -> {
            if (node.hasElement() && node.getElement() instanceof AnalyzableElement) {
                AnalyzableElement elem = (AnalyzableElement)node.getElement();
                return elem.matches(analysis, MODNAME);
            }
            return false;
        };
        for (Plugin plugin : PLUGINS) {
            filter = filter.or(FilterMaker.createPluginFilter(plugin));
        }
        return filter;
    }

    public static Predicate<FilterTreeModel.Node> createPluginFilter(Plugin plugin) {
        Objects.requireNonNull(plugin);
        LOG.info(String.format("Filtering: plugin = \"%s\"", plugin));
        return node -> {
            if (!node.hasElement()) {
                return false;
            }
            if (node.getElement() instanceof Plugin) {
                Plugin otherPlugin = (Plugin)node.getElement();
                return otherPlugin.equals(plugin);
            }
            if (node.getElement() instanceof ScriptInstance) {
                ScriptInstance instance = (ScriptInstance)node.getElement();
                RefID refID = instance.getRefID();
                return refID == null ? false : refID.getPlugin() == plugin;
            }
            if (node.getElement() instanceof ChangeForm) {
                ChangeForm form = (ChangeForm)node.getElement();
                RefID refID = form.getRefID();
                return refID == null ? false : refID.getPlugin() == plugin;
            }
            return false;
        };
    }

    public static Predicate<FilterTreeModel.Node> createRegexFilter(String regex) {
        Objects.requireNonNull(regex);
        LOG.info(String.format("Filtering: regex = \"%s\"", regex));
        if (!regex.isEmpty()) {
            try {
                LOG.info(String.format("Filtering: regex = \"%s\"", regex));
                Pattern pattern = Pattern.compile(regex, 2);
                return node -> pattern.matcher(node.getName()).find();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        return node -> true;
    }

    public static Predicate<FilterTreeModel.Node> createUndefinedFilter() {
        return node -> {
            if (node.hasElement()) {
                Element e = node.getElement();
                if (e instanceof Script) {
                    return ((Script)e).isUndefined();
                }
                if (e instanceof ScriptInstance) {
                    return ((ScriptInstance)e).isUndefined();
                }
                if (e instanceof Reference) {
                    return ((Reference)e).isUndefined();
                }
                if (e instanceof ActiveScript) {
                    return ((ActiveScript)e).isUndefined();
                }
                if (e instanceof FunctionMessage) {
                    return ((FunctionMessage)e).isUndefined();
                }
                if (e instanceof StackFrame) {
                    return ((StackFrame)e).isUndefined();
                }
                if (e instanceof SuspendedStack) {
                    return ((SuspendedStack)e).isUndefined();
                }
            }
            return false;
        };
    }

    public static Predicate<FilterTreeModel.Node> createUnattachedFilter() {
        return node -> {
            if (node.hasElement() && node.getElement() instanceof ScriptInstance) {
                return ((ScriptInstance)node.getElement()).isUnattached();
            }
            return false;
        };
    }

    public static Predicate<FilterTreeModel.Node> createNullRefFilter() {
        return node -> {
            ChangeForm form;
            if (node.hasElement() && node.getElement() instanceof ChangeForm && (form = (ChangeForm)node.getElement()).getType() == ChangeForm.Type.FLST) {
                return ((ChangeFormFLST)form.getData()).containsNullrefs();
            }
            return false;
        };
    }

    public static Predicate<FilterTreeModel.Node> createNonExistentFilter() {
        return node -> {
            if (node.hasElement() && node.getElement() instanceof ScriptInstance) {
                ScriptInstance instance = (ScriptInstance)node.getElement();
                RefID refID = instance.getRefID();
                return refID.getType() == RefID.Type.CREATED && refID.getForm() == null;
            }
            return false;
        };
    }

    public static Predicate<FilterTreeModel.Node> createFilter(Mod mod, Plugin plugin, String regex, PluginInfo plugins, Profile.Analysis analysis, boolean undefined, boolean unattached, boolean nullrefs, boolean nonexistent) {
        LOG.info("Updating filter.");
        ArrayList FILTERS = new ArrayList(4);
        ArrayList<Predicate<FilterTreeModel.Node>> SUBFILTERS = new ArrayList<Predicate<FilterTreeModel.Node>>(4);
        if (null != mod && null != analysis && null != plugins) {
            FILTERS.add(FilterMaker.createModFilter(mod, plugins, analysis));
        }
        if (null != plugin) {
            FILTERS.add(FilterMaker.createPluginFilter(plugin));
        }
        if (!regex.isEmpty()) {
            FILTERS.add(FilterMaker.createRegexFilter(regex));
        }
        if (undefined) {
            SUBFILTERS.add(FilterMaker.createUndefinedFilter());
        }
        if (unattached) {
            SUBFILTERS.add(FilterMaker.createUnattachedFilter());
        }
        if (nullrefs) {
            SUBFILTERS.add(FilterMaker.createNullRefFilter());
        }
        if (nonexistent) {
            SUBFILTERS.add(FilterMaker.createNonExistentFilter());
        }
        Predicate subfilter = null;
        for (Predicate predicate : SUBFILTERS) {
            subfilter = null == subfilter ? predicate : subfilter.or(predicate);
        }
        if (null != subfilter) {
            FILTERS.add(subfilter);
        }
        Predicate mainfilter = null;
        for (Predicate f : FILTERS) {
            mainfilter = null == mainfilter ? f : mainfilter.and(f);
        }
        return mainfilter;
    }
}

