/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreePath;
import restringer.ess.ChangeForm;
import restringer.ess.ChangeFormFLST;
import restringer.ess.ESS;
import restringer.ess.Element;
import restringer.ess.Plugin;
import restringer.ess.papyrus.ActiveScript;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.Variable;
import restringer.gui.FilterTreeModel;

public final class FilterTree
extends JTree {
    private final JMenuItem MI_DELETE = new JMenuItem(RES.getString("TREE DELETE MENU"), 68);
    private final JMenuItem MI_FILTER = new JMenuItem(RES.getString("TREE PLUGIN FILTER"), 70);
    private final JMenuItem MI_DELETE_FORMS = new JMenuItem(RES.getString("TREE DELETE FORMS"), 67);
    private final JMenuItem MI_DELETE_INSTANCES = new JMenuItem(RES.getString("TREE DELETE INSTANCES"), 83);
    private final JMenuItem MI_ZERO_THREAD = new JMenuItem(RES.getString("TREE ZERO THREAD"), 90);
    private final JMenuItem MI_FIND_OWNER = new JMenuItem(RES.getString("TREE GOTO OWNER"), 70);
    private final JMenuItem MI_CLEANSE_FLST = new JMenuItem(RES.getString("TREE_CLEANSE_FLST"), 67);
    private final JPopupMenu TREE_POPUP_MENU = new JPopupMenu();
    private final JPopupMenu PLUGIN_POPUP_MENU = new JPopupMenu();
    private Consumer<Map<Element, FilterTreeModel.Node>> deleteHandler = null;
    private Consumer<List<ActiveScript>> zeroThreadHandler;
    private Consumer<Plugin> pluginFilterHandler;
    private Consumer<Plugin> deleteFormsHandler = null;
    private Consumer<Plugin> deleteInstancesHandler = null;
    private Consumer<Element> findHandler;
    private Consumer<ChangeFormFLST> cleanFLSTHandler;
    private static final ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/General");

    public FilterTree() {
        super(new FilterTreeModel());
        this.initComponents();
    }

    private void initComponents() {
        this.setLargeModel(true);
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.TREE_POPUP_MENU.add(this.MI_DELETE);
        this.TREE_POPUP_MENU.add(this.MI_ZERO_THREAD);
        this.TREE_POPUP_MENU.add(this.MI_FIND_OWNER);
        this.TREE_POPUP_MENU.add(this.MI_CLEANSE_FLST);
        this.PLUGIN_POPUP_MENU.add(this.MI_FILTER);
        this.PLUGIN_POPUP_MENU.add(this.MI_DELETE_FORMS);
        this.PLUGIN_POPUP_MENU.add(this.MI_DELETE_INSTANCES);
        this.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleteSelected");
        this.getActionMap().put("deleteSelected", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FilterTree.this.deleteNode();
            }
        });
        this.MI_DELETE.addActionListener(e -> this.deleteNode());
        this.MI_FILTER.addActionListener(e -> {
            Plugin plugin = (Plugin)((FilterTreeModel.Node)this.getSelectionPath().getLastPathComponent()).getElement();
            this.filter(plugin);
        });
        this.MI_DELETE_FORMS.addActionListener(e -> {
            Plugin plugin = (Plugin)((FilterTreeModel.Node)this.getSelectionPath().getLastPathComponent()).getElement();
            if (null != this.deleteFormsHandler) {
                this.deleteFormsHandler.accept(plugin);
            }
        });
        this.MI_DELETE_INSTANCES.addActionListener(e -> {
            Plugin plugin = (Plugin)((FilterTreeModel.Node)this.getSelectionPath().getLastPathComponent()).getElement();
            if (null != this.deleteInstancesHandler) {
                this.deleteInstancesHandler.accept(plugin);
            }
        });
        this.MI_ZERO_THREAD.addActionListener(e -> {
            if (null != this.zeroThreadHandler) {
                TreePath[] PATHS = this.getSelectionPaths();
                if (null == PATHS || PATHS.length == 0) {
                    return;
                }
                Map<Element, FilterTreeModel.Node> ELEMENTS = this.getModel().parsePaths(PATHS);
                List THREADS = ELEMENTS.keySet().stream().filter(ESS.THREAD).map(v -> (ActiveScript)v).collect(Collectors.toList());
                this.zeroThreadHandler.accept(THREADS);
            }
        });
        this.MI_FIND_OWNER.addActionListener(e -> {
            Element element = ((FilterTreeModel.Node)this.getSelectionPath().getLastPathComponent()).getElement();
            if (null != this.findHandler) {
                ArrayInfo array;
                if (element instanceof ActiveScript) {
                    ActiveScript script = (ActiveScript)element;
                    if (null != script.getInstance()) {
                        this.findHandler.accept(script.getInstance());
                    }
                } else if (element instanceof StackFrame) {
                    StackFrame frame = (StackFrame)element;
                    Variable owner = frame.getOwner();
                    if (null != owner && owner instanceof Variable.RefID) {
                        Variable.RefID ref = (Variable.RefID)frame.getOwner();
                        this.findHandler.accept(ref.getReferent());
                    }
                } else if (element instanceof ArrayInfo && null != (array = (ArrayInfo)element).getHolder()) {
                    this.findHandler.accept(array.getHolder());
                }
            }
        });
        this.MI_CLEANSE_FLST.addActionListener(e -> {
            ChangeForm form = (ChangeForm)((FilterTreeModel.Node)this.getSelectionPath().getLastPathComponent()).getElement();
            ChangeFormFLST flst = (ChangeFormFLST)form.getData();
            if (null != this.cleanFLSTHandler) {
                this.cleanFLSTHandler.accept(flst);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    Map<Element, FilterTreeModel.Node> ELEMENTS;
                    int x = evt.getPoint().x;
                    int y = evt.getPoint().y;
                    TreePath path = FilterTree.this.getClosestPathForLocation(x, y);
                    TreePath[] paths = FilterTree.this.getSelectionPaths();
                    if (!Arrays.asList(paths).contains(path)) {
                        FilterTree.this.setSelectionPath(path);
                        paths = FilterTree.this.getSelectionPaths();
                    }
                    if ((ELEMENTS = FilterTree.this.getModel().parsePaths(paths)).size() == 1) {
                        Element ELEMENT = ELEMENTS.keySet().iterator().next();
                        if (ELEMENT instanceof Plugin) {
                            FilterTree.this.PLUGIN_POPUP_MENU.show(evt.getComponent(), evt.getX(), evt.getY());
                        } else if (ESS.DELETABLE.test(ELEMENT) || ESS.THREAD.test(ELEMENT) || ESS.OWNABLE.test(ELEMENT)) {
                            FilterTree.this.MI_DELETE.setText(RES.getString("TREE DELETE ELEMENT"));
                            FilterTree.this.MI_DELETE.setVisible(ESS.DELETABLE.test(ELEMENT));
                            FilterTree.this.MI_ZERO_THREAD.setVisible(ESS.THREAD.test(ELEMENT));
                            FilterTree.this.MI_FIND_OWNER.setVisible(ESS.OWNABLE.test(ELEMENT));
                            FilterTree.this.MI_CLEANSE_FLST.setVisible(ELEMENT instanceof ChangeForm && ((ChangeForm)ELEMENT).getData() instanceof ChangeFormFLST);
                            FilterTree.this.TREE_POPUP_MENU.show(evt.getComponent(), evt.getX(), evt.getY());
                        }
                    } else if (ELEMENTS.size() > 1) {
                        boolean deletable = ELEMENTS.keySet().stream().allMatch(ESS.DELETABLE);
                        if (!deletable) {
                            return;
                        }
                        FilterTree.this.MI_FIND_OWNER.setVisible(false);
                        FilterTree.this.MI_DELETE.setEnabled(true);
                        FilterTree.this.MI_DELETE.setText(String.format(RES.getString("TREE DELETE ELEMENTS"), ELEMENTS.size()));
                        boolean threads = ELEMENTS.keySet().stream().allMatch(ESS.THREAD);
                        FilterTree.this.MI_ZERO_THREAD.setVisible(threads);
                        FilterTree.this.TREE_POPUP_MENU.show(evt.getComponent(), evt.getX(), evt.getY());
                    }
                }
            }
        });
    }

    public void clearESS() {
        this.setModel(new FilterTreeModel());
    }

    public void setESS(ESS newSave, Predicate<FilterTreeModel.Node> filter) {
        Objects.requireNonNull(newSave);
        FilterTreeModel MODEL = newSave.createTreeModel();
        if (null != filter) {
            MODEL.filter(filter);
        }
        this.setModel(MODEL);
    }

    public TreePath findPath(Element element) {
        TreePath path = this.getModel().findPath(element);
        return path;
    }

    public void filter(Plugin plugin) {
        if (null != this.pluginFilterHandler) {
            this.pluginFilterHandler.accept(plugin);
        }
    }

    public void setDeleteHandler(Consumer<Map<Element, FilterTreeModel.Node>> newHandler) {
        this.deleteHandler = newHandler;
    }

    public void setFilterPluginsHandler(Consumer<Plugin> newHandler) {
        this.pluginFilterHandler = newHandler;
    }

    public void setDeleteFormsHandler(Consumer<Plugin> newHandler) {
        this.deleteFormsHandler = newHandler;
    }

    public void setDeleteInstancesHandler(Consumer<Plugin> newHandler) {
        this.deleteInstancesHandler = newHandler;
    }

    public void setZeroThreadHandler(Consumer<List<ActiveScript>> newHandler) {
        this.zeroThreadHandler = newHandler;
    }

    public void setFindHandler(Consumer<Element> newHandler) {
        this.findHandler = newHandler;
    }

    public void setCleanseFLSTHandler(Consumer<ChangeFormFLST> newHandler) {
        this.cleanFLSTHandler = newHandler;
    }

    private void deleteNode() {
        if (null == this.deleteHandler) {
            return;
        }
        TreePath[] PATHS = this.getSelectionPaths();
        if (null == PATHS || PATHS.length == 0) {
            return;
        }
        Map<Element, FilterTreeModel.Node> ELEMENTS = this.getModel().parsePaths(PATHS);
        this.deleteHandler.accept(ELEMENTS);
    }

    @Override
    public FilterTreeModel getModel() {
        return (FilterTreeModel)super.getModel();
    }
}

