/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.Font;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JLabel;

public class MemoryLabel
extends JLabel {
    private final Timer MEMTIMER = new Timer();

    public MemoryLabel() {
        super.setFont(new Font("Monospaced", 0, 12));
    }

    public void initialize() {
        this.MEMTIMER.schedule(new TimerTask(){

            @Override
            public void run() {
                MemoryLabel.this.update();
            }
        }, 0L, 500L);
    }

    public void terminate() {
        this.MEMTIMER.cancel();
        this.MEMTIMER.purge();
    }

    public void update() {
        String model = System.getProperty("sun.arch.data.model");
        long free = Runtime.getRuntime().freeMemory() / 0x100000L;
        long total = Runtime.getRuntime().totalMemory() / 0x100000L;
        long used = total - free;
        int pct = (int)(100L * free / total);
        long max = Runtime.getRuntime().maxMemory() / 0x100000L;
        String txt = String.format("Java %s bit: using %d/%d mb RAM (%d%%), %dmb max", model, free, total, pct, max);
        this.setText(txt);
    }
}

