/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import restringer.ess.ESS;
import restringer.gui.Configurator;
import restringer.gui.ProgressIndicator;
import restringer.gui.ProgressModel;
import restringer.gui.SaveWindow;

public class Opener
extends SwingWorker<ESS, Double> {
    private final File SAVEFILE;
    private final SaveWindow WINDOW;
    private static final Logger LOG = Logger.getLogger(Opener.class.getCanonicalName());
    private final WindowAdapter LISTENER = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (!Opener.this.isDone()) {
                Opener.this.cancel(true);
            }
        }
    };

    public Opener(SaveWindow window, File saveFile) {
        this.WINDOW = Objects.requireNonNull(window, "The window field must not be null.");
        this.SAVEFILE = Objects.requireNonNull(saveFile, "The saveFile field must not be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ESS doInBackground() throws Exception {
        if (!Configurator.validateSavegame(this.SAVEFILE)) {
            return null;
        }
        ProgressModel MODEL = new ProgressModel();
        ProgressIndicator.startWaitCursor(this.WINDOW.getRootPane());
        this.WINDOW.addWindowListener(this.LISTENER);
        this.WINDOW.startProgressBar(MODEL);
        this.WINDOW.clearESS();
        try {
            LOG.info("================");
            LOG.info(String.format("Reading from savegame file \"%s\".", this.SAVEFILE));
            ESS newSave = ESS.readESS(this.SAVEFILE, MODEL);
            this.WINDOW.setESS(this.SAVEFILE, newSave);
            if (newSave.getPapyrus().getStringTable().isSTBCorrection()) {
                JOptionPane.showMessageDialog(this.WINDOW, "THIS FILE HAS THE STRING-TABLE-BUG.\nIt is corrupted and can never be recovered, not even with lasers or cheetah blood.\nSaving is disabled.", "Save Read", 0);
            } else {
                JOptionPane.showMessageDialog(this.WINDOW, "The savefile was successfully read.", "Save Read", 1);
            }
            ESS eSS = newSave;
            return eSS;
        }
        catch (IOException ex) {
            String MSG = String.format("Error while reading file \"%s\".\n%s", this.SAVEFILE.getName(), ex.getMessage());
            LOG.severe(MSG);
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Read Error", 0);
            ESS eSS = null;
            return eSS;
        }
        catch (Error | Exception ex) {
            String MSG = String.format("Error while reading file \"%s\".\n%s", this.SAVEFILE.getName(), ex.getMessage());
            LOG.severe(MSG);
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Read Error", 0);
            ESS eSS = null;
            return eSS;
        }
        finally {
            this.WINDOW.removeWindowListener(this.LISTENER);
            ProgressIndicator.stopWaitCursor(this.WINDOW.getRootPane());
            this.WINDOW.clearProgressBar();
        }
    }
}

