/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.Font;
import java.io.File;
import javax.swing.JTextArea;
import restringer.Mod;
import restringer.Profile;

public class ProfileInfoPanel
extends JTextArea {
    private Profile profile = null;

    public ProfileInfoPanel() {
        Font font = new Font("Monospaced", 0, 12);
        super.setFont(font);
    }

    public void setProfile(Profile newProfile) {
        this.profile = newProfile;
        this.update();
    }

    public synchronized void update() {
        this.setText("");
        if (null == this.profile) {
            return;
        }
        Mod.Analysis analysis = this.profile.getFastAnalysis();
        String time = this.profile.getBuildTime() == null ? "never" : this.profile.getBuildTime().toString();
        File path = this.profile.getOutputDirectory();
        this.append(String.format("Last time processed  : %s\n", time));
        this.append(String.format("Output directory     : %s\n", path == null ? "(not set)" : path.getPath()));
        this.append(String.format("Mods included        : %d / %d\n", this.profile.getCheckmarkedMods().size(), this.profile.getMods().size()));
        this.append(String.format("Total scripts        : %d scripts\n", analysis.NUMSCRIPTS));
        this.append(String.format("Total readable data  : %1.1f mb\n", (double)analysis.NUMBYTES / 1048576.0));
        this.append(String.format("Remappable variables : %d strings\n", analysis.NUMSTRINGS));
    }
}

