/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoundedRangeModel;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.RootPaneContainer;

public final class ProgressIndicator
extends JPanel {
    private static final MouseAdapter NULLMOUSEADAPTER = new MouseAdapter(){};
    private final JPanel TOPPANEL;
    private final JPanel BOTTOMPANEL;
    private final JLabel LABEL;
    private final JProgressBar BAR;

    public ProgressIndicator(Frame owner) {
        super.setLayout(new BoxLayout(this, 3));
        super.setBackground(new Color(0, 0, 0, 128));
        super.setBorder(BorderFactory.createEtchedBorder());
        this.TOPPANEL = new JPanel();
        this.TOPPANEL.setBackground(Color.BLUE);
        this.TOPPANEL.setAlignmentX(0.5f);
        this.TOPPANEL.setAlignmentY(0.5f);
        this.TOPPANEL.setMaximumSize(new Dimension(200, 30));
        this.BOTTOMPANEL = new JPanel();
        this.BOTTOMPANEL.setAlignmentX(0.5f);
        this.BOTTOMPANEL.setAlignmentY(0.5f);
        this.BOTTOMPANEL.setMaximumSize(new Dimension(200, 30));
        this.LABEL = new JLabel(ResourceBundle.getBundle("restringer/gui/General").getString("PLEASE WAIT."));
        this.LABEL.setAlignmentX(0.5f);
        this.LABEL.setAlignmentY(0.5f);
        this.LABEL.setMaximumSize(new Dimension(200, 30));
        this.BAR = new JProgressBar();
        this.BAR.setAlignmentX(0.5f);
        this.BAR.setAlignmentY(0.5f);
        this.TOPPANEL.add(this.LABEL);
        this.BOTTOMPANEL.add(this.BAR);
        this.add(Box.createVerticalGlue());
        this.add(this.TOPPANEL);
        this.add(this.BOTTOMPANEL);
        this.add(Box.createVerticalGlue());
    }

    public void setModel(String title, BoundedRangeModel model) {
        Objects.requireNonNull(title);
        Objects.requireNonNull(model);
        this.BAR.setModel(model);
    }

    static void startWaitCursor(JComponent component) {
        RootPaneContainer root = (RootPaneContainer)((Object)component.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        root.getGlassPane().addMouseListener(NULLMOUSEADAPTER);
        root.getGlassPane().setVisible(true);
    }

    static void stopWaitCursor(JComponent component) {
        RootPaneContainer root = (RootPaneContainer)((Object)component.getTopLevelAncestor());
        root.getGlassPane().setCursor(Cursor.getDefaultCursor());
        root.getGlassPane().removeMouseListener(NULLMOUSEADAPTER);
        root.getGlassPane().setVisible(false);
    }
}

