/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingWorker;
import restringer.Mod;
import restringer.Profile;
import restringer.Timer;
import restringer.esp.ESP;
import restringer.esp.ESPIDMap;
import restringer.esp.StringTable;
import restringer.esp.StringsFile;
import restringer.ess.ESS;
import restringer.ess.Plugin;
import restringer.gui.Configurator;
import restringer.gui.ProgressIndicator;
import restringer.gui.ProgressModel;
import restringer.gui.SaveWindow;

public class Scanner
extends SwingWorker<ESPIDMap, Double> {
    private final SaveWindow WINDOW;
    private final ESS SAVE;
    private final File SKYRIM_DIR;
    private final File MODORGANIZER_DIR;
    private final File NMM_DIR;
    private static final Logger LOG = Logger.getLogger(Scanner.class.getCanonicalName());
    private final WindowAdapter LISTENER = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent e) {
            if (!Scanner.this.isDone()) {
                Scanner.this.cancel(true);
            }
        }
    };

    public Scanner(SaveWindow window, ESS save, File skyrimDir, File moDir, File nmmDir) {
        this.WINDOW = Objects.requireNonNull(window, "The window field must not be null.");
        this.SAVE = Objects.requireNonNull(save, "The save field must not be null.");
        this.SKYRIM_DIR = Objects.requireNonNull(skyrimDir, "The Skyrim directory field must not be null.");
        this.MODORGANIZER_DIR = moDir;
        this.NMM_DIR = nmmDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ESPIDMap doInBackground() throws Exception {
        Timer TIMER = Timer.startNew("Load Plugins");
        ProgressModel MODEL = new ProgressModel();
        ProgressIndicator.startWaitCursor(this.WINDOW.getRootPane());
        this.WINDOW.addWindowListener(this.LISTENER);
        this.WINDOW.startProgressBar(MODEL);
        try {
            List<Plugin> PLUGINS = this.SAVE.getPluginInfo().getPlugins();
            ArrayList<Mod> MODS = new ArrayList<Mod>(256);
            List ESP_NAMES = PLUGINS.stream().map(p -> p.NAME).collect(Collectors.toList());
            List ERR = Collections.synchronizedList(new LinkedList());
            LinkedHashMap PLUGIN_MOD_MAP = new LinkedHashMap(256);
            LinkedHashMap PLUGIN_ESP_MAP = new LinkedHashMap(256);
            ConcurrentHashMap ANALYSES = new ConcurrentHashMap(256);
            LOG.info("Scanning plugins.");
            MODS.add(new Mod(this.SKYRIM_DIR));
            if (null != this.MODORGANIZER_DIR) {
                LOG.info("Checking Mod Organizer.");
                List<Mod> MOMODS = Configurator.analyzeModOrganizer(this.MODORGANIZER_DIR);
                MODS.addAll(MOMODS);
            }
            MODS.forEach(mod -> mod.getESPFiles().forEach(file -> PLUGINS.stream().filter(p -> p.NAME.equalsIgnoreCase(file.getName())).findAny().ifPresent(p -> {
                PLUGIN_MOD_MAP.putIfAbsent(p, mod);
                PLUGIN_ESP_MAP.putIfAbsent(p, file);
            })));
            long totalSize = 0L;
            long[] BYTES_READ = new long[]{0L};
            MODEL.setMaximum((int)((totalSize += PLUGIN_ESP_MAP.values().stream().mapToLong(f -> f.length()).sum()) / 1024L));
            ESPIDMap IDS = new ESPIDMap("global");
            StringTable STRINGS = new StringTable();
            PLUGINS.parallelStream().forEach(plugin -> {
                if (!PLUGIN_ESP_MAP.containsKey(plugin)) {
                    LOG.warning(String.format("Plugin %s is missing.", plugin));
                    return;
                }
                File ESPFILE = (File)PLUGIN_ESP_MAP.get(plugin);
                Mod MOD = (Mod)PLUGIN_MOD_MAP.get(plugin);
                try {
                    List<StringsFile> strings = MOD.readStrings(ESPFILE, "english", true);
                    strings.parallelStream().forEach(v -> STRINGS.populateFromFile((StringsFile)v, plugin.INDEX));
                }
                catch (Mod.StringsReadError ex) {
                    LOG.warning(String.format("Error reading stringtables for plugin %s", plugin));
                    LOG.warning(ex.getMessage());
                }
                Profile.Analysis ANALYSIS = Profile.analyzeMod(MOD);
                ANALYSES.put(plugin, ANALYSIS);
                try {
                    Object espMap = ESP.skimESP(ESPFILE, plugin.INDEX, ESP_NAMES);
                    IDS.addAll((ESPIDMap)espMap);
                    LOG.info(String.format("Scanned plugin: %s", plugin));
                    espMap = BYTES_READ;
                }
                catch (IOException ex) {
                    ERR.add(ESPFILE);
                    LOG.warning(String.format("Error reading plugin: %s.", plugin));
                    LOG.warning(ex.getMessage());
                    System.err.println(ex.getMessage());
                    System.err.println(ex.getMessage());
                    ex.printStackTrace(System.err);
                    return;
                }
                finally {
                    long[] lArray = BYTES_READ;
                    synchronized (BYTES_READ) {
                        BYTES_READ[0] = BYTES_READ[0] + ESPFILE.length();
                        MODEL.setValue((int)(BYTES_READ[0] / 1024L));
                        // ** MonitorExit[var13_16] (shouldn't be in output)
                    }
                }
                synchronized (BYTES_READ) {
                    BYTES_READ[0] = BYTES_READ[0] + ESPFILE.length();
                    MODEL.setValue((int)(BYTES_READ[0] / 1024L));
                    // ** MonitorExit[espMap] (shouldn't be in output)
                    return;
                }
            });
            Profile.Analysis ANALYSIS = PLUGINS.stream().filter(p -> ANALYSES.containsKey(p)).map(p -> (Profile.Analysis)ANALYSES.get(p)).reduce(new Profile.Analysis(), (a1, a2) -> a1.merge((Profile.Analysis)a2));
            if (null != this.SAVE) {
                this.SAVE.addNames(IDS, STRINGS);
                this.WINDOW.setAnalysis(ANALYSIS);
            }
            TIMER.stop();
            LOG.info(String.format("Plugin scanning completed, took %s.", TIMER.getFormattedTime()));
            JOptionPane.showMessageDialog(this.WINDOW, "Done scanning plugins.", "Done", 1);
            if (!ERR.isEmpty()) {
                StringBuilder BUF = new StringBuilder();
                BUF.append("The following plugins could not be read:\n");
                ERR.forEach(p -> BUF.append("\t").append(p.getName()).append("\n"));
                JOptionPane.showMessageDialog(this.WINDOW, BUF.toString(), "Errors", 0);
            }
            ESPIDMap eSPIDMap = IDS;
            return eSPIDMap;
        }
        catch (Error | Exception ex) {
            String MSG = String.format("Error reading plugins. %s", ex.getMessage());
            LOG.severe(MSG);
            LOG.severe(ex.toString());
            System.err.println(ex.getMessage());
            ex.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.WINDOW, MSG, "Read Error", 0);
            ESPIDMap eSPIDMap = null;
            return eSPIDMap;
        }
        finally {
            this.WINDOW.removeWindowListener(this.LISTENER);
            ProgressIndicator.stopWaitCursor(this.WINDOW.getRootPane());
            this.WINDOW.clearProgressBar();
        }
    }
}

