/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.util.Objects;
import restringer.ess.papyrus.MemberData;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.Variable;
import restringer.gui.VariableTableModel;

public class StackFrameTableModel
extends VariableTableModel {
    private final StackFrame FRAME;
    private final int OFFSET;

    public StackFrameTableModel(StackFrame frame) {
        assert (frame.getUnknown2().size() == frame.getFunctionLocals().size() + frame.getFunctionParams().size());
        this.FRAME = Objects.requireNonNull(frame);
        this.OFFSET = this.FRAME.getFunctionParams().size();
    }

    @Override
    protected int getNumVariables() {
        return this.FRAME.getUnknown2().size();
    }

    @Override
    protected Variable getVariable(int index) {
        return this.FRAME.getUnknown2().get(index);
    }

    @Override
    protected MemberData getMemberData(int index) {
        if (index < this.OFFSET) {
            return this.FRAME.getFunctionParams().get(index);
        }
        return this.FRAME.getFunctionLocals().get(index - this.OFFSET);
    }

    @Override
    protected void setVariable(int index, Variable newVar) {
        this.FRAME.getUnknown2().set(index, newVar);
    }

    @Override
    protected boolean supportsMemberData() {
        return true;
    }
}

