/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import restringer.ess.papyrus.Variable;

public abstract class VariableCellEditor
extends AbstractCellEditor
implements TableCellEditor {

    private static final class Bool
    extends VariableCellEditor {
        private final JComboBox<Boolean> EDITER = new JComboBox<Boolean>(new Boolean[]{Boolean.TRUE, Boolean.FALSE});

        public Bool() {
            this.EDITER.setPrototypeDisplayValue(Boolean.FALSE);
        }

        @Override
        public Object getCellEditorValue() {
            Boolean value = (Boolean)this.EDITER.getSelectedItem();
            if (null != value) {
                return new Variable.Bool(value);
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (!(value instanceof Variable.Bool)) {
                return null;
            }
            Variable.Bool var = (Variable.Bool)value;
            this.EDITER.setSelectedItem(var.getValue());
            return this.EDITER;
        }
    }

    private static final class Flt
    extends VariableCellEditor {
        private final JFormattedTextField EDITER = new JFormattedTextField(NumberFormat.getNumberInstance());

        public Flt() {
            this.EDITER.setColumns(5);
        }

        @Override
        public Object getCellEditorValue() {
            Number value = (Number)this.EDITER.getValue();
            if (null != value) {
                return new Variable.Flt(value.floatValue());
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (!(value instanceof Variable.Flt)) {
                return null;
            }
            Variable.Flt var = (Variable.Flt)value;
            this.EDITER.setValue(Float.valueOf(var.getValue()));
            return this.EDITER;
        }
    }

    private static final class Int
    extends VariableCellEditor {
        private final JFormattedTextField EDITER = new JFormattedTextField(NumberFormat.getIntegerInstance());

        public Int() {
            this.EDITER.setColumns(5);
        }

        @Override
        public Object getCellEditorValue() {
            Integer value = (Integer)this.EDITER.getValue();
            if (null != value) {
                return new Variable.Int(value);
            }
            return null;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (!(value instanceof Variable.Int)) {
                return null;
            }
            Variable.Int var = (Variable.Int)value;
            this.EDITER.setValue(var.getValue());
            return this.EDITER;
        }
    }

    private static final class Str
    extends VariableCellEditor {
        private Variable.Str var;
        private final JTextField EDITER = new JTextField(10);

        @Override
        public Object getCellEditorValue() {
            String text = this.EDITER.getText();
            return new Variable.Str(this.var, text);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (!(value instanceof Variable.Str)) {
                return null;
            }
            this.var = (Variable.Str)value;
            this.EDITER.setText(this.var.getValue().toString());
            return this.EDITER;
        }
    }

    public static final class Generic
    extends VariableCellEditor {
        private final Str STR = new Str();
        private final Int INT = new Int();
        private final Flt FLT = new Flt();
        private final Bool BOOL = new Bool();
        private VariableCellEditor subeditor = this.STR;

        @Override
        public Object getCellEditorValue() {
            return this.subeditor.getCellEditorValue();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value instanceof Variable.Str) {
                this.subeditor = this.STR;
            } else if (value instanceof Variable.Int) {
                this.subeditor = this.INT;
            } else if (value instanceof Variable.Flt) {
                this.subeditor = this.FLT;
            } else if (value instanceof Variable.Bool) {
                this.subeditor = this.BOOL;
            } else {
                throw new IllegalStateException();
            }
            return this.subeditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

