/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import java.util.function.Consumer;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import restringer.ess.papyrus.ArrayInfo;
import restringer.ess.papyrus.FunctionMessageData;
import restringer.ess.papyrus.Reference;
import restringer.ess.papyrus.Script;
import restringer.ess.papyrus.ScriptInstance;
import restringer.ess.papyrus.StackFrame;
import restringer.ess.papyrus.Variable;
import restringer.gui.ArrayTableModel;
import restringer.gui.FunctionMessageDataTableModel;
import restringer.gui.ReferenceTableModel;
import restringer.gui.ScriptInstanceTableModel;
import restringer.gui.ScriptTableModel;
import restringer.gui.StackFrameTableModel;
import restringer.gui.VariableCellEditor;
import restringer.gui.VariableCellRenderer;

public class VariableTable
extends JTable {
    private final JPopupMenu TABLE_POPUP_MENU;
    private final JMenuItem MI_FIND = new JMenuItem(RES.getString("VARIABLETABLE FIND"), 70);
    private Consumer<Variable> queryHandler = null;
    private static final ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/General");

    public VariableTable() {
        this.TABLE_POPUP_MENU = new JPopupMenu(RES.getString("VARIABLETABLE TABLE"));
        this.initComponent();
    }

    private void initComponent() {
        this.setSelectionMode(0);
        this.setDefaultRenderer(Variable.class, new VariableCellRenderer());
        this.setDefaultEditor(Variable.class, new VariableCellEditor.Generic());
        this.TABLE_POPUP_MENU.add(this.MI_FIND);
        this.MI_FIND.addActionListener(e -> {
            if (null != this.queryHandler) {
                Variable.Array var;
                int viewRow = this.getSelectedRow();
                int modelRow = this.convertRowIndexToModel(viewRow);
                int column = this.getModel().getColumnCount() - 1;
                Object o = this.getModel().getValueAt(modelRow, column);
                if (o instanceof Variable.RefID) {
                    Variable.RefID var2 = (Variable.RefID)o;
                    if (!var2.getRefID().isZero()) {
                        this.queryHandler.accept(var2);
                    }
                } else if (o instanceof Variable.Array && !(var = (Variable.Array)o).getArrayID().isZero()) {
                    this.queryHandler.accept(var);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Variable.Array var;
                    int row = VariableTable.this.rowAtPoint(e.getPoint());
                    int col = VariableTable.this.columnAtPoint(e.getPoint());
                    VariableTable.this.setRowSelectionInterval(row, row);
                    int modelRow = VariableTable.this.convertRowIndexToModel(row);
                    int column = VariableTable.this.getModel().getColumnCount() - 1;
                    Object o = VariableTable.this.getModel().getValueAt(modelRow, column);
                    if (o instanceof Variable.RefID) {
                        Variable.RefID var2 = (Variable.RefID)o;
                        if (!var2.getRefID().isZero()) {
                            VariableTable.this.TABLE_POPUP_MENU.show(e.getComponent(), e.getX(), e.getY());
                        }
                    } else if (o instanceof Variable.Array && !(var = (Variable.Array)o).getArrayID().isZero()) {
                        VariableTable.this.TABLE_POPUP_MENU.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }
        });
    }

    public void setQueryHandler(Consumer<Variable> newQueryHandler) {
        this.queryHandler = newQueryHandler;
    }

    public void clearTable() {
        this.setModel(new DefaultTableModel());
    }

    public void displayScript(Script script) {
        this.setModel(new ScriptTableModel(script));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
    }

    public void displayScriptInstance(ScriptInstance instance) {
        this.setModel(new ScriptInstanceTableModel(instance));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayArray(ArrayInfo array) {
        this.setModel(new ArrayTableModel(array));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayStackFrame(StackFrame frame) {
        this.setModel(new StackFrameTableModel(frame));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayReference(Reference ref) {
        this.setModel(new ReferenceTableModel(ref));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }

    public void displayFunctionMessageData(FunctionMessageData msg) {
        this.setModel(new FunctionMessageDataTableModel(msg));
        this.getColumn(this.getColumnName(0)).setMinWidth(25);
        this.getColumn(this.getColumnName(0)).setMaxWidth(25);
        this.getColumn(this.getColumnName(1)).setMinWidth(120);
        this.getColumn(this.getColumnName(1)).setMaxWidth(120);
    }
}

