/*
 * Decompiled with CFR 0.152.
 */
package restringer.gui;

import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import restringer.ess.papyrus.MemberData;
import restringer.ess.papyrus.Variable;

public abstract class VariableTableModel
implements TableModel {
    private final List<TableModelListener> LISTENERS = new LinkedList<TableModelListener>();
    private static final ResourceBundle RES = ResourceBundle.getBundle("restringer/gui/General");
    private static final String[] COLUMNNAMES = VariableTableModel.getColumnNames();
    private static final Class<?>[] COLUMNTYPES = VariableTableModel.getColumnTypes();

    protected abstract int getNumVariables();

    protected abstract Variable getVariable(int var1);

    protected abstract MemberData getMemberData(int var1);

    protected abstract void setVariable(int var1, Variable var2);

    protected abstract boolean supportsMemberData();

    @Override
    public int getRowCount() {
        return this.getNumVariables();
    }

    @Override
    public int getColumnCount() {
        return this.supportsMemberData() ? 4 : 3;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        assert (0 <= rowIndex && rowIndex < this.getRowCount());
        Variable var = this.getVariable(rowIndex);
        if (!this.supportsMemberData() && columnIndex == 2) {
            ++columnIndex;
        }
        switch (columnIndex) {
            case 0: {
                return rowIndex;
            }
            case 1: {
                return var.toTypeString();
            }
            case 2: {
                MemberData mb = this.getMemberData(rowIndex);
                return null != mb ? mb.getName() : "";
            }
            case 3: {
                return var;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (!this.supportsMemberData() && columnIndex == 2) {
            ++columnIndex;
        }
        return COLUMNNAMES[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (!this.supportsMemberData() && columnIndex == 2) {
            ++columnIndex;
        }
        return COLUMNTYPES[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.supportsMemberData() && columnIndex != 3) {
            return false;
        }
        if (!this.supportsMemberData() && columnIndex != 2) {
            return false;
        }
        assert (0 <= rowIndex && rowIndex < this.getRowCount());
        Variable var = this.getVariable(rowIndex);
        switch (var.getType()) {
            case STRING: 
            case INTEGER: 
            case FLOAT: 
            case BOOLEAN: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (!this.isCellEditable(rowIndex, columnIndex)) {
            throw new UnsupportedOperationException("Not supported.");
        }
        if (!(aValue instanceof Variable)) {
            throw new UnsupportedOperationException("Not supported.");
        }
        this.setVariable(rowIndex, (Variable)aValue);
        this.fireTableCellUpdate(rowIndex, columnIndex);
    }

    public void fireTableCellUpdate(int row, int column) {
        TableModelEvent event = new TableModelEvent(this, row, row, column, 0);
        this.LISTENERS.forEach(l -> l.tableChanged(event));
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.LISTENERS.add(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.LISTENERS.remove(l);
    }

    private static String[] getColumnNames() {
        return new String[]{RES.getString("VARIABLETABLEMODEL #"), RES.getString("VARIABLETABLEMODEL TYPE"), RES.getString("VARIABLETABLEMODEL NAME"), RES.getString("VARIABLETABLEMODEL VALUE")};
    }

    private static Class<?>[] getColumnTypes() {
        return new Class[]{Integer.class, String.class, String.class, Variable.class};
    }
}

