/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.PrintWriter;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import restringer.IString;
import restringer.pex.Opcode;
import restringer.pex.PexObject;
import restringer.pex.StringTable;
import restringer.pex.TermMap;
import restringer.pex.VData;
import restringer.pex.VariableType;

public class Disassembler {
    static final Pattern AUTOVAR_REGEX = Pattern.compile("^::(.+)_var$", 2);

    static void preMap(List<PexObject.Function.Instruction> block, List<VariableType> locals, List<VariableType> types, TermMap terms) {
        try {
            for (int i = 0; i < block.size(); ++i) {
                boolean del;
                PexObject.Function.Instruction inst = block.get(i);
                if (null == inst || !(del = Disassembler.makeTerm(inst.OPCODE, inst.ARGS, types, terms))) continue;
                block.set(i, null);
            }
        }
        catch (Error | Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    static void disassemble(PrintWriter out, List<PexObject.Function.Instruction> block, List<VariableType> locals, List<VariableType> types, TermMap terms, int indent) {
        Disassembler.preMap(block, locals, types, terms);
        int ptr = 0;
        try {
            while (ptr < block.size()) {
                PexObject.Function.Instruction inst = block.get(ptr);
                if (null == inst) {
                    ++ptr;
                    continue;
                }
                Opcode op = inst.OPCODE;
                if (op.isConditional()) {
                    int[] CONDITIONAL = Disassembler.detectConditional(block, ptr);
                    if (null == CONDITIONAL) {
                        boolean k = false;
                        Disassembler.detectConditional(block, ptr);
                    }
                    assert (null != CONDITIONAL) : "Incorrect conditional block.";
                    int ending = ptr + CONDITIONAL[0];
                    List<PexObject.Function.Instruction> subBlock = block.subList(ptr, ending);
                    Disassembler.disassembleConditional(out, subBlock, locals, types, terms, indent, false);
                    ptr += CONDITIONAL[0];
                    continue;
                }
                Disassembler.disassemble(out, inst, locals, types, terms, indent);
                out.flush();
                ++ptr;
            }
        }
        catch (Error | Exception ex) {
            for (int i = ptr; i < block.size(); ++i) {
                PexObject.Function.Instruction inst = block.get(i);
                if (null != inst) {
                    out.print(Disassembler.tab(indent + 1));
                    out.println(inst);
                    continue;
                }
                out.print(Disassembler.tab(indent + 1));
                out.println("DELETED");
            }
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    static void disassembleConditional(PrintWriter out, List<PexObject.Function.Instruction> block, List<VariableType> locals, List<VariableType> types, TermMap terms, int indent, boolean elseif) {
        int[] CONDITIONAL1 = Disassembler.detectConditional(block, 0);
        if (null == CONDITIONAL1) {
            throw new IllegalArgumentException("Not a conditional block.");
        }
        boolean rhs = false;
        boolean end = false;
        String lhs = "";
        LinkedList<Boolean> stack1 = new LinkedList<Boolean>();
        LinkedList<String> stack2 = new LinkedList<String>();
        for (int ptr = 0; ptr < block.size() && !end; ++ptr) {
            boolean subclause;
            PexObject.Function.Instruction inst = block.get(ptr);
            if (null == inst) continue;
            int[] IF = Disassembler.detectIF(block, ptr);
            int[] WHILE = Disassembler.detectWHILE(block, ptr);
            end = null != IF || null != WHILE;
            Opcode OP = inst.OPCODE;
            if (!OP.isConditional()) {
                throw new IllegalArgumentException("Not a condition block, or not properly stripped.");
            }
            String operator = OP == Opcode.JMPF ? "&&" : "||";
            String term = inst.ARGS.get(0).paren();
            int offset = ((VData.Int)inst.ARGS.get(1)).getValue();
            if (!rhs && !end) {
                lhs = lhs + term + " " + operator + " ";
                rhs = true;
            } else if (!rhs && end) {
                lhs = lhs + term;
            } else if (rhs && !end) {
                lhs = lhs + term;
                while (!stack1.isEmpty() && rhs) {
                    rhs = (Boolean)stack1.pop();
                    lhs = (String)stack2.pop() + "(" + lhs + ")";
                }
                lhs = "(" + lhs + ") " + operator + " ";
            } else if (rhs && end) {
                lhs = lhs + term;
                while (!stack1.isEmpty() && rhs) {
                    rhs = (Boolean)stack1.pop();
                    lhs = (String)stack2.pop() + "(" + lhs + ")";
                }
            }
            boolean bl = subclause = !end && block.subList(ptr + 1, ptr + offset).stream().filter(v -> null != v).anyMatch(v -> v.OPCODE.isConditional());
            if (subclause) {
                stack1.push(rhs);
                stack2.push(lhs);
                rhs = false;
                lhs = "";
            }
            if (!end) continue;
            if (null != IF) {
                List<PexObject.Function.Instruction> subBlock = block.subList(ptr, block.size());
                Disassembler.disassembleIfElseBlock(out, lhs, subBlock, locals, types, terms, indent, elseif);
                return;
            }
            if (null != WHILE) {
                List<PexObject.Function.Instruction> subBlock = block.subList(ptr, block.size());
                Disassembler.disassembleLoop(out, lhs, subBlock, locals, types, terms, indent);
                return;
            }
            throw new IllegalStateException();
        }
        throw new IllegalStateException();
    }

    static void disassembleIfElseBlock(PrintWriter out, String condition, List<PexObject.Function.Instruction> block, List<VariableType> locals, List<VariableType> types, TermMap terms, int indent, boolean elseif) {
        int[] IF = Disassembler.detectIF(block, 0);
        assert (null != IF);
        int offs1 = IF[0];
        int offs2 = IF[1];
        PexObject.Function.Instruction begin = block.get(0);
        PexObject.Function.Instruction end = block.get(offs1 - 1);
        List<PexObject.Function.Instruction> block1 = block.subList(1, offs1 - 1);
        List<PexObject.Function.Instruction> block2 = block.subList(offs1, offs1 + offs2 - 1);
        if (elseif) {
            out.printf("%sELSEIF %s\n", Disassembler.tab(indent), condition);
        } else {
            out.printf("%sIF %s\n", Disassembler.tab(indent), condition);
        }
        Disassembler.disassemble(out, block1, locals, types, terms, indent + 1);
        for (int ptr = 0; ptr < block2.size(); ++ptr) {
            if (block2.get(ptr) == null) {
                continue;
            }
            int[] CONDITIONAL = Disassembler.detectConditional(block2, ptr);
            if (null == CONDITIONAL) break;
            int ending = CONDITIONAL[0];
            List<PexObject.Function.Instruction> subBlock = block2.subList(ptr, ptr + ending);
            Disassembler.disassembleConditional(out, subBlock, types, locals, terms, indent, true);
            return;
        }
        if (offs2 > 1) {
            out.printf("%sELSE\n", Disassembler.tab(indent));
            Disassembler.disassemble(out, block2, locals, types, terms, indent + 1);
            out.printf("%sENDIF\n", Disassembler.tab(indent));
        } else {
            out.printf("%sENDIF\n", Disassembler.tab(indent));
        }
    }

    static void disassembleLoop(PrintWriter out, String condition, List<PexObject.Function.Instruction> block, List<VariableType> locals, List<VariableType> types, TermMap terms, int indent) {
        int[] WHILE = Disassembler.detectWHILE(block, 0);
        int offset = WHILE[0];
        out.print(Disassembler.tab(indent));
        out.printf("WHILE %s\n", condition);
        Disassembler.disassemble(out, block.subList(1, offset - 1), locals, types, terms, indent + 1);
        out.print(Disassembler.tab(indent));
        out.println("ENDWHILE");
        out.flush();
    }

    static int[] detectConditional(List<PexObject.Function.Instruction> block, int ptr) {
        if (block.isEmpty()) {
            return null;
        }
        PexObject.Function.Instruction begin = block.get(ptr);
        if (null == begin || !begin.OPCODE.isConditional()) {
            return null;
        }
        int subptr = ptr;
        while (subptr < block.size()) {
            PexObject.Function.Instruction next = block.get(subptr);
            if (null == next) {
                ++subptr;
                continue;
            }
            int[] IF = Disassembler.detectIF(block, subptr);
            int[] WHILE = Disassembler.detectWHILE(block, subptr);
            if (null != IF) {
                return new int[]{subptr - ptr + IF[0] + IF[1] - 1};
            }
            if (null != WHILE) {
                return new int[]{subptr - ptr + WHILE[0]};
            }
            if (!next.OPCODE.isConditional()) {
                // empty if block
            }
            ++subptr;
        }
        return null;
    }

    static int[] detectIF(List<PexObject.Function.Instruction> instructions, int ptr) {
        if (instructions.isEmpty() || ptr >= instructions.size() || ptr < 0) {
            return null;
        }
        PexObject.Function.Instruction begin = instructions.get(ptr);
        if (null == begin || begin.OPCODE != Opcode.JMPF) {
            return null;
        }
        int offset1 = ((VData.Int)begin.ARGS.get(1)).getValue();
        PexObject.Function.Instruction end = instructions.get(ptr + offset1 - 1);
        if (null == end || end.OPCODE != Opcode.JMP) {
            return null;
        }
        int offset2 = ((VData.Int)end.ARGS.get(0)).getValue();
        if (offset2 <= 0) {
            return null;
        }
        return new int[]{offset1, offset2};
    }

    static int[] detectWHILE(List<PexObject.Function.Instruction> instructions, int ptr) {
        PexObject.Function.Instruction end;
        PexObject.Function.Instruction begin = instructions.get(ptr);
        if (null == begin || begin.OPCODE != Opcode.JMPF) {
            return null;
        }
        int offset1 = ((VData.Int)begin.ARGS.get(1)).getValue();
        if (ptr + offset1 - 1 >= instructions.size()) {
            boolean bl = false;
        }
        if (null == (end = instructions.get(ptr + offset1 - 1)) || end.OPCODE != Opcode.JMP) {
            return null;
        }
        int offset2 = ((VData.Int)end.ARGS.get(0)).getValue();
        if (offset2 > 0) {
            return null;
        }
        assert (offset1 <= -offset2) : String.format("Offsets differ: while(%d), endwhile(%d)", offset1, offset2);
        return new int[]{offset1};
    }

    static void disassemble(PrintWriter out, PexObject.Function.Instruction inst, List<VariableType> locals, List<VariableType> types, TermMap terms, int indent) {
        String RHS = Disassembler.makeRHS(inst, types, terms);
        switch (inst.OPCODE) {
            case NOP: {
                break;
            }
            case IADD: 
            case FADD: 
            case ISUB: 
            case FSUB: 
            case IMUL: 
            case FMUL: 
            case IDIV: 
            case FDIV: 
            case IMOD: 
            case STRCAT: 
            case NOT: 
            case INEG: 
            case FNEG: 
            case ASSIGN: 
            case CAST: 
            case CMP_EQ: 
            case CMP_LT: 
            case CMP_LE: 
            case CMP_GT: 
            case CMP_GE: 
            case ARR_CREATE: 
            case ARR_LENGTH: 
            case ARR_GET: {
                Disassembler.disassembleSimple(out, 0, RHS, inst.ARGS, locals, indent);
                break;
            }
            case CALLMETHOD: 
            case CALLSTATIC: 
            case PROPGET: {
                Disassembler.disassembleSimple(out, 2, RHS, inst.ARGS, locals, indent);
                break;
            }
            case CALLPARENT: 
            case ARR_FIND: 
            case ARR_RFIND: {
                Disassembler.disassembleSimple(out, 1, RHS, inst.ARGS, locals, indent);
                break;
            }
            case RETURN: {
                if (null == RHS) {
                    out.printf("%sRETURN\n", Disassembler.tab(indent));
                    break;
                }
                out.printf("%sRETURN %s\n", Disassembler.tab(indent), RHS);
                break;
            }
            case PROPSET: {
                VData obj = inst.ARGS.get(1);
                VData.ID prop = (VData.ID)inst.ARGS.get(0);
                out.printf("%s%s.%s = %s\n", Disassembler.tab(indent), obj, prop, RHS);
                break;
            }
            case ARR_SET: {
                VData.ID arr = (VData.ID)inst.ARGS.get(0);
                VData idx = inst.ARGS.get(1);
                out.printf("%s%s[%s] = %s\n", Disassembler.tab(indent), arr, idx, RHS);
                break;
            }
            case JMPT: 
            case JMPF: 
            case JMP: {
                boolean k = false;
                throw new IllegalArgumentException("No code for handling this command: " + inst);
            }
        }
    }

    static void disassembleSimple(PrintWriter out, int lhsPos, String rhs, List<VData> args, List<VariableType> locals, int indent) {
        if (lhsPos < 0 || lhsPos >= args.size()) {
            throw new IllegalArgumentException();
        }
        VData lhs = args.get(lhsPos);
        if (null == lhs || lhs instanceof VData.None) {
            out.print(Disassembler.tab(indent));
            out.println(rhs);
            return;
        }
        if (!(lhs instanceof VData.ID)) {
            out.print(Disassembler.tab(indent));
            out.printf("%s = %s\n", lhs, rhs);
            return;
        }
        VData.ID var = (VData.ID)lhs;
        if (var.isTemp()) {
            assert (false);
        } else if (var.isNonevar()) {
            out.print(Disassembler.tab(indent));
            out.println(rhs);
        } else {
            out.print(Disassembler.tab(indent));
            locals.stream().filter(v -> v.name.equals(var.getValue())).findAny().ifPresent(v -> {
                locals.remove(v);
                out.print(v.TYPE + " ");
            });
            out.printf("%s = %s\n", lhs, rhs);
        }
        out.flush();
    }

    static boolean makeTerm(Opcode op, List<VData> args, List<VariableType> types, TermMap terms) {
        switch (op) {
            case IADD: 
            case FADD: 
            case STRCAT: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s + %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ISUB: 
            case FSUB: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s - %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case IMUL: 
            case FMUL: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s * %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case IDIV: 
            case FDIV: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s / %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case IMOD: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s %% %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case RETURN: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case CALLMETHOD: {
                Disassembler.replaceVariables(args, terms, 2);
                VData.ID method = (VData.ID)args.get(0);
                VData obj = args.get(1);
                List subArgs = args.subList(4, args.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                String term = String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
                return Disassembler.processTerm(args, terms, 2, term);
            }
            case CALLPARENT: {
                Disassembler.replaceVariables(args, terms, 1);
                VData.ID method = (VData.ID)args.get(0);
                List subArgs = args.subList(3, args.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                String term = String.format("parent.%s%s", method, Disassembler.paramList(subArgs));
                return Disassembler.processTerm(args, terms, 1, term);
            }
            case CALLSTATIC: {
                Disassembler.replaceVariables(args, terms, 2);
                VData obj = args.get(0);
                VData.ID method = (VData.ID)args.get(1);
                List subArgs = args.subList(4, args.size()).stream().map(v -> v.toString()).collect(Collectors.toList());
                String term = String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
                return Disassembler.processTerm(args, terms, 2, term);
            }
            case NOT: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("!%s", args.get(1).paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case INEG: 
            case FNEG: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("-%s", args.get(1).paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ASSIGN: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("%s", args.get(1));
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CAST: {
                Disassembler.replaceVariables(args, terms, 0);
                VData.ID dest = (VData.ID)args.get(0);
                VData arg = args.get(1);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeTerm$7(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                String term = type.equals(IString.get("bool")) ? arg.toString() : (type.equals(IString.get("string")) ? arg.toString() : String.format("(%s)%s", type, arg.paren()));
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case PROPGET: {
                Disassembler.replaceVariables(args, terms, 2);
                VData obj = args.get(1);
                VData prop = args.get(0);
                String term = String.format("%s.%s", obj, prop);
                return Disassembler.processTerm(args, terms, 2, term);
            }
            case PROPSET: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case CMP_EQ: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s == %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_LT: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s < %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_LE: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s <= %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_GT: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s > %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case CMP_GE: {
                Disassembler.replaceVariables(args, terms, 0);
                VData operand1 = args.get(1);
                VData operand2 = args.get(2);
                String term = String.format("%s >= %s", operand1.paren(), operand2.paren());
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_CREATE: {
                VData size = args.get(1);
                VData.ID dest = (VData.ID)args.get(0);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeTerm$8(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                String subtype = type.toString().substring(0, type.length() - 2);
                String term = String.format("new %s[%s]", subtype, size);
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_LENGTH: {
                Disassembler.replaceVariables(args, terms, 0);
                String term = String.format("%s.length", args.get(1));
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_GET: {
                Disassembler.replaceVariables(args, terms, 0);
                VData idx = args.get(2);
                VData arr = args.get(1);
                String term = String.format("%s[%s]", arr, idx);
                return Disassembler.processTerm(args, terms, 0, term);
            }
            case ARR_SET: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case JMPT: 
            case JMPF: {
                Disassembler.replaceVariables(args, terms, -1);
                return false;
            }
            case ARR_FIND: {
                Disassembler.replaceVariables(args, terms, 1);
                VData arr = args.get(0);
                VData search = args.get(2);
                VData.Int idx = (VData.Int)args.get(3);
                String term = String.format("%s.find(%s, %s)", arr, search, idx);
                return Disassembler.processTerm(args, terms, 1, term);
            }
            case ARR_RFIND: {
                Disassembler.replaceVariables(args, terms, 1);
                VData arr = args.get(0);
                VData search = args.get(2);
                VData.Int idx = (VData.Int)args.get(3);
                String term = String.format("%s.rfind(%s, %s)", arr, search, idx);
                return Disassembler.processTerm(args, terms, 1, term);
            }
        }
        return false;
    }

    static String makeRHS(PexObject.Function.Instruction inst, List<VariableType> types, TermMap terms) {
        switch (inst.OPCODE) {
            case IADD: 
            case FADD: 
            case STRCAT: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s + %s", operand1.paren(), operand2.paren());
            }
            case ISUB: 
            case FSUB: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s - %s", operand1.paren(), operand2.paren());
            }
            case IMUL: 
            case FMUL: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s * %s", operand1.paren(), operand2.paren());
            }
            case IDIV: 
            case FDIV: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s / %s", operand1.paren(), operand2.paren());
            }
            case IMOD: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s %% %s", operand1.paren(), operand2.paren());
            }
            case RETURN: {
                return inst.ARGS.get(0).toString();
            }
            case CALLMETHOD: {
                VData.ID method = (VData.ID)inst.ARGS.get(0);
                VData obj = inst.ARGS.get(1);
                List subArgs = inst.ARGS.subList(4, inst.ARGS.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                return String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
            }
            case CALLPARENT: {
                VData.ID method = (VData.ID)inst.ARGS.get(0);
                List subArgs = inst.ARGS.subList(3, inst.ARGS.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                return String.format("parent.%s%s", method, Disassembler.paramList(subArgs));
            }
            case CALLSTATIC: {
                VData obj = inst.ARGS.get(0);
                VData.ID method = (VData.ID)inst.ARGS.get(1);
                List subArgs = inst.ARGS.subList(4, inst.ARGS.size()).stream().map(v -> v.paren()).collect(Collectors.toList());
                return String.format("%s.%s%s", obj, method, Disassembler.paramList(subArgs));
            }
            case NOT: {
                return String.format("NOT %s", inst.ARGS.get(1).paren());
            }
            case INEG: 
            case FNEG: {
                return String.format("-%s", inst.ARGS.get(1).paren());
            }
            case ASSIGN: {
                return inst.ARGS.get(1).toString();
            }
            case CAST: {
                VData.ID dest = (VData.ID)inst.ARGS.get(0);
                VData arg = inst.ARGS.get(1);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeRHS$12(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                return String.format("(%s)%s", type, arg.paren());
            }
            case PROPGET: {
                VData obj = inst.ARGS.get(1);
                VData prop = inst.ARGS.get(0);
                return String.format("%s.%s", obj, prop);
            }
            case PROPSET: {
                return inst.ARGS.get(2).paren();
            }
            case CMP_EQ: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s == %s", operand1.paren(), operand2.paren());
            }
            case CMP_LT: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s < %s", operand1.paren(), operand2.paren());
            }
            case CMP_LE: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s <= %s", operand1.paren(), operand2.paren());
            }
            case CMP_GT: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s > %s", operand1.paren(), operand2.paren());
            }
            case CMP_GE: {
                VData operand1 = inst.ARGS.get(1);
                VData operand2 = inst.ARGS.get(2);
                return String.format("%s >= %s", operand1.paren(), operand2.paren());
            }
            case ARR_CREATE: {
                VData size = inst.ARGS.get(1);
                VData.ID dest = (VData.ID)inst.ARGS.get(0);
                StringTable.TString name = dest.getValue();
                StringTable.TString type = types.stream().filter((Predicate<VariableType>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$makeRHS$13(restringer.IString restringer.pex.VariableType ), (Lrestringer/pex/VariableType;)Z)((IString)name)).findFirst().get().TYPE;
                String subtype = type.toString().substring(0, type.length() - 2);
                return String.format("new %s[%s]", subtype, size);
            }
            case ARR_LENGTH: {
                return String.format("%s.length", inst.ARGS.get(1));
            }
            case ARR_GET: {
                VData idx = inst.ARGS.get(2);
                VData arr = inst.ARGS.get(1);
                return String.format("%s[%s]", arr, idx);
            }
            case ARR_SET: {
                return inst.ARGS.get(2).paren();
            }
            case JMPT: 
            case JMPF: {
                return inst.ARGS.get(0).paren();
            }
        }
        return String.format("%s", inst.ARGS);
    }

    static boolean processTerm(List<VData> args, TermMap terms, int destPos, String term) {
        if (destPos >= args.size() || !(args.get(destPos) instanceof VData.ID)) {
            return false;
        }
        VData.ID dest = (VData.ID)args.get(destPos);
        if (!dest.isTemp()) {
            return false;
        }
        terms.put(dest, new VData.Term(term));
        return true;
    }

    static void replaceVariables(List<VData> args, TermMap terms, int exclude) {
        for (int i = 0; i < args.size(); ++i) {
            VData arg = args.get(i);
            if (arg instanceof VData.ID) {
                VData.ID id = (VData.ID)arg;
                if (terms.containsKey(id) && i != exclude) {
                    args.set(i, (VData)terms.get(id));
                    continue;
                }
                if (!id.isAutovar()) continue;
                Matcher MATCHER = AUTOVAR_REGEX.matcher(id.toString());
                MATCHER.matches();
                String prop = MATCHER.group(1);
                terms.put(id, new VData.Term(prop));
                args.set(i, (VData)terms.get(id));
                continue;
            }
            if (!(arg instanceof VData.Str)) continue;
            VData.Str str = (VData.Str)arg;
            args.set(i, new VData.StrLit(str.getString().toString()));
        }
    }

    static <T> String paramList(List<T> params) {
        return params.stream().map(p -> p.toString()).collect(Collectors.joining(", ", "(", ")"));
    }

    public static String tab(int n) {
        StringBuilder BUF = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            BUF.append('\t');
        }
        return BUF.toString();
    }

    private static /* synthetic */ boolean lambda$makeRHS$13(IString name, VariableType t) {
        return t.name.equals(name);
    }

    private static /* synthetic */ boolean lambda$makeRHS$12(IString name, VariableType t) {
        return t.name.equals(name);
    }

    private static /* synthetic */ boolean lambda$makeTerm$8(IString name, VariableType t) {
        return t.name.equals(name);
    }

    private static /* synthetic */ boolean lambda$makeTerm$7(IString name, VariableType t) {
        return t.name.equals(name);
    }
}

