/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.DataInput;
import java.io.IOException;
import java.util.Objects;

public enum Opcode {
    NOP(0),
    IADD(3),
    FADD(3),
    ISUB(3),
    FSUB(3),
    IMUL(3),
    FMUL(3),
    IDIV(3),
    FDIV(3),
    IMOD(3),
    NOT(2),
    INEG(2),
    FNEG(2),
    ASSIGN(2),
    CAST(2),
    CMP_EQ(3),
    CMP_LT(3),
    CMP_LE(3),
    CMP_GT(3),
    CMP_GE(3),
    JMP(1),
    JMPT(2),
    JMPF(2),
    CALLMETHOD(-3),
    CALLPARENT(-2),
    CALLSTATIC(-3),
    RETURN(1),
    STRCAT(3),
    PROPGET(3),
    PROPSET(3),
    ARR_CREATE(2),
    ARR_LENGTH(2),
    ARR_GET(3),
    ARR_SET(3),
    ARR_FIND(4),
    ARR_RFIND(4);

    public final int ARGS;
    private static final Opcode[] VALUES;

    public boolean isConditional() {
        return this == JMPT || this == JMPF;
    }

    public boolean isBranching() {
        return this == JMPT || this == JMPF || this == JMP;
    }

    public boolean isArithmetic() {
        return this == IADD || this == FADD || this == ISUB || this == FSUB || this == IMUL || this == FMUL || this == IDIV || this == FDIV || this == IMOD;
    }

    private Opcode(int args) {
        this.ARGS = args;
    }

    static Opcode read(DataInput input) throws IOException {
        Objects.requireNonNull(input);
        int index = input.readUnsignedByte();
        if (index < 0 || index >= VALUES.length) {
            throw new IOException("Invalid Opcode.");
        }
        return VALUES[index];
    }

    static {
        VALUES = Opcode.values();
    }
}

