/*
 * Decompiled with CFR 0.152.
 */
package restringer.pex;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import restringer.IString;
import restringer.pex.AssemblyLevel;
import restringer.pex.PexObject;
import restringer.pex.ScriptStats;
import restringer.pex.StringTable;
import restringer.pex.UserFlag;

public final class Pex {
    public final Header HEADER;
    public final StringTable STRINGS;
    public final DebugInfo DEBUG;
    public final List<UserFlag> USERFLAGDEFS;
    public final PexObject OBJECT;

    public static Pex readScript(byte[] data) throws IOException {
        assert (null != data);
        try (DataInputStream dis = new DataInputStream(new ByteArrayInputStream(data));){
            Pex pex = new Pex(dis);
            return pex;
        }
    }

    public static Pex readScript(File scriptFile) throws FileNotFoundException, IOException {
        try (DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(scriptFile)));){
            Pex pex = new Pex(dis);
            return pex;
        }
    }

    public static void writeScript(Pex script, File scriptFile) throws FileNotFoundException, IOException {
        assert (!scriptFile.exists() || scriptFile.isFile());
        assert (!scriptFile.exists() || scriptFile.canWrite());
        try (DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(scriptFile)));){
            script.write(dos);
        }
    }

    private Pex(DataInput input) throws IOException {
        int flagCount;
        this.HEADER = new Header(input);
        this.STRINGS = new StringTable(input);
        this.DEBUG = new DebugInfo(input, this.STRINGS);
        this.USERFLAGDEFS = new ArrayList<UserFlag>(flagCount);
        for (flagCount = input.readUnsignedShort(); 0 < flagCount; --flagCount) {
            this.USERFLAGDEFS.add(new UserFlag(input, this.STRINGS));
        }
        int objectCount = input.readUnsignedShort();
        if (objectCount != 1) {
            throw new IllegalStateException("Scripts must contain exactly one object.");
        }
        this.OBJECT = new PexObject(input, this.USERFLAGDEFS, this.STRINGS);
    }

    public void write(DataOutput output) throws IOException {
        this.HEADER.write(output);
        this.STRINGS.write(output);
        this.DEBUG.write(output);
        output.writeShort((short)this.USERFLAGDEFS.size());
        for (UserFlag flag : this.USERFLAGDEFS) {
            flag.write(output);
        }
        output.writeShort(1);
        this.OBJECT.write(output);
    }

    public void rebuildStringTable() {
        LinkedHashSet<StringTable.TString> INUSE = new LinkedHashSet<StringTable.TString>();
        this.DEBUG.collectStrings(INUSE);
        this.USERFLAGDEFS.forEach(flag -> flag.collectStrings(INUSE));
        this.OBJECT.collectStrings(INUSE);
        this.STRINGS.rebuildStringTable(INUSE);
    }

    public void disassemble(Writer out, AssemblyLevel level) {
        try (PrintWriter writer = new PrintWriter(out);){
            this.OBJECT.disassemble(writer, level);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.HEADER.toString());
        buf.append(this.DEBUG.toString());
        buf.append("USER FLAGS\n");
        buf.append(this.USERFLAGDEFS.toString());
        buf.append("\n\nOBJECT\n");
        buf.append(this.OBJECT);
        buf.append("\n");
        return buf.toString();
    }

    private IString readIString(DataInput input) throws IOException {
        int index = input.readUnsignedShort();
        if (index < 0 || index >= this.STRINGS.size()) {
            throw new IOException();
        }
        return (IString)this.STRINGS.get(index);
    }

    private void writeIString(IString str, DataOutput output) throws IOException {
        short index = (short)this.STRINGS.indexOf(str);
        output.writeShort(index);
    }

    public long getDate() {
        return this.HEADER.compilationTime;
    }

    public IString getFilename() {
        String SOURCE = this.HEADER.soureFilename;
        String REGEX = "(psc)$";
        String REPLACEMENT = "pex";
        Pattern PATTERN = Pattern.compile("(psc)$", 2);
        Matcher MATCHER = PATTERN.matcher(SOURCE);
        String COMPILED = MATCHER.replaceAll("pex");
        return IString.get(COMPILED);
    }

    public ScriptStats analyze() {
        ScriptStats STATS = new ScriptStats();
        this.OBJECT.analyze(STATS);
        return STATS;
    }

    final class DebugFunction {
        private final StringTable.TString OBJECTNAME;
        private final StringTable.TString STATENAME;
        private final StringTable.TString FUNCNAME;
        private final byte FUNCTYPE;
        private final List<Integer> INSTRUCTIONS;

        private DebugFunction(DataInput input, StringTable strings) throws IOException {
            this.OBJECTNAME = strings.read(input);
            this.STATENAME = strings.read(input);
            this.FUNCNAME = strings.read(input);
            this.FUNCTYPE = input.readByte();
            int instructionCount = input.readUnsignedShort();
            this.INSTRUCTIONS = new ArrayList<Integer>(instructionCount);
            for (int i = 0; i < instructionCount; ++i) {
                this.INSTRUCTIONS.add(input.readUnsignedShort());
            }
        }

        private void write(DataOutput output) throws IOException {
            this.OBJECTNAME.write(output);
            this.STATENAME.write(output);
            this.FUNCNAME.write(output);
            output.writeByte(this.FUNCTYPE);
            output.writeShort(this.INSTRUCTIONS.size());
            for (int instr : this.INSTRUCTIONS) {
                output.writeShort(instr);
            }
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            strings.add(this.OBJECTNAME);
            strings.add(this.STATENAME);
            strings.add(this.FUNCNAME);
        }

        public IString getFullName() {
            return IString.format("%s.%s", this.OBJECTNAME, this.FUNCNAME);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%s %s.%s (type %d): ", this.OBJECTNAME, this.STATENAME, this.FUNCNAME, this.FUNCTYPE));
            this.INSTRUCTIONS.forEach(instr -> buf.append(String.format("%04x ", instr)));
            return buf.toString();
        }
    }

    public final class DebugInfo {
        private byte hasDebugInfo;
        private long modificationTime;
        private final List<DebugFunction> DEBUGFUNCTIONS;

        private DebugInfo(DataInput input, StringTable strings) throws IOException {
            this.hasDebugInfo = input.readByte();
            if (this.hasDebugInfo == 0) {
                this.DEBUGFUNCTIONS = new ArrayList<DebugFunction>(0);
            } else {
                this.modificationTime = input.readLong();
                int functionCount = input.readUnsignedShort();
                this.DEBUGFUNCTIONS = new ArrayList<DebugFunction>(functionCount);
                for (int i = 0; i < functionCount; ++i) {
                    this.DEBUGFUNCTIONS.add(new DebugFunction(input, strings));
                }
            }
        }

        private void write(DataOutput output) throws IOException {
            output.write(this.hasDebugInfo);
            if (this.hasDebugInfo != 0) {
                output.writeLong(this.modificationTime);
                output.writeShort(this.DEBUGFUNCTIONS.size());
                for (DebugFunction function : this.DEBUGFUNCTIONS) {
                    function.write(output);
                }
            }
        }

        public void clear() {
            this.hasDebugInfo = 0;
            this.DEBUGFUNCTIONS.clear();
        }

        public void collectStrings(Set<StringTable.TString> strings) {
            this.DEBUGFUNCTIONS.forEach(func -> func.collectStrings(strings));
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("DEBUGINFO\n");
            this.DEBUGFUNCTIONS.forEach(function -> {
                buf.append("\t");
                buf.append(function.toString());
                buf.append("\n");
            });
            buf.append("\n");
            return buf.toString();
        }
    }

    public final class Header {
        private int magic = 0;
        private int version = 0;
        private long compilationTime = 0L;
        private String soureFilename = "";
        private String userName = "";
        private String machineName = "";

        private Header(DataInput input) throws IOException {
            this.magic = input.readInt();
            this.version = input.readInt();
            this.compilationTime = input.readLong();
            this.soureFilename = input.readUTF();
            this.userName = input.readUTF();
            this.machineName = input.readUTF();
        }

        private void write(DataOutput output) throws IOException {
            output.writeInt(this.magic);
            output.writeInt(this.version);
            output.writeLong(this.compilationTime);
            output.writeUTF(this.soureFilename);
            output.writeUTF(this.userName);
            output.writeUTF(this.machineName);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("%s compiled at %d by %s on %s.\n", this.soureFilename, this.compilationTime, this.userName, this.machineName));
            buf.append(String.format("%h v%d\n\n", this.magic, this.version));
            return buf.toString();
        }
    }
}

